<?php
	/*
	MGB 0.6.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2007 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

	// ================== //
	// install.php - 0.4  //
	// ================== //
	//
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //

	// Show all errors but no warnings
	error_reporting(E_ALL & ~E_NOTICE);

	require ("includes/functions.inc.php");

	if (file_exists("../config.inc.php"))
		{
		include ("../config.inc.php");
		if (isset($mgb_installation_complete) AND (cleanstr($mgb_installation_complete) == TRUE))
			{
			echo "It seems that MGB has already been installed. Quitting. If not, try deleting ''config.inc.php'' in root directory.";
			die();
			}
		}

	// start session
	session_name("sid");
	ini_set('url_rewriter.tags', '');
	session_start();

	if(SID != NULL) { $sid = "?".SID; } else { $sid = NULL; }

	// load template
	require ("includes/load_templates.inc.php");
	require ("includes/config.inc.php");

	// load main template
	$page_body = $content_install_body;
	$page_header = $content_install_header;

	if(isset($_POST['install_language']))
		{
		$_SESSION['install_language'] = $_POST['install_language'];
		}

	if(isset($_SESSION['install_language']))
		{
		require ("../language/".$_SESSION['install_language']."/lang_install.php");
		require ("../language/".$_SESSION['install_language']."/settings.php");

		if(!isset($_POST['step']))
			{
			$page_body = preg_replace("/\{TEMPLATE_STEPS\}/", $content_install_eula, $page_body);
			$page_body = preg_replace("/\{LANG_EULA_EXPL\}/", $lang['eula_expl'], $page_body);
			$page_body = preg_replace("/\{LANG_EULA_AGREE\}/", $lang['eula_agree'], $page_body);
			$page_body = preg_replace("/\{LANG_EULA_DISAGREE\}/", $lang['eula_disagree'], $page_body);
			$page_body = preg_replace("/\{LANG_NEXT_STEP\}/", $lang['next_step'], $page_body);
			}

		if(isset($_POST['step']) AND $_POST['step'] == 1)
			{
			if(isset($_POST['eula_agreement']) AND $_POST['eula_agreement'] == 1)
				{
				switch(version_compare('4.3.0', phpversion())) {
					case -1: $img_php = "<img src=\"template/images/ok.png\" alt=\"OK\">";
						break;
					case 0: $img_php = "<img src=\"template/images/ok.png\" alt=\"OK\">";
						break;
					case 1: $img_php = "<img src=\"template/images/nok.png\" alt=\"NOT OK\">";
						$error_php = 1;
						break;
					}

				switch(version_compare('3.23', mysql_get_client_info())) {
					case -1: $img_mysql = "<img src=\"template/images/ok.png\" alt=\"OK\">";
						break;
					case 0: $img_mysql = "<img src=\"template/images/ok.png\" alt=\"OK\">";
						break;
					case 1: $img_mysql = "<img src=\"template/images/nok.png\" alt=\"NOT OK\">";
						$error_mysql = 1;
						break;
					}

				if(function_exists('imagegd2') OR function_exists('imagegd'))
					{
					$gd_exists_lang = $lang['yes'];
					$img_gd = "<img src=\"template/images/ok.png\" alt=\"OK\">";
					}
				else
					{
					$gd_exists_lang = $lang['no'];
					$img_gd = "<img src=\"template/images/warning.png\" alt=\"WARNING\">";
					$error_gd = 1;
					}

				if(!file_exists("../config.inc.php"))
					{
					$file = fopen("../config.inc.php", "w");
					fclose($file);
					}

				if(is_writable("../config.inc.php"))
					{
					$cfg_writable_lang = $lang['yes'];
					$img_cfg_writable = "<img src=\"template/images/ok.png\" alt=\"OK\">";
					}
				else
					{
					$cfg_writable_lang = $lang['no'];
					$img_cfg_writable = "<img src=\"template/images/nok.png\" alt=\"NOT OK\">";
					$error_writable = 1;
					}
					
				if(ini_get('register_globals') == 1)
					{
					$reg_globals_lang = $lang['active'];
					$img_reg_globals = "<img src=\"template/images/warning.png\" alt=\"WARNING\">";
					$error_reg_globals = 1;
					}
				else
					{
					$reg_globals_lang = $lang['inactive'];
					$img_reg_globals = "<img src=\"template/images/ok.png\" alt=\"OK\">";
					}
					
				$page_body = preg_replace("/\{TEMPLATE_STEPS\}/", $content_install_step1, $page_body);
				$page_body = preg_replace("/\{TEMPLATE_WARNINGS\}/", $content_install_warnings, $page_body);

				if(!isset($errorcode)) { $errorcode = NULL; }

				if(isset($error_gd)) { $page_body = preg_replace("/\{ERROR_3\}/", "<span class=\"install_error_low\">-&nbsp;".$lang['error_3']."</span><br>", $page_body); $show_next_step = 1; $errorcode++; } else { $page_body = preg_replace("/\{ERROR_3\}/", "", $page_body); }
				if(isset($error_reg_globals)) { $page_body = preg_replace("/\{ERROR_5\}/", "<span class=\"install_error_low\">-&nbsp;".$lang['error_5']."</span><br>", $page_body); $show_next_step = 1; $errorcode++; } else { $page_body = preg_replace("/\{ERROR_5\}/", "", $page_body); }
				if(isset($error_php)) { $page_body = preg_replace("/\{ERROR_1\}/", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_1']."</span><br>", $page_body); $show_next_step = 0; $errorcode++; } else { $page_body = preg_replace("/\{ERROR_1\}/", "", $page_body); }
				if(isset($error_mysql)) { $page_body = preg_replace("/\{ERROR_2\}/", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_2']."</span><br>", $page_body); $show_next_step = 0; $errorcode++; } else { $page_body = preg_replace("/\{ERROR_2\}/", "", $page_body); }
				if(isset($error_writable)) { $page_body = preg_replace("/\{ERROR_4\}/", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_4']."</span><br>", $page_body); $show_next_step = 0; $errorcode++; } else { $page_body = preg_replace("/\{ERROR_4\}/", "", $page_body); }
				if(!isset($errorcode)) { $page_body = preg_replace("/\{NO_ERROR\}/", "<span class=\"install_no_error\">-&nbsp;".$lang['no_error']."</span><br>", $page_body); $show_next_step = 1; } else { $page_body = preg_replace("/\{NO_ERROR\}/", "", $page_body); }
				$page_body = preg_replace("/\{ERROR\}/", "", $page_body); 

				$page_body = preg_replace("/\{LANG_THANKS\}/", $lang['thanks'], $page_body);
				$page_body = preg_replace("/\{LANG_EXPL_STEP1\}/", $lang['expl_step1'], $page_body);
				$page_body = preg_replace("/\{LANG_SERVER\}/", /* $lang['srvcfg_server'] */ "&nbsp;", $page_body);
				$page_body = preg_replace("/\{LANG_PHP\}/", $lang['srvcfg_phpversion'], $page_body);
				$page_body = preg_replace("/\{LANG_MYSQL\}/", $lang['srvcfg_mysqlversion'], $page_body);
				$page_body = preg_replace("/\{LANG_GD\}/", $lang['srvcfg_gd'], $page_body);
				$page_body = preg_replace("/\{LANG_CFG_WRITABLE\}/", $lang['srvcfg_writable'], $page_body);
				$page_body = preg_replace("/\{LANG_REG_GLOBALS\}/", $lang['srvcfg_reg_globals'], $page_body);

				$page_body = preg_replace("/\{SRVCFG_SERVER\}/", /* $_SERVER['SERVER_SOFTWARE'] */ "&nbsp;", $page_body);
				$page_body = preg_replace("/\{SRVCFG_PHP\}/", phpversion(), $page_body);
				$page_body = preg_replace("/\{SRVCFG_MYSQL\}/", mysql_get_client_info(), $page_body);
				$page_body = preg_replace("/\{SRVCFG_GD\}/", $gd_exists_lang, $page_body);
				$page_body = preg_replace("/\{SRVCFG_CFG_WRITABLE\}/", $cfg_writable_lang, $page_body);
				$page_body = preg_replace("/\{SRVCFG_REG_GLOBALS\}/", $reg_globals_lang, $page_body);

				$page_body = preg_replace("/\{IMG_PHP\}/", $img_php, $page_body);
				$page_body = preg_replace("/\{IMG_MYSQL\}/", $img_mysql, $page_body);
				$page_body = preg_replace("/\{IMG_GD\}/", $img_gd, $page_body);
				$page_body = preg_replace("/\{IMG_CFG_WRITABLE\}/", $img_cfg_writable, $page_body);
				$page_body = preg_replace("/\{IMG_REG_GLOBALS\}/", $img_reg_globals, $page_body);

				if(isset($show_next_step) AND $show_next_step == 1)
					{
					$next_step = "<form action=\"install.php".$sid."\" method=\"post\">\n";
					$next_step .= "<input type=\"hidden\" name=\"step\" value=\"2\">\n";
					$next_step .= "<input type=\"submit\" class=\"install_button\" name=\"next\" value=\"{LANG_NEXT_STEP}\">\n";
					$next_step .= "</form>";
					$page_body = preg_replace("/\{NEXT_STEP\}/", $next_step, $page_body);
					}
				else
					{
					$page_body = preg_replace("/\{NEXT_STEP\}/", "", $page_body);
					}
				}
			else
				{
				unset ($_SESSION['install_language']);
				}
			}

		if(isset($_POST['step']) AND $_POST['step'] == 2)
			{
			$page_body = preg_replace("/\{TEMPLATE_STEPS\}/", $content_install_step2, $page_body);
			$page_body = preg_replace("/\{LANG_EXPL_STEP2\}/", $lang['expl_step2'], $page_body);
			$page_body = preg_replace("/\{LANG_DB_TITLE\}/", $lang['db_title'], $page_body);
			$page_body = preg_replace("/\{LANG_DB_HOSTNAME\}/", $lang['db_hostname'], $page_body);
			$page_body = preg_replace("/\{LANG_DB_DBNAME\}/", $lang['db_dbname'], $page_body);
			$page_body = preg_replace("/\{LANG_DB_USERNAME\}/", $lang['db_username'], $page_body);
			$page_body = preg_replace("/\{LANG_DB_PASSWORD\}/", $lang['db_password'], $page_body);
			$page_body = preg_replace("/\{LANG_DB_PREFIX\}/", $lang['db_prefix'], $page_body);
			$page_body = preg_replace("/\{LANG_ADMIN_TITLE\}/", $lang['admin_title'], $page_body);
			$page_body = preg_replace("/\{LANG_ADMIN_NAME\}/", $lang['admin_name'], $page_body);
			$page_body = preg_replace("/\{LANG_ADMIN_USERNAME\}/", $lang['admin_username'], $page_body);
			$page_body = preg_replace("/\{LANG_ADMIN_PASSWORD\}/", $lang['admin_password'], $page_body);
			$page_body = preg_replace("/\{LANG_ADMIN_EMAIL\}/", $lang['admin_email'], $page_body);
			$page_body = preg_replace("/\{LANG_ADMIN_GBEMAIL\}/", $lang['admin_gbemail'], $page_body);

			if(!isset($_POST['sent']))
				{
				$page_body = preg_replace("/\{POST_DB_HOSTNAME\}/", "localhost", $page_body);
				$page_body = preg_replace("/\{POST_DB_DBNAME\}/", "", $page_body);
				$page_body = preg_replace("/\{POST_DB_USERNAME\}/", "", $page_body);
				$page_body = preg_replace("/\{POST_DB_PASSWORD\}/", "", $page_body);
				$page_body = preg_replace("/\{POST_DB_PREFIX\}/", "mgb_", $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_NAME\}/", $lang['post_admin_name'], $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_USERNAME\}/", $lang['post_admin_username'], $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_PASSWORD\}/", "", $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_EMAIL\}/", "", $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_GBEMAIL\}/", "noreply@".preg_replace("/\www./", "", $_SERVER["HTTP_HOST"]), $page_body);
				
				$page_body = preg_replace("/\{TEMPLATE_WARNINGS\}/", "", $page_body);
				$page_body = preg_replace("/\{VALUE_STEP\}/", 2, $page_body);
				$page_body = preg_replace("/\{VALUE_SENT\}/", 1, $page_body);
				}
			elseif(isset($_POST['sent']) AND ($_POST['sent'] == 1))
				{
				$_POST['db_hostname'] = cleanstr($_POST['db_hostname']);
				$_POST['db_dbname'] = cleanstr($_POST['db_dbname']);
				$_POST['db_username'] = cleanstr($_POST['db_username']);
				$_POST['db_password'] = cleanstr($_POST['db_password']);
				$_POST['db_prefix'] = cleanstr($_POST['db_prefix']);
				$_POST['admin_name'] = cleanstr($_POST['admin_name']);
				$_POST['admin_username'] = cleanstr($_POST['admin_username']);
				$_POST['admin_password'] = cleanstr($_POST['admin_password']);
				$_POST['admin_email'] = cleanstr($_POST['admin_email']);
				$_POST['admin_gbemail'] = cleanstr($_POST['admin_gbemail']);

				$page_body = preg_replace("/\{POST_DB_HOSTNAME\}/", $_POST['db_hostname'], $page_body);
				$page_body = preg_replace("/\{POST_DB_DBNAME\}/", $_POST['db_dbname'], $page_body);
				$page_body = preg_replace("/\{POST_DB_USERNAME\}/", $_POST['db_username'], $page_body);
				$page_body = preg_replace("/\{POST_DB_PASSWORD\}/", $_POST['db_password'], $page_body);
				$page_body = preg_replace("/\{POST_DB_PREFIX\}/", $_POST['db_prefix'], $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_NAME\}/", $_POST['admin_name'], $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_USERNAME\}/", $_POST['admin_username'], $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_PASSWORD\}/", $_POST['admin_password'], $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_EMAIL\}/", $_POST['admin_email'], $page_body);
				$page_body = preg_replace("/\{POST_ADMIN_GBEMAIL\}/", $_POST['admin_gbemail'], $page_body);

				if(!empty($_POST['db_hostname']) AND !empty($_POST['db_dbname']) AND !empty($_POST['db_username']) AND !empty($_POST['db_password']) AND !empty($_POST['db_prefix']) AND !empty($_POST['admin_name']) AND !empty($_POST['admin_username']) AND !empty($_POST['admin_password']) AND !empty($_POST['admin_email']) AND !empty($_POST['admin_gbemail']))
					{
					// check connection to database
					$link = mysql_connect($_POST['db_hostname'], $_POST['db_username'], $_POST['db_password']);
					$link = mysql_select_db($_POST['db_dbname'], $link);

					if(isset($link) AND ($link == TRUE))
						{
						$sql = "SELECT * FROM ".$_POST['db_prefix']."settings";
						$link = @mysql_connect($_POST['db_hostname'], $_POST['db_username'], $_POST['db_password']) or die ("(load_settings.php) Error: ".mysql_error());
						@mysql_select_db($_POST['db_dbname'], $link) or die ("(load_settings.php) Error: ".mysql_error());
						if(@mysql_query($sql, $link) == FALSE)
							{
							if(check_mail($_POST['admin_email']) AND check_mail($_POST['admin_gbemail']))
								{
								if(check_prefix($_POST['db_prefix']))
									{
									$page_body = preg_replace("/\{TEMPLATE_WARNINGS\}/", $content_install_warnings, $page_body);
									$page_body = preg_replace("/\{ERROR\}/", "", $page_body);
									$page_body = preg_replace("/\{NO_ERROR\}/", "<span class=\"install_no_error\">-&nbsp;".$lang['no_error']."</span><br>", $page_body);
									$page_body = preg_replace("/\{VALUE_STEP\}/", 3, $page_body);
									$page_body = preg_replace("/\{VALUE_SENT\}/", 2, $page_body);

									$_SESSION['db_hostname'] = $_POST['db_hostname'];
									$_SESSION['db_dbname'] = $_POST['db_dbname'];
									$_SESSION['db_username'] = $_POST['db_username'];
									$_SESSION['db_password'] = $_POST['db_password'];
									$_SESSION['db_prefix'] = $_POST['db_prefix'];
									$_SESSION['admin_name'] = $_POST['admin_name'];
									$_SESSION['admin_username'] = $_POST['admin_username'];
									$_SESSION['admin_password'] = $_POST['admin_password'];
									$_SESSION['admin_email'] = $_POST['admin_email'];
									$_SESSION['admin_gbemail'] = $_POST['admin_gbemail'];
									}
								else
									{
									$page_body = preg_replace("/\{TEMPLATE_WARNINGS\}/", $content_install_warnings, $page_body);
									$page_body = preg_replace("/\{ERROR\}/", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_5_step2']."</span><br>", $page_body);
									$page_body = preg_replace("/\{NO_ERROR\}/", "", $page_body);
									$page_body = preg_replace("/\{VALUE_STEP\}/", 2, $page_body);
									$page_body = preg_replace("/\{VALUE_SENT\}/", 1, $page_body);
									}
								}
							else
								{
								$page_body = preg_replace("/\{TEMPLATE_WARNINGS\}/", $content_install_warnings, $page_body);
								$page_body = preg_replace("/\{ERROR\}/", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_2_step2']."</span><br>", $page_body);
								$page_body = preg_replace("/\{NO_ERROR\}/", "", $page_body);
								$page_body = preg_replace("/\{VALUE_STEP\}/", 2, $page_body);
								$page_body = preg_replace("/\{VALUE_SENT\}/", 1, $page_body);
								}
							}
						else
							{
							$page_body = preg_replace("/\{TEMPLATE_WARNINGS\}/", $content_install_warnings, $page_body);
							$page_body = preg_replace("/\{ERROR\}/", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_4_step2']."</span><br>", $page_body);
							$page_body = preg_replace("/\{NO_ERROR\}/", "", $page_body);
							$page_body = preg_replace("/\{VALUE_STEP\}/", 2, $page_body);
							$page_body = preg_replace("/\{VALUE_SENT\}/", 1, $page_body);
							}
						}
					else
						{
						$page_body = preg_replace("/\{TEMPLATE_WARNINGS\}/", $content_install_warnings, $page_body);
						$page_body = preg_replace("/\{ERROR\}/", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_3_step2']."</span><br>", $page_body);
						$page_body = preg_replace("/\{NO_ERROR\}/", "", $page_body);
						$page_body = preg_replace("/\{VALUE_STEP\}/", 2, $page_body);
						$page_body = preg_replace("/\{VALUE_SENT\}/", 1, $page_body);
						}
					}
				else
					{
					$page_body = preg_replace("/\{TEMPLATE_WARNINGS\}/", $content_install_warnings, $page_body);
					$page_body = preg_replace("/\{ERROR\}/", "<span class=\"install_error_critical\">-&nbsp;".$lang['error_1_step2']."</span><br>", $page_body);
					$page_body = preg_replace("/\{NO_ERROR\}/", "", $page_body);
					$page_body = preg_replace("/\{VALUE_STEP\}/", 2, $page_body);
					$page_body = preg_replace("/\{VALUE_SENT\}/", 1, $page_body);
					}

				$page_body = preg_replace("/\{ERROR_1\}/", "", $page_body);
				$page_body = preg_replace("/\{ERROR_2\}/", "", $page_body);
				$page_body = preg_replace("/\{ERROR_3\}/", "", $page_body);
				$page_body = preg_replace("/\{ERROR_4\}/", "", $page_body);
				$page_body = preg_replace("/\{ERROR_5\}/", "", $page_body);
				}
			}
		elseif(isset($_POST['step']) AND ($_POST['step'] == 3))
			{
			require ("mysql.php");

			if($success == 8)
				{
				$config_file = "<?"."php\n\n";
				$config_file .= "\t"."// THIS FILE WAS AUTOMATICALLY GENERATED BY MGB\n";
				$config_file .= "\t"."// DO NOT MODIFY IT!\n\n";
				$config_file .= "\t"."// Database settings\n";
				$config_file .= "\t"."\$db = array();\n\n";
				$config_file .= "\t"."\$db['hostname'] = '".$_SESSION['db_hostname']."';\n";
				$config_file .= "\t"."\$db['dbname'] = '".$_SESSION['db_dbname']."';\n";
				$config_file .= "\t"."\$db['username'] = '".$_SESSION['db_username']."';\n";
				$config_file .= "\t"."\$db['password'] = '".$_SESSION['db_password']."';\n";
				$config_file .= "\t"."\$db['prefix'] = '".$_SESSION['db_prefix']."';\n\n";
				$config_file .= "\t"."\$mgb_installation_complete = TRUE;\n\n";
				$config_file .= "?>";
					
				if(write_config("../config.inc.php", $config_file) == TRUE)
					{
					$success++;
					}
				}

			if($success == 9)
				{
				$page_body = preg_replace("/\{TEMPLATE_STEPS\}/", $content_install_step3, $page_body);
				$page_body = preg_replace("/\{LANG_EXPL_STEP3\}/", $lang['expl_step3'], $page_body);
				$page_body = preg_replace("/\{LANG_TO_ADMINISTRATION\}/", $lang['to_administration'], $page_body);
				$page_body = preg_replace("/\{LANG_IMPORT\}/", $lang['import'], $page_body);
				$page_body = preg_replace("/\{LANG_TO_GUESTBOOK\}/", $lang['to_guestbook'], $page_body);
				}
			else
				{
				$page_body = preg_replace("/\{TEMPLATE_STEPS\}/", $content_install_step3, $page_body);
				$page_body = preg_replace("/\{LANG_EXPL_STEP3\}/", $lang['expl_step3'], $page_body);
				$page_body = preg_replace("/\{LANG_TO_ADMINISTRATION\}/", $lang['to_administration'], $page_body);
				$page_body = preg_replace("/\{LANG_IMPORT\}/", $lang['import'], $page_body);
				$page_body = preg_replace("/\{LANG_TO_GUESTBOOK\}/", $lang['to_guestbook'], $page_body);
				}
			}
		}

	if(!isset($_SESSION['install_language']))
		{
		// choose language for installation
		$path = "../language";
		if($show_directory = opendir($path))
			{
			while($file = readdir($show_directory))
				{
				if ($file != "." && $file != "..")
					{
					if(is_dir($path.'/'.$file))
						{
						include ("../language/".$file."/settings.php");
						if(!isset($install_option_language)) { $install_option_language = NULL; }
						$install_option_language .= "<option value=\"".$file."\">".$language."</option>";
						}
					}
				}
			closedir($show_directory);
			}

		$language_short = "en";
		$lang['h_title'] = "Welcome to the installation of MGB ".MGB_VERSION;
		$charset = "utf-8";
		$lang['title'] = "Installation of MGB ".MGB_VERSION;
		$lang['next_step'] = "&raquo; Next step &raquo;";

		$page_body = preg_replace("/\{TEMPLATE_STEPS\}/", $content_install_choose_language, $page_body);
		$page_body = preg_replace("/\{INSTALL_OPTION_LANGUAGE\}/", $install_option_language, $page_body);
		}

	$page_header = preg_replace("/\{H_LANGUAGE_SHORT\}/", $language_short, $page_header);
	$page_header = preg_replace("/\{H_INSTALL_TITLE\}/", $lang['h_title'], $page_header);
	$page_header = preg_replace("/\{H_CHARSET\}/", $charset, $page_header);

	$page_body = preg_replace("/\{TEMPLATE_HEADER\}/", $page_header, $page_body);
	$page_body = preg_replace("/\{TITLE\}/", $lang['title'], $page_body);
	$page_body = preg_replace("/\{INSTALL_FORM_ACTION\}/", "install.php".$sid, $page_body);
	$page_body = preg_replace("/\{LANG_NEXT_STEP\}/", $lang['next_step'], $page_body);
	$page_body = preg_replace("/\{TEMPLATE_COPYRIGHT\}/", $content_install_copyright, $page_body);
	$page_body = preg_replace("/\{TEMPLATE_FOOTER\}/", $content_install_footer, $page_body);
	$page_body = preg_replace("/\{COPYRIGHT_DATE\}/", date("Y"), $page_body);
	$page_body = preg_replace("/\{MGB_VERSION\}/", MGB_VERSION, $page_body);

	echo $page_body;
?>
