/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import jdbcacsess.sql.ColumnInfo;
import jdbcacsess.sql.DBObjectCatalogs;
import jdbcacsess.sql.DBObjectProcedures;
import jdbcacsess.sql.DBObjectSchemas;
import jdbcacsess.sql.DBObjectTableTypes;
import jdbcacsess.sql.DBObjectTables;

public class CellRendererDataBaseObject
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 7889976104679174292L;
    public static final Font treeFont = new Font("Dialog", 0, 12);
    public static final Font treeFontPrim = new Font("Dialog", 1, 12);
    static final Icon tableIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/table.png"));
    static final Icon schemaIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/schema.png"));
    static final Icon viewIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/view.png"));
    static final Icon procedureIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/procedure.png"));
    static final Icon catalogIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/catalog.png"));
    static final Icon indexIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/index.png"));
    static final Icon tableTypeIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/tableType.png"));

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setOpenIcon(null);
        this.setClosedIcon(null);
        this.setLeafIcon(null);
        this.setFont(treeFont);
        this.setToolTipText("");
        this.setOpaque(false);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object nodeValue = node.getUserObject();
        if (nodeValue != null) {
            if (nodeValue instanceof DBObjectSchemas.DBObjectSchema) {
                this.setNodeIcon(schemaIcon);
            } else if (nodeValue instanceof DBObjectTables.DBObjectTable) {
                DBObjectTables.DBObjectTable table = (DBObjectTables.DBObjectTable)nodeValue;
                if (table.getTableType().toUpperCase().indexOf("TABLE") > -1) {
                    this.setNodeIcon(tableIcon);
                } else if (table.getTableType().toUpperCase().indexOf("VIEW") > -1) {
                    this.setNodeIcon(viewIcon);
                } else if (table.getTableType().toUpperCase().indexOf("INDEX") > -1) {
                    this.setNodeIcon(indexIcon);
                }
            } else if (nodeValue instanceof DBObjectProcedures.DBObjectProcedure) {
                this.setNodeIcon(procedureIcon);
            } else if (nodeValue instanceof DBObjectCatalogs.DBObjectCatalog) {
                this.setNodeIcon(catalogIcon);
            } else if (nodeValue instanceof DBObjectTableTypes.DBObjectTableType) {
                this.setNodeIcon(tableTypeIcon);
            } else if (nodeValue instanceof String && nodeValue.equals("PROCEDURE")) {
                this.setNodeIcon(tableTypeIcon);
            }
            if (ColumnInfo.class.isAssignableFrom(nodeValue.getClass())) {
                ColumnInfo ci = (ColumnInfo)nodeValue;
                if (ci.isPrimaryKey()) {
                    this.setFont(treeFontPrim);
                }
                if (!ci.getColumnComment().equals("")) {
                    this.setToolTipText("<HTML>" + ci.getColumnComment() + "</HTML>");
                }
            }
        }
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        return this;
    }

    void setNodeIcon(Icon icon) {
        this.setOpenIcon(icon);
        this.setClosedIcon(icon);
        this.setLeafIcon(icon);
    }
}

