/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.csv.CsvExport;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvMode;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.gui.CellRendererDataBaseObject;
import jdbcacsess.gui.ComanndBuffer;
import jdbcacsess.gui.JDialogPrepareParameter;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.JTableSql;
import jdbcacsess.gui.JTableSqlModel;
import jdbcacsess.gui.JTextPaneSqlStatement;
import jdbcacsess.gui.common.ActionBase;
import jdbcacsess.gui.common.ConstAutoCommit;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.PrepareExecuteStatement;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.QueryExecuteThread;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.SqlStatementCatgoly;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPanelExecSql
extends JPanel {
    private static final long serialVersionUID = -2404983650883644746L;
    private ComanndBuffer cmdBuff;
    private JTableSqlModel jTableSqlModel;
    private JButton jButtonCsvExport = null;
    private JButton jButtonClear = null;
    private JButton jButtonExecSql = null;
    private JButton jButtonNext = null;
    private JButton jButtonPrev = null;
    private JButton jButtonSelectAbort = null;
    private JButton jButtonSelectContinue = null;
    private JLabel jLabelPageNo = null;
    private JPanel jPanelCommand = null;
    private JPanel jPanelSalStatement = null;
    private JSplitPane jSplitPane = null;
    private JPanel jPanelSqlInput = null;
    private JScrollPane jScrollPaneResults = null;
    private JTableSql jTableResults = null;
    private JTextPaneSqlStatement jTextPaneSqlStatement = null;
    private QueryExecuteThread queryExecute;
    private JScrollPane jScrollPane = null;
    private JLabel jLabelMessage = null;
    private JButton jButtonClose = null;
    private Connection execSqlConnection;
    private JButton jButtonCommit = null;
    private JButton jButtonRollBack = null;
    private boolean autoCommit;
    private JPanel jPanelMessage = null;
    private JLabel jLabelLocation = null;
    private ActionExecSql actionExecSql;
    private ActionCsvExport actionCsvExport;
    private ActionSelectContinue actionSelectContinue;
    private ActionSelectAbort actionSelectAbort;
    private JComboBox jComboBoxAutoCommit = null;
    static final Icon execSqlIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_form-date-field.png"));
    static final Icon prevIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_left.png"));
    static final Icon nextIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_right.png"));
    static final Icon selectAbortIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_stop.png"));
    static final Icon selectContinueIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_insert-fields.png"));
    static final Icon csvExportIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_save-csv.png"));
    static final Icon clearIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_toilet-paper.png"));
    static final Icon closeIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_exit.png"));
    static final Icon commitIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_database.png"));
    static final Icon rollBackIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_data-undo.png"));
    static final Icon connectIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_connect.png"));
    static final Icon disconnectIcon = new ImageIcon(CellRendererDataBaseObject.class.getResource("icons/stock_disconnect.png"));

    public JPanelExecSql(String panelName, boolean autoCommit) {
        this.setName(panelName);
        this.actionExecSql = new ActionExecSql();
        this.actionCsvExport = new ActionCsvExport();
        this.actionSelectContinue = new ActionSelectContinue();
        this.actionSelectAbort = new ActionSelectAbort();
        this.initialize();
        try {
            this.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.jComboBoxAutoCommit.setModel(new DefaultComboBoxModel<ConstAutoCommit>(ConstAutoCommit.values()));
        if (autoCommit) {
            this.jComboBoxAutoCommit.setSelectedItem((Object)ConstAutoCommit.AUTOCOMMIT);
        } else {
            this.jComboBoxAutoCommit.setSelectedItem((Object)ConstAutoCommit.MANUALCOMMIT);
        }
    }

    private void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.execSqlConnection != null) {
            this.execSqlConnection.setAutoCommit(autoCommit);
        }
        if (autoCommit) {
            this.jButtonCommit.setEnabled(false);
            this.jButtonRollBack.setEnabled(false);
        } else {
            this.jButtonCommit.setEnabled(true);
            this.jButtonRollBack.setEnabled(true);
        }
        this.autoCommit = autoCommit;
    }

    private void initialize() {
        this.getJSplitPane();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 400));
        this.add((Component)this.getJSplitPane(), "Center");
        this.add((Component)this.getJPanelMessage(), "South");
        this.add((Component)this.getJPanelCommand(), "North");
        this.cmdBuff = new ComanndBuffer();
        this.displayIdx();
        for (JMenuItem item : this.getJMenu()) {
            this.jTextPaneSqlStatement.insertMenuItem(item, 0);
        }
        this.jTextPaneSqlStatement.insertMenuItem(new JPopupMenu.Separator(), 4);
        for (JMenuItem item : this.getJMenu()) {
            this.jTableResults.insertMenuItem(item, 0);
        }
        this.jTableResults.insertMenuItem(new JPopupMenu.Separator(), 4);
        this.jLabelLocation.setText(this.getCurrentCellPosition());
        this.jButtonExecSql.setIcon(execSqlIcon);
        this.jButtonNext.setIcon(nextIcon);
        this.jButtonPrev.setIcon(prevIcon);
        this.jButtonClear.setIcon(clearIcon);
        this.jButtonSelectAbort.setIcon(selectAbortIcon);
        this.jButtonSelectContinue.setIcon(selectContinueIcon);
        this.jButtonCsvExport.setIcon(csvExportIcon);
        this.jButtonClose.setIcon(closeIcon);
        this.jButtonCommit.setIcon(commitIcon);
        this.jButtonRollBack.setIcon(rollBackIcon);
    }

    List<JMenuItem> getJMenu() {
        ArrayList<JMenuItem> rtn = new ArrayList<JMenuItem>();
        rtn.add(new JMenuItem(this.actionSelectAbort));
        rtn.add(new JMenuItem(this.actionSelectContinue));
        rtn.add(new JMenuItem(this.actionCsvExport));
        rtn.add(new JMenuItem(this.actionExecSql));
        return rtn;
    }

    public JTextPaneSqlStatement getSqlStatement() {
        return this.jTextPaneSqlStatement;
    }

    private void setMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelExecSql.this.jLabelMessage.setText(msg);
            }
        });
        Logger.global.fine(msg);
    }

    private void displayIdx() {
        this.jLabelPageNo.setText("\u5c65\u6b74[" + (this.cmdBuff.getIdx() + 1) + "/" + this.cmdBuff.size() + "]");
    }

    void actionPerformedNext(ActionEvent e) {
        this.jTextPaneSqlStatement.setText(this.cmdBuff.next());
        this.displayIdx();
    }

    void actionPerformedPrev(ActionEvent e) {
        this.jTextPaneSqlStatement.setText(this.cmdBuff.prev());
        this.displayIdx();
    }

    private void actionPerformedClear(ActionEvent e) {
        this.jTextPaneSqlStatement.setText("");
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setDividerSize(7);
            this.jSplitPane.setDividerLocation(120);
            this.jSplitPane.setOneTouchExpandable(true);
            this.jSplitPane.setTopComponent(this.getJPanelSqlInput());
            this.jSplitPane.setBottomComponent(this.getJScrollPaneResults());
        }
        return this.jSplitPane;
    }

    private JButton getJButtonClear() {
        if (this.jButtonClear == null) {
            this.jButtonClear = new JButton();
            this.jButtonClear.setText("");
            this.jButtonClear.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonClear.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u3092\u30af\u30ea\u30a2\u3057\u307e\u3059");
            this.jButtonClear.setName("jButtonClear");
            this.jButtonClear.setFont(new Font("Dialog", 0, 12));
            this.jButtonClear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedClear(e);
                }
            });
        }
        return this.jButtonClear;
    }

    private JButton getJButtonExecSql() {
        if (this.jButtonExecSql == null) {
            this.jButtonExecSql = new JButton(this.actionExecSql);
            this.jButtonExecSql.setText("");
            this.jButtonExecSql.setHorizontalAlignment(2);
            this.jButtonExecSql.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonExecSql.setToolTipText("<HTML>\u5165\u529b\u3055\u308c\u305fSQL\u6587\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002<BR>\u691c\u7d22\u7cfb\u306e\u5834\u5408\u306fSwing\u3068\u7570\u306a\u308b\u30b9\u30ec\u30c3\u30c9\u3067\u5b9f\u884c\u3068\u7d50\u679c\u53d6\u5f97\u304c\u884c\u308f\u308c\u3001\u691c\u7d22\u7d50\u679c\u3092\u9806\u6b21\u753b\u9762\u8868\u793a\u3057\u307e\u3059<BR>\u66f4\u65b0\u7cfb\u306e\u5834\u5408\u306fSwing\u3068\u540c\u4e00\u30b9\u30ec\u30c3\u30c9\u3067\u5b9f\u884c\u3055\u308c\u3001\u66f4\u65b0\u30c7\u30fc\u30bf\u306f\u8868\u793a\u3057\u307e\u305b\u3093</HTML>");
            this.jButtonExecSql.setName("jButtonExecSql");
            this.jButtonExecSql.setFont(new Font("Dialog", 0, 12));
        }
        return this.jButtonExecSql;
    }

    private JButton getJButtonCsvExport() {
        if (this.jButtonCsvExport == null) {
            this.jButtonCsvExport = new JButton(this.actionCsvExport);
            this.jButtonCsvExport.setText("");
            this.jButtonCsvExport.setHorizontalAlignment(10);
            this.jButtonCsvExport.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonCsvExport.setToolTipText("\u5165\u529b\u3055\u308c\u305f\u691c\u7d22SQL\u6587\u3092\u5b9f\u884c\u3057\u3001\u7d50\u679c\u3092CSV\u30d5\u30a1\u30a4\u30eb\u306b\u51fa\u529b\u3057\u307e\u3059\u3002\u753b\u9762\u306f\u66f4\u65b0\u3055\u308c\u307e\u305b\u3093");
            this.jButtonCsvExport.setName("jButtonCsvExport");
            this.jButtonCsvExport.setFont(new Font("Dialog", 0, 12));
        }
        return this.jButtonCsvExport;
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonNext.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u3092\u672a\u6765\u65b9\u5411\u306b\u9032\u3081\u3066\u8868\u793a\u3057\u307e\u3059");
            this.jButtonNext.setName("jButtonNext");
            this.jButtonNext.setFont(new Font("Dialog", 0, 12));
            this.jButtonNext.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedNext(e);
                }
            });
        }
        return this.jButtonNext;
    }

    private JButton getJButtonPrev() {
        if (this.jButtonPrev == null) {
            this.jButtonPrev = new JButton();
            this.jButtonPrev.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonPrev.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u3092\u904e\u53bb\u65b9\u5411\u306b\u9061\u3063\u3066\u8868\u793a\u3057\u307e\u3059");
            this.jButtonPrev.setName("jButtonPrev");
            this.jButtonPrev.setFont(new Font("Dialog", 0, 12));
            this.jButtonPrev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedPrev(e);
                }
            });
        }
        return this.jButtonPrev;
    }

    private JButton getJButtonSelectAbort() {
        if (this.jButtonSelectAbort == null) {
            this.jButtonSelectAbort = new JButton(this.actionSelectAbort);
            this.jButtonSelectAbort.setText("");
            this.jButtonSelectAbort.setFont(new Font("Dialog", 0, 12));
            this.jButtonSelectAbort.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonSelectAbort.setName("jButtonSelectAbort");
            this.jButtonSelectAbort.setToolTipText("\u5927\u91cf\u691c\u7d22\u7d50\u679c\u306e\u70ba\u53d6\u5f97\u3092\u4e2d\u65ad\u3057\u3066\u3044\u308b\u6642\u306b\u4e2d\u6b62\u3057\u307e\u3059");
            this.actionSelectAbort.setEnabled(false);
        }
        return this.jButtonSelectAbort;
    }

    private JButton getJButtonSelectContinue() {
        if (this.jButtonSelectContinue == null) {
            this.jButtonSelectContinue = new JButton(this.actionSelectContinue);
            this.jButtonSelectContinue.setText("");
            this.jButtonSelectContinue.setFont(new Font("Dialog", 0, 12));
            this.jButtonSelectContinue.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonSelectContinue.setName("jButtonSelectContinue");
            this.jButtonSelectContinue.setToolTipText("\u5927\u91cf\u691c\u7d22\u7d50\u679c\u306e\u70ba\u4e2d\u65ad\u3057\u3066\u3044\u308b\u6642\u306b\u7d9a\u304d\u3092\u53d6\u5f97\u3057\u307e\u3059");
            this.actionSelectContinue.setEnabled(false);
        }
        return this.jButtonSelectContinue;
    }

    private JLabel getJLabelPageNo() {
        if (this.jLabelPageNo == null) {
            this.jLabelPageNo = new JLabel();
            this.jLabelPageNo.setFont(new Font("Dialog", 0, 12));
            this.jLabelPageNo.setToolTipText("\u5165\u529b\u3055\u308c\u305fSQL\u6587\u5c65\u6b74\u306e\u73fe\u5728\u4f4d\u7f6e\u3067\u3059\u3002");
            this.jLabelPageNo.setName("jLabelPageNo");
            this.jLabelPageNo.setText("");
        }
        return this.jLabelPageNo;
    }

    private JPanel getJPanelCommand() {
        if (this.jPanelCommand == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            this.jPanelCommand = new JPanel();
            this.jPanelCommand.setLayout(flowLayout1);
            this.jPanelCommand.add((Component)this.getJButtonExecSql(), null);
            this.jPanelCommand.add((Component)this.getJLabelPageNo(), null);
            this.jPanelCommand.add((Component)this.getJButtonPrev(), null);
            this.jPanelCommand.add((Component)this.getJButtonNext(), null);
            this.jPanelCommand.add((Component)this.getJButtonSelectContinue(), null);
            this.jPanelCommand.add((Component)this.getJButtonSelectAbort(), null);
            this.jPanelCommand.add((Component)this.getJButtonCsvExport(), null);
            this.jPanelCommand.add((Component)this.getJButtonClear(), null);
            this.jPanelCommand.add((Component)this.getJButtonClose(), null);
            this.jPanelCommand.add((Component)this.getJButtonCommit(), null);
            this.jPanelCommand.add((Component)this.getJButtonRollBack(), null);
            this.jPanelCommand.add((Component)this.getJComboBoxAutoCommit(), null);
        }
        return this.jPanelCommand;
    }

    private JPanel getJPanelSqlInput() {
        if (this.jPanelSqlInput == null) {
            this.jPanelSqlInput = new JPanel();
            this.jPanelSqlInput.setLayout(new BorderLayout());
            this.jPanelSqlInput.add((Component)this.getJPanelSalStatement(), "Center");
        }
        return this.jPanelSqlInput;
    }

    private JScrollPane getJScrollPaneResults() {
        if (this.jScrollPaneResults == null) {
            this.jScrollPaneResults = new JScrollPane();
            this.jScrollPaneResults.setVerticalScrollBarPolicy(20);
            this.jScrollPaneResults.setHorizontalScrollBarPolicy(30);
            this.jScrollPaneResults.setViewportView(this.getJTableResults());
        }
        return this.jScrollPaneResults;
    }

    private JTableSql getJTableResults() {
        if (this.jTableResults == null) {
            this.jTableResults = new JTableSql();
            this.jTableResults.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    JPanelExecSql.this.jLabelLocation.setText(JPanelExecSql.this.getCurrentCellPosition());
                }
            });
            this.jTableResults.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    JPanelExecSql.this.jLabelLocation.setText(JPanelExecSql.this.getCurrentCellPosition());
                }
            });
        }
        return this.jTableResults;
    }

    private String getCurrentCellPosition() {
        return String.valueOf(this.jTableResults.getSelectedColumn() + 1) + " : " + (this.jTableResults.getSelectedRow() + 1) + "  ";
    }

    private JTextPaneSqlStatement getJTextPaneSqlStatement() {
        if (this.jTextPaneSqlStatement == null) {
            this.jTextPaneSqlStatement = new JTextPaneSqlStatement();
        }
        return this.jTextPaneSqlStatement;
    }

    private JPanel getJPanelSalStatement() {
        if (this.jPanelSalStatement == null) {
            this.jPanelSalStatement = new JPanel();
            this.jPanelSalStatement.setLayout(new BorderLayout());
            this.jPanelSalStatement.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanelSalStatement.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanelSalStatement;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setViewportView(this.getJTextPaneSqlStatement());
        }
        return this.jScrollPane;
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setFont(new Font("Dialog", 0, 12));
            this.jButtonClose.setToolTipText("SQL\u5b9f\u884c\u753b\u9762\u3092\u9589\u3058\u307e\u3059");
            this.jButtonClose.setName("jButtonClose");
            this.jButtonClose.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedSelectClose();
                }
            });
        }
        return this.jButtonClose;
    }

    private void actionPerformedSelectClose() {
        this.disconnect();
        JFrameMain jFrameMain = (JFrameMain)JFrameMain.serachComponent(this, JFrameMain.class);
        jFrameMain.getTabWinManager().disposePanel(this);
    }

    public void disconnect() {
        this.actionSelectAbort.actionPerformed(null);
        new Thread(){

            public void run() {
                SqlExec.disconnect(JPanelExecSql.this.execSqlConnection);
                JPanelExecSql.this.execSqlConnection = null;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JPanelExecSql.this.jLabelLocation.setIcon(disconnectIcon);
                    }
                });
            }
        }.start();
    }

    private JButton getJButtonCommit() {
        if (this.jButtonCommit == null) {
            this.jButtonCommit = new JButton();
            this.jButtonCommit.setText("");
            this.jButtonCommit.setFont(new Font("Dialog", 0, 12));
            this.jButtonCommit.setToolTipText("commit\u3057\u307e\u3059\u3002\u4f46\u3057\u3001ManualCommit\u3067SQL\u5b9f\u884c\u753b\u9762\u3092\u958b\u3044\u305f\u6642\u306e\u307f\u6709\u52b9\u3067\u3059");
            this.jButtonCommit.setName("jButtonCommit");
            this.jButtonCommit.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonCommit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedCommit();
                }
            });
        }
        return this.jButtonCommit;
    }

    private void actionPerformedCommit() {
        if (this.execSqlConnection != null) {
            this.setMessage("Commit\u3092\u958b\u59cb\u3057\u307e\u3059... ");
            new Thread(){

                public void run() {
                    try {
                        JPanelExecSql.this.execSqlConnection.commit();
                        JPanelExecSql.this.setMessage("Commit\u3057\u307e\u3057\u305f");
                    }
                    catch (SQLException e) {
                        JDialogMessage.sqlErrorDialog(e, "Commit\u3067\u30a8\u30e9\u30fc\u767a\u751f");
                    }
                }
            }.start();
        }
    }

    private void actionPerformedRollBack() {
        if (this.execSqlConnection != null) {
            this.setMessage("RollBack\u3092\u958b\u59cb\u3057\u307e\u3059... ");
            new Thread(){

                public void run() {
                    try {
                        JPanelExecSql.this.execSqlConnection.rollback();
                        JPanelExecSql.this.setMessage("RollBack\u3057\u307e\u3057\u305f");
                    }
                    catch (SQLException e) {
                        JDialogMessage.sqlErrorDialog(e, "RollBack\u3067\u30a8\u30e9\u30fc\u767a\u751f");
                    }
                }
            }.start();
        }
    }

    private JButton getJButtonRollBack() {
        if (this.jButtonRollBack == null) {
            this.jButtonRollBack = new JButton();
            this.jButtonRollBack.setText("");
            this.jButtonRollBack.setFont(new Font("Dialog", 0, 12));
            this.jButtonRollBack.setToolTipText("rollback\u3057\u307e\u3059\u3002\u4f46\u3057\u3001ManualCommit\u3067SQL\u5b9f\u884c\u753b\u9762\u3092\u958b\u3044\u305f\u6642\u306e\u307f\u6709\u52b9\u3067\u3059");
            this.jButtonRollBack.setName("jButtonRollBack");
            this.jButtonRollBack.setMargin(new Insets(0, 0, 0, 0));
            this.jButtonRollBack.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPanelExecSql.this.actionPerformedRollBack();
                }
            });
        }
        return this.jButtonRollBack;
    }

    private JPanel getJPanelMessage() {
        if (this.jPanelMessage == null) {
            this.jLabelLocation = new JLabel();
            this.jLabelLocation.setText("");
            this.jLabelLocation.setIcon(disconnectIcon);
            this.jLabelMessage = new JLabel();
            this.jLabelMessage.setText(" ");
            this.jLabelMessage.setFont(new Font("Dialog", 0, 14));
            this.jPanelMessage = new JPanel();
            this.jPanelMessage.setLayout(new BorderLayout());
            this.jPanelMessage.add((Component)this.jLabelLocation, "West");
            this.jPanelMessage.add((Component)this.jLabelMessage, "Center");
        }
        return this.jPanelMessage;
    }

    private JComboBox getJComboBoxAutoCommit() {
        if (this.jComboBoxAutoCommit == null) {
            this.jComboBoxAutoCommit = new JComboBox();
            this.jComboBoxAutoCommit.setName("jComboBoxAutoCommit");
            this.jComboBoxAutoCommit.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ConstAutoCommit item = (ConstAutoCommit)((Object)JPanelExecSql.this.jComboBoxAutoCommit.getSelectedItem());
                    try {
                        JPanelExecSql.this.setAutoCommit(item.getValue());
                    }
                    catch (SQLException err) {
                        JDialogMessage.sqlErrorDialog(err, "AutoCommit\u8a2d\u5b9a");
                    }
                }
            });
        }
        return this.jComboBoxAutoCommit;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReciveStatus
    implements QueryExecuteListener {
        JTableSqlModel jtsm;
        boolean selectUpdatable;
        String errorReasonMsg;

        public ReciveStatus() {
            this.jtsm = null;
        }

        public ReciveStatus(JTableSqlModel jtsm) {
            this.jtsm = jtsm;
        }

        @Override
        public void init() {
            if (this.jtsm != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JPanelExecSql.this.jTableSqlModel = ReciveStatus.this.jtsm;
                        JPanelExecSql.this.jTableResults.setModel(JPanelExecSql.this.jTableSqlModel);
                    }
                });
            }
        }

        @Override
        public void setResultHeader(ArrayList<ColumnInfoResult> rowData, final SqlAnalyze sqlAnalyze, boolean selectUpdatable) {
            this.selectUpdatable = selectUpdatable;
            this.errorReasonMsg = sqlAnalyze.getErrorReasonMsg();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JFrameMain jFrameMain = (JFrameMain)JFrameMain.serachComponent(JPanelExecSql.this, JFrameMain.class);
                    if (jFrameMain != null) {
                        jFrameMain.getTabWinManager().getPane().setPaneTitleName(JPanelExecSql.this, String.valueOf(JPanelExecSql.this.getName()) + ":" + sqlAnalyze.getSchemaTableName().getCompleteTableName());
                    }
                }
            });
        }

        private String msg(QueryExecuteStatus breakStatus) {
            if (breakStatus.getSource() == JPanelExecSql.this.actionCsvExport) {
                return "";
            }
            if (this.selectUpdatable) {
                return "\u7d50\u679c\u66f4\u65b0\u53ef\u80fd\uff1a";
            }
            return String.valueOf(this.errorReasonMsg) + "\uff1a";
        }

        @Override
        public void completeQuery(QueryExecuteStatus breakStatus) {
            Logger.global.fine("BreakStatus\u53d7\u4fe1" + breakStatus.toString());
            JPanelExecSql.this.setMessage(String.valueOf(this.msg(breakStatus)) + breakStatus.getCnt() + (breakStatus.isComplete() ? "\u884c\u53d6\u5f97\u307e\u3057\u305f" : "\u884c\u3067\u7d50\u679c\u53d6\u5f97\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f"));
            this.resetActionStatus();
        }

        @Override
        public void status(QueryExecuteStatus breakStatus) {
            Logger.global.fine("BreakStatus\u53d7\u4fe1" + breakStatus.toString());
            JPanelExecSql.this.setMessage(String.valueOf(this.msg(breakStatus)) + "\u7d50\u679c\u53d6\u5f97\u4e2d..." + breakStatus.getCnt() + "\u884c");
        }

        @Override
        public void errorException(Exception obj) {
            if (obj instanceof SQLException) {
                JDialogMessage.sqlErrorDialog((SQLException)obj, "\u691c\u7d22\u7d50\u679c\u53d6\u5f97");
            } else {
                JDialogMessage.errorDialog(obj);
            }
            this.resetActionStatus();
        }

        private void resetActionStatus() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JPanelExecSql.this.actionSelectAbort.setEnabled(false);
                    JPanelExecSql.this.actionSelectContinue.setEnabled(false);
                    JPanelExecSql.this.actionCsvExport.setEnabled(true);
                    JPanelExecSql.this.actionExecSql.setEnabled(true);
                }
            });
        }

        @Override
        public void setResultDetail(ArrayList<Object> rowData) throws IOException {
        }
    }

    abstract class ActioinExecute
    extends ActionBase {
        private static final long serialVersionUID = -243818453050400696L;

        ActioinExecute(String name) {
            super(name);
        }

        public final void actionPerformed(ActionEvent e) {
            JPanelExecSql.this.execSqlConnection = this.checkConnect();
            if (JPanelExecSql.this.execSqlConnection == null) {
                return;
            }
            JPanelExecSql.this.setMessage(" ");
            SqlAnalyze sa = this.checkStatement(this.getSqlStatementCatgolys());
            if (sa == null) {
                return;
            }
            if (!this.execute(sa)) {
                return;
            }
            JPanelExecSql.this.cmdBuff.add(sa.getSqlStatement());
            JPanelExecSql.this.displayIdx();
            JPanelExecSql.this.jTextPaneSqlStatement.undoDiscard();
        }

        abstract boolean execute(SqlAnalyze var1);

        abstract SqlStatementCatgoly[] getSqlStatementCatgolys();

        private Connection checkConnect() {
            if (!SqlExec.isConnect()) {
                JDialogMessage.notConnectErrorDialog();
                JPanelExecSql.this.execSqlConnection = null;
                JPanelExecSql.this.jLabelLocation.setIcon(disconnectIcon);
                return null;
            }
            if (JPanelExecSql.this.execSqlConnection == null) {
                try {
                    JPanelExecSql.this.execSqlConnection = SqlExec.getNewConnection();
                    JPanelExecSql.this.execSqlConnection.setAutoCommit(JPanelExecSql.this.autoCommit);
                    JPanelExecSql.this.jLabelLocation.setIcon(connectIcon);
                }
                catch (SQLException e1) {
                    JDialogMessage.sqlErrorDialog(e1, "connect\u5931\u6557");
                    JPanelExecSql.this.jLabelLocation.setIcon(disconnectIcon);
                    return null;
                }
            }
            return JPanelExecSql.this.execSqlConnection;
        }

        private SqlAnalyze checkStatement(SqlStatementCatgoly[] sqlStatementCatgolys) {
            SqlAnalyze sa = new SqlAnalyze(JPanelExecSql.this.jTextPaneSqlStatement.getText());
            boolean flg = false;
            int i = 0;
            while (i < sqlStatementCatgolys.length) {
                if (sqlStatementCatgolys[i].equals((Object)sa.getSqlStatementCatgoly())) {
                    flg = true;
                    break;
                }
                ++i;
            }
            if (!flg) {
                String str = "";
                int i2 = 0;
                while (i2 < sqlStatementCatgolys.length) {
                    if (i2 != 0) {
                        str = String.valueOf(str) + ' ';
                    }
                    str = String.valueOf(str) + (Object)((Object)sqlStatementCatgolys[i2]);
                    ++i2;
                }
                JDialogMessage.errorDialog(new Exception(String.valueOf(str) + " \u306e\u307f\u5b9f\u884c\u51fa\u6765\u307e\u3059"));
                return null;
            }
            return sa;
        }
    }

    class ActionExecSql
    extends ActioinExecute {
        private static final long serialVersionUID = -6660910166029768221L;

        ActionExecSql() {
            super("SQL\u5b9f\u884c");
        }

        ActionExecSql(String str) {
            super(str);
        }

        SqlStatementCatgoly[] getSqlStatementCatgolys() {
            SqlStatementCatgoly[] sql = new SqlStatementCatgoly[]{SqlStatementCatgoly.SELECT, SqlStatementCatgoly.INSERT, SqlStatementCatgoly.DELETE, SqlStatementCatgoly.UPDATE, SqlStatementCatgoly.CALL};
            return sql;
        }

        boolean execute(SqlAnalyze sa) {
            if (sa.getSqlStatementCatgoly() == SqlStatementCatgoly.SELECT || sa.getSqlStatementCatgoly() == SqlStatementCatgoly.CALL) {
                JPanelExecSql.this.actionCsvExport.setEnabled(false);
                JPanelExecSql.this.actionExecSql.setEnabled(false);
                JTableSqlModel jtsm = new JTableSqlModel(JPanelExecSql.this.execSqlConnection);
                JPanelExecSql.this.queryExecute = new QueryExecuteThread(this, sa, JPanelExecSql.this.execSqlConnection);
                JPanelExecSql.this.queryExecute.setBinaryDatalimit(true);
                JPanelExecSql.this.queryExecute.addQueryExecuteListener(new ReciveStatus(jtsm));
                JPanelExecSql.this.queryExecute.addQueryExecuteListener(jtsm);
                JPanelExecSql.this.queryExecute.addQueryExecuteListener(JPanelExecSql.this.jTableResults.new JTableSql.registCellRendererAndEditor());
                JPanelExecSql.this.actionSelectAbort.setEnabled(true);
                JPanelExecSql.this.actionSelectContinue.setEnabled(true);
                new Thread(JPanelExecSql.this.queryExecute).start();
                return true;
            }
            final PrepareExecuteStatement pe = new PrepareExecuteStatement();
            try {
                JDialogPrepareParameter jdpp;
                pe.addStm(sa.getSqlStatement());
                pe.prepare(JPanelExecSql.this.execSqlConnection);
                if (pe.isHavingInputParameter() && !(jdpp = new JDialogPrepareParameter(pe)).isExecuteAns()) {
                    return false;
                }
            }
            catch (SQLException e) {
                JDialogMessage.sqlErrorDialog(e, "select\u4ee5\u5916\u306e\u30b3\u30de\u30f3\u30c9\u5b9f\u884c");
                return false;
            }
            catch (JdbcacsessException e) {
                JDialogMessage.errorDialog(e);
                return false;
            }
            new Thread(){

                public void run() {
                    try {
                        int cnt = 0;
                        cnt = pe.executeUpdate();
                        JPanelExecSql.this.setMessage(String.valueOf(cnt) + "\u884c\u51e6\u7406\u3057\u307e\u3057\u305f");
                    }
                    catch (SQLException e) {
                        JDialogMessage.sqlErrorDialog(e, "select\u4ee5\u5916\u306e\u30b3\u30de\u30f3\u30c9\u5b9f\u884c");
                    }
                }
            }.start();
            return true;
        }
    }

    class ActionCsvExport
    extends ActioinExecute {
        private static final long serialVersionUID = -6872871029493035488L;

        public ActionCsvExport() {
            super("CSV\u51fa\u529b...");
        }

        SqlStatementCatgoly[] getSqlStatementCatgolys() {
            SqlStatementCatgoly[] sql = new SqlStatementCatgoly[]{SqlStatementCatgoly.SELECT, SqlStatementCatgoly.CALL};
            return sql;
        }

        boolean execute(SqlAnalyze sa) {
            CsvInfo csvInfo = new CsvInfo();
            csvInfo.currentDataLoad();
            csvInfo.setPropTableName(sa.getSchemaTableName());
            JDialogCsv dlg = new JDialogCsv(CsvMode.EXPORT, csvInfo);
            csvInfo = dlg.getCsvInfo();
            if (csvInfo == null) {
                return false;
            }
            JPanelExecSql.this.actionCsvExport.setEnabled(false);
            JPanelExecSql.this.actionExecSql.setEnabled(false);
            JPanelExecSql.this.queryExecute = new QueryExecuteThread(this, sa, JPanelExecSql.this.execSqlConnection);
            JPanelExecSql.this.queryExecute.addQueryExecuteListener(new CsvExport(csvInfo));
            JPanelExecSql.this.queryExecute.addQueryExecuteListener(new ReciveStatus());
            JPanelExecSql.this.actionSelectAbort.setEnabled(true);
            new Thread(JPanelExecSql.this.queryExecute).start();
            return true;
        }
    }

    class ActionSelectAbort
    extends ActionBase {
        private static final long serialVersionUID = 3905192537275202747L;

        ActionSelectAbort() {
            super("\u53d6\u5f97\u4e2d\u6b62");
        }

        public void actionPerformed(ActionEvent e) {
            if (JPanelExecSql.this.queryExecute != null) {
                JPanelExecSql.this.queryExecute.setCancelFlg();
            }
            if (JPanelExecSql.this.jTableSqlModel != null) {
                JPanelExecSql.this.jTableSqlModel.nextSearch();
            }
        }
    }

    class ActionSelectContinue
    extends ActionBase {
        private static final long serialVersionUID = 6826069816727830380L;

        ActionSelectContinue() {
            super("\u7d99\u7d9a\u53d6\u5f97");
        }

        public void actionPerformed(ActionEvent e) {
            if (JPanelExecSql.this.jTableSqlModel != null) {
                JPanelExecSql.this.jTableSqlModel.nextSearch();
            }
        }
    }
}

