/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.gui.common.ConstSqlTypes;
import jdbcacsess.sql.ColumnInfoParameter;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.ExecuteSqlFactory;
import jdbcacsess.sql.PrepareExecuteCallable;
import jdbcacsess.sql.SqlAnalyze;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteSqCallable
extends ExecuteSqlFactory {
    private PrepareExecuteCallable prepareExecute = null;
    private ResultSet resultSet;
    private boolean haveParameter = false;
    private boolean haveResultSet = false;
    private SqlAnalyze sqlAnalyze;
    private Connection connection;

    public ExecuteSqCallable(Object source, SqlAnalyze SqlAnalyze2, Connection connection) {
        super(source);
        this.sqlAnalyze = SqlAnalyze2;
        this.connection = connection;
    }

    @Override
    SqlAnalyze getSqlAnalyze() {
        return this.sqlAnalyze;
    }

    @Override
    boolean initMethod() throws SQLException, Exception {
        this.prepareExecute = new PrepareExecuteCallable();
        this.prepareExecute.addStm(this.getSqlAnalyze().getSqlStatement());
        this.prepareExecute.prepare(this.connection);
        if (!this.solveParameter(this.prepareExecute)) {
            return false;
        }
        ParameterMetaData pmd = this.prepareExecute.getPrepared().getParameterMetaData();
        if (pmd == null) {
            throw new JdbcacsessException("getParameterMetaData() \u306e\u623b\u308a\u5024\u304c null \u3067\u3057\u305f\u3002");
        }
        int i = 1;
        while (i < pmd.getParameterCount() + 1) {
            int mode = pmd.getParameterMode(i);
            if (mode == 2 || mode == 4 || mode == 5) {
                ColumnInfoParameter colInfo = new ColumnInfoParameter(i, "Parameter" + Integer.valueOf(i).toString(), pmd.getParameterType(i), pmd.getParameterTypeName(i), pmd.isNullable(i), pmd.getParameterClassName(i), pmd.getPrecision(i), pmd.getScale(i), mode);
                this.getSqlMappingInfo().search(colInfo, this.isBinaryDatalimit());
                this.selectColmunInfos.add(colInfo);
                if (colInfo.getSqlType() == ConstSqlTypes.NUMERIC || colInfo.getSqlType() == ConstSqlTypes.DECIMAL) {
                    this.prepareExecute.getPrepared().registerOutParameter(i, colInfo.getSqlType().getValue(), colInfo.getScale());
                } else {
                    this.prepareExecute.getPrepared().registerOutParameter(i, colInfo.getSqlType().getValue());
                }
                this.haveParameter = true;
            }
            ++i;
        }
        if (this.prepareExecute.execute()) {
            this.resultSet = this.prepareExecute.getPrepared().getResultSet();
            this.getHeaderFromResultSet(this.resultSet, this.selectColmunInfos);
            this.haveResultSet = true;
        }
        return true;
    }

    @Override
    boolean hasNext() throws SQLException {
        if (!this.haveParameter && !this.haveResultSet) {
            return false;
        }
        boolean rtn = false;
        if (this.haveParameter && this.getCnt() == 0) {
            rtn = true;
        }
        if (this.haveResultSet) {
            rtn |= this.resultSet.next();
        }
        return rtn;
    }

    @Override
    ArrayList<Object> getResultDetail() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ColumnInfoResult cir : this.selectColmunInfos) {
            if (!(cir instanceof ColumnInfoParameter)) break;
            Object o = null;
            if (this.getCnt() == 0) {
                o = this.prepareExecute.getPrepared().getObject(((ColumnInfoParameter)cir).columnIndex);
            }
            list.add(o);
        }
        if (this.haveResultSet) {
            this.getDetailFromResultSet(this.resultSet, list);
        }
        return list;
    }

    @Override
    void endMethod() {
        try {
            if (this.prepareExecute != null) {
                this.prepareExecute.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

