package org.dyndns.nuda.dynamic.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import org.dyndns.nuda.dynamic.compiler.resolver.AutoResolver;
import org.dyndns.nuda.management.RUN_STATE;
import org.dyndns.nuda.plugin.SysPluginLoader;

/**
 * 文字列からクラスオブジェクトを生成するためのコンパイルエンジンです
 * 
 * @author nkoseki
 * 
 */
public class CompileEngine {
	
	private static RUN_STATE state = RUN_STATE.SLEEP;
	
	public static CompileEngine getInstance(final SourceBean sourceBean) {
		return new CompileEngine(sourceBean);
	}
	
	public static CompileEngine getInstance(final SourceResolver resolver) {
		return new CompileEngine(resolver);
	}
	
	public static CompileEngine getInstance(final SourceResolver resolver,
			final Object target) {
		return new CompileEngine(resolver, target);
	}
	
	public static CompileEngine getInstance(
			final Object target) {
		if(state.equals(RUN_STATE.SLEEP)) {
			
			new SysPluginLoader().loadPlugin(SourceResolver.class);
			
			state = RUN_STATE.RUNNING;
		}
		AutoResolver resolver = AutoResolver.getInstance();
		//AutoResolver.addResolver(new TextSourceResolver());
		
		
		return new CompileEngine(resolver, target);
	}
	
	public static CompileEngine getInstance(final String className,
			final String sourceCode) {
		return new CompileEngine(className, sourceCode);
	}
	
	private String		className;
	
	private String		sourceCode;
	
	private CompileTask	task;
	
	private Class<?>	compiledClass;
	
	private CompileEngine() {
		this.task = new CompileTask();
	}
	
	private CompileEngine(final SourceBean sourceBean) {
		this();
		this.className = sourceBean.getClassName();
		this.sourceCode = sourceBean.getSourceCode();
	}
	
	private CompileEngine(final SourceResolver resolver) {
		this();
		SourceBean sourceBean = resolver.resolve();
		this.className = sourceBean.getClassName();
		this.sourceCode = sourceBean.getSourceCode();
	}
	
	private CompileEngine(final SourceResolver resolver, final Object target) {
		this();
		//System.out.println(target.getClass());
		resolver.setTarget(target);
		SourceBean sourceBean = resolver.resolve();
		this.className = sourceBean.getClassName();
		this.sourceCode = sourceBean.getSourceCode();
	}
	
	private CompileEngine(final String className, final String sourceCode) {
		this();
		this.className = className;
		this.sourceCode = sourceCode;
	}
	
	public CompileEngine compile() {
		this.compiledClass = this.task.compile(this.className, this.sourceCode);
		return this;
	}
	
	public <T> T createCompiledInstance() {
		return this.createCompiledInstance(new Class<?>[] {}, new Object[] {});
	}
	
	public <T> T createCompiledInstance(final Class<?>[] paramTypes,
			final Object[] paramValues) {
		if (this.compiledClass == null) {
			return null;
		} else {
			try {
				
				Class<T> targetClass = this.getCompiledClass();
				
				if (targetClass == null) {
					return null;
				}
				
				Constructor<T> constructor = targetClass
						.getDeclaredConstructor(paramTypes);
				
				T result = constructor.newInstance(paramValues);
				return result;
			} catch (SecurityException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				return null;
			} catch (NoSuchMethodException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				return null;
			} catch (IllegalArgumentException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				return null;
			} catch (InstantiationException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				return null;
			} catch (IllegalAccessException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				return null;
			} catch (InvocationTargetException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
				return null;
			} catch (ClassCastException e) {
				e.printStackTrace();
				return null;
			}
			
		}
	}
	
	@SuppressWarnings("unchecked")
	public <T> Class<T> getCompiledClass() {
		
		Class<T> result = null;
		try {
			if (this.compiledClass == null) {
				return null;
			}
			
			result = (Class<T>) this.compiledClass;
		} catch (ClassCastException e) {
			e.printStackTrace();
			return null;
		}
		
		return result;
	}
	
}
