package org.dyndns.nuda.logger;

import java.util.LinkedList;
import java.util.List;

import org.dyndns.nuda.management.RUN_STATE;
import org.dyndns.nuda.plugin.SysPluginLoader;

public class AutoLoggerAdaptorResolver implements LogAdaptorResolver {
	
	private static List<LogAdaptorResolver>	resolvers	=
														new LinkedList<LogAdaptorResolver>();
	
	private static RUN_STATE state = RUN_STATE.SLEEP;
	
	public static AutoLoggerAdaptorResolver newInstance() {
		if(state.equals(RUN_STATE.SLEEP)) {
//			SysPluginLoader.initializePluginLoader();
			
			new SysPluginLoader().loadPlugin(LogAdaptorResolver.class);
			
//			resolvers.add(new SLF4JLogAdaptorResolver());
//			resolvers.add(new LOG4JLogAdaptorResolver());
//			resolvers.add(new JDKLogAdaptorResolver());
			// NOP-Adaptor-Resolverを追加
			//resolvers.add(new NOPLogAdaptorResolver());
			state = RUN_STATE.RUNNING;
		}
		return new AutoLoggerAdaptorResolver();
	}
	
	public static void addLogAdaptorResolver(LogAdaptorResolver resolver) {
		if(resolver != null) {
			System.out.println("AutoLoggerAdaptorResolver:次のリゾルバを追加します:" + resolver.getClass().getCanonicalName());
			resolvers.add(resolver);
		}
	}
	
	private AutoLoggerAdaptorResolver() {

	}
	
	@Override
	public boolean accept() {
		for (LogAdaptorResolver resolver : resolvers) {
			boolean result = resolver.accept();
			if (result) {
				return true;
			}
		}
		return false;
	}
	
	@Override
	public LoggerAdaptor getAdaptor() {
		
		for (LogAdaptorResolver resolver : resolvers) {
			boolean result = resolver.accept();
			if (result) {
				return resolver.getAdaptor();
			}
		}
		return new NOPLogAdaptorResolver().getAdaptor();
		//return null;
	}

	@Override
	public void init() {
		// TODO Auto-generated method stub
		
	}
	
}
