# An Avatar for Indie Games using MineCraft skins.

* This is a brief description of a relatively simple, portable and open-source-friendly method to program an avatar in any programming language.  This example uses Ada.

* This approach encapsulates the details of avatar shape, color, and movement within GLSL shaders and a related code object that defines vertices and texture maps.  The object may be an Ada package or C++ class.

* Programmatic inputs include uniforms for time, position, and attitude.  The shaders then offload the realtime computational burdens onto the graphics processor.

* Data that defines shape and color, as well as the uniforms and functions that define behavior, reside completely within the object and shaders.  This data can ultimately be as detailed and refined as your imagination permits.  And any refinements made are not obfuscated in some esoteric or proprietary format with a limited audience, but remain fully portable and easily enhanced by most any developer using mainstream programming tools.

* One approach could be to completely define the avatar within the shaders alone, possibly without using any texture files.  (See glslsandbox.com).  But debugging is awkward, and this would require advanced GLSL skills.

* A huge selection of available MineCraft skins lead to the present avatar object design.

    ------------
   /           /|
  /           / |
 /           /  |
------------/  /|
|  head     | / |
|           |/  |
------------/  /|
| torso     | / |
|           |/| | <--Rarm
------------/ | |
|     |     | | |
|Lleg | Rleg| | /
|     |     | |/
|     |     | /
-------------/
* In this example, the texture object is a cube with radius one that is defined as 6 disjoint cubelets.  The 2 upper quarters map to the head and torso.  The lower half is divided into 4 cubelets that are mapped to arms and legs.  The Minecraft images used for the texture also have 6 parts that map to the rectangular limbs, head and torso.

![screenshot](./cuboid.jpg "Cuboid")


* The result is an utterly portable avatar defined by an image and 4 text files:
	* texture object body, avatarobj.adb
	* texture object spec, avatarobj.ads
	* vertex shader, avatarobj.vs
	* fragment shader, avatarobj.fs
	* any MineCraft Skin png file

* Interfacing game code with such an avatar is simple.  Essentially you need only pass the required uniform values prior to drawing.

* Of course one still needs a decent camera positioning and pointing policy within the game code in order to fully appreciate and exhibit the avatar.

* Get the details and full source code at:  https://github.com/fastrgv/AdaVenture, but note that this avatar project was incidental to the game development, and not designed as a tutorial.

