#version 330 core

in vec2 UV;
out vec4 color;

uniform float mytime;

uniform sampler2D myTextureSampler;

const float pi = 3.14159;


void main() {

	// try sinusoidal distortions:
	float x0=UV.x;
	float y0=UV.y;
	const float delta=0.0005;
	const int ndiv=60;
	float x1 = 4*mytime + 2*pi*ndiv*x0;
	float y1 = 4*mytime + 2*pi*ndiv*y0;
	float x2 = sin(x1)*delta;
	float y2 = sin(y1)*delta;
	float x3 = x0+x2;
	float y3 = y0+y2;
	vec2 uv = vec2( x3, y3 ); //distorted


	//color = texture( myTextureSampler, UV );
	color = texture( myTextureSampler, uv );

	//color.a = 0.6;

}


