#!/bin/sh


if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# using Xcode compiler...
# first, create oal.o:
g++ adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal


#--------------------------------------------------------

# set path to AdaCore gnat compiler...
# or delete next line if gnat is visible:
export PATH=$HOME/opt/GNAT/2020/bin:$PATH




gnatmake $1 \
-O3  \
-mmacosx-version-min=10.13 \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adainclude \
-I$PWD/adainclude/fakeTime \
-I$PWD/adabindings/fake00 \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-largs -lm -lz -lc++ \
oal.o \
$PWD/libs/osx/libgnatcoll.a \
$PWD/libs/osx/libgpr.a \
\
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework OpenAL \
-pthread


mv $1 ./bin/osx/

# this option is illustrative but FTTB unnecessary:
# -mmacosx-version-min=10.13 \


# -- Copyright (C) 2021  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

