// This program was written by Jrgen Hoffmann in the year 2009
// and compiled under Borland C++ Version 3.1 using the Tiny model
//
#include <dos.h>
#ifdef __BORLANDC__
#include <mem.h>
#endif
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <io.h>

#define STDIN  0
#define DOS         0x21
#define GETVECT     0x35

#define INT_FIRST 0x60
#define INT_LAST  0x80
#define PD_DRIVER_INFO	0x1ff
#define PD_ACCESS 	0x200
#define PD_RELEASE	0x300
#define PD_SEND		0x400
#define PD_GET_ADDRESS	0x600
#define  CARRY 		1	        /* carry bit in flags register */
#define ETHMAX 1500

typedef unsigned short word;            /* 16 bits */
typedef unsigned char  byte;            /*  8 bits */

char *version  = "V1.1";
int  verbose   = 0;
int  autolen   = 0;
int  datalen   = 0;
word pkt_interrupt;
word int_first = INT_FIRST;
word int_last  = INT_LAST;
word pkt_type  = 0xFFFF;	        /* any packet type */
char *pkt_line = "PKT DRVR";
byte eth_addr[ 6 ] ;
byte use_addr[ 6 ] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
byte dst_addr[ 6 ] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
byte src_addr[ 6 ] = { 0, 0, 0, 0, 0, 0 };
word len_typ   = 0x88B5;                /* local experimental */
byte payload[ ETHMAX ] = { 0, 0, 0, 0 };

char *eadr2asc(unsigned char *p) {
  static char outbuf[20];
  char *p2;
  int i;
  for(i=0, p2=outbuf; i<6; i++, p++) { sprintf(p2,"%02X:",*p); p2 += 3; }
  p2--;
  *p2 = '\0';
  return(outbuf);
  }

int pkt_init(void)
{
    struct REGPACK regs, regs2;
    char far *temp;
    int pd_type;	                /* packet driver type */
    int pd_class;

    for (pkt_interrupt = int_first; pkt_interrupt <= int_last; ++pkt_interrupt ) {
      temp = (char far *)getvect( pkt_interrupt );
      if (!_fmemcmp( &(temp[3]), pkt_line, strlen( pkt_line ))) break;
      }
    if ( pkt_interrupt > int_last ) {
      printf("NO PACKET DRIVER FOUND ");
      if(int_first==int_last) printf("AT INTERRUPT 0x%02X\n",int_first);
      else printf("IN RANGE 0x%02X .. 0x%02X\n",int_first,int_last);
      exit(2);
      }
    /* lets find out about the driver */
    regs.r_ax = PD_DRIVER_INFO;
    intr( pkt_interrupt, &regs );

    /* handle old versions, assume a class and just keep trying */
    if (regs.r_flags & CARRY ) {
      for ( pd_class = 0; pd_class < 19; ++pd_class ) {
	for (pd_type = 1; pd_type < 128; ++pd_type ) {
	  regs.r_ax = PD_ACCESS | pd_class;  /* ETH, SLIP */
	  regs.r_bx = pd_type;		/* type */
	  regs.r_dx = 0;			/* if number */
	  regs.r_cx = sizeof( pkt_type);
	  regs.r_ds = FP_SEG( &pkt_type );
	  regs.r_si = FP_OFF( &pkt_type );
	  regs.r_es = FP_SEG( NULL );
	  regs.r_di = FP_OFF( NULL );
	  intr( pkt_interrupt, &regs );
	  if ( ! (regs.r_flags & CARRY) ) break;
	  }

	if (pd_type < 128 ) {
	  /* get ethernet address */
	  regs.r_ax = PD_GET_ADDRESS;
	  regs.r_bx = regs.r_ax;	/* handle */
	  regs.r_es = FP_SEG( eth_addr );
	  regs.r_di = FP_OFF( eth_addr );
	  regs.r_cx = sizeof( eth_addr );
	  intr( pkt_interrupt, &regs );
	  /* we have found a working type, so kill it */
	  regs.r_ax = PD_RELEASE;
	  intr( pkt_interrupt, &regs );
	  if(verbose) printf("Found OLD type of packet driver\n");
	  break;
	  }

	if ((pd_type == 128 ) && (pd_class > 18)) {
	  printf("ERROR initializing packet driver\n\r");
	  return( 1 );
	  }
	}
      }
      else {
	pd_type = regs.r_dx;
	pd_class = regs.r_cx >> 8;
	/* get ethernet address */
	regs.r_ax = PD_GET_ADDRESS;
	regs.r_bx = 0;
	regs.r_es = FP_SEG( eth_addr );
	regs.r_di = FP_OFF( eth_addr );
	regs.r_cx = sizeof( eth_addr );
	intr( pkt_interrupt, &regs );
	if(verbose) printf("Found packet driver\n");
	}
    if(verbose) printf("Vector=%02X class=%d type=%d ethernet address=%s\n",
	    pkt_interrupt, pd_class, pd_type, eadr2asc(eth_addr));
    return( 0 );
  }


int pkt_send( char *buffer, int length )
{
    struct REGPACK regs;
    int retries;

    retries = 5;
    while (retries--) {
	regs.r_ax = PD_SEND;
	regs.r_ds = FP_SEG( buffer );
	regs.r_si = FP_OFF( buffer );
	regs.r_cx = length;
	intr( pkt_interrupt, &regs );
	if ( regs.r_flags & CARRY ) continue;
	return( 0 );
    }
    return( 1 );
}

void help_text(void) {
  printf("\n\n\n");
  printf("ETHSEND %s by Jrgen Hoffmann (2009) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n",version);
  printf("  usage: ethsend [ options ] [ data ... ]\n\n");
  printf("  valid options:\n");
  printf("    /I<int> define packet driver interrupt  (default: automatic)\n");
  printf("    /D<dst> define destination address      (default: broadcast)\n");
  printf("    /S<dst> define source address           (default: own address)\n");
  printf("    /T<typ> define type (hex)               (default: 88B5)\n");
  printf("    /L<len> define length (decimal) or /L0: calculate automatically\n");
  printf("    /V      verbose\n");
  printf("    /h /?   print this help text\n\n");
  printf("    (Payload-)Data may be piped-in via stdin or specified as argument\n");
  printf("    As argument it may be ASCII or HEX.  (e.g. text\\Hf7b302\\Axyz)\n");
  printf("          \\H: switches to hex-mode\n");
  printf("          \\A: switches to ascii-mode (the default)\n\n");
  }

word htoi(char *p, int count) {
  int i;
  for(i=0; *p && count; p++,count--) {
    if(!isxdigit(*p)) break;
    i <<= 4;
    if(isdigit(*p)) i |= (*p&0x0F);
    else i |= ((*p&0X0F) + 9);
    }
  return(i);
  }

void get_eth_addr(char *p, byte *d) {
  int i;
  for(i=0; *p && i < 6; i++) {
    *d++ = htoi(p,2);
    p += 2;
    if((*p==':')||(*p=='-')) p++;
    }
  }

word swap(word arg) {
  return((arg & 0xFF00) >> 8) | ((arg & 0xFF) << 8);
  }

void main(int argc, char *argv[]) {

int  i, mode, ch;
char *p;

  for(i = 1; i < argc; i++)
    if(*argv[i]=='-' || *argv[i]=='/') {
      p = argv[i];
      switch(toupper(p[1])) {
	case 'D': get_eth_addr(&p[2],dst_addr);               break;
	case 'I': if(isdigit(p[2])) {
		    if(toupper(p[3])=='X') int_first = htoi(&p[4],2);
		    else int_first = atoi(&p[2]);
		    int_last = int_first;
		    }                                         break;
	case 'L': if(isdigit(p[2])) len_typ = atoi(&p[2]);
		  if(!len_typ) autolen++; 	              break;
	case 'S': get_eth_addr(&p[2],use_addr);      	      break;
	case 'T': if(isxdigit(p[2])) len_typ = htoi(&p[2],4); break;
	case 'V': verbose++;                                  break;
	case 'H':
	case '?': help_text(); exit(1);
	} /* switch */
      } /* if */
    else {
      mode = 0;
      p = argv[i];
      while(*p && (datalen < 1500)) {
	if(*p == '\\') {
	  p++;
	  if(toupper(*p)=='A')      mode = 0;
	  else if(toupper(*p)=='H') mode = 1;
	  else if(!mode) payload[datalen++] = *p++;
	  p++;
	  }
	else {
	  if(mode) { payload[datalen++] = htoi(p,2); p +=2; }
	  else payload[datalen++] = *p++;
	  }
	}
      }

  if(!(stdin->flags&_F_TERM)) {  // stdin is NOT Terminal
    setmode(STDIN,O_BINARY);
    while((ch = getc(stdin)) != EOF)
      if(datalen < 1500) payload[datalen++] = ch&0XFF;
    }

  pkt_init();
  if(use_addr[0]==0xFF) memcpy(src_addr, eth_addr, sizeof(src_addr));
  else memcpy(src_addr, use_addr, sizeof(src_addr));
  if(autolen) {
    if(datalen < 46) datalen = 46;
    len_typ = datalen;
    }
  len_typ = swap(len_typ);
  if(verbose) {
    printf("sending packet: DST=%s",eadr2asc(dst_addr));
    printf(" SRC=%s TYP=%04X LEN=%d\n",eadr2asc(src_addr),swap(len_typ),datalen);
    }
  pkt_send(dst_addr,datalen+14);
}
