// This program was written by Jrgen Hoffmann in the year 2009
// and compiled under Borland C++ Version 3.1
// using the Small model and the "Compile via assembler" option
//
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <conio.h>

#define MAXBUFS     8  	                /* maximum number of Ethernet buffers */
#define BPMASK      7
#define BUFSIZE     1520

#define DOS         0x21
#define GETVECT     0x35

#define INT_FIRST 0x60
#define INT_LAST  0x80
#define PD_DRIVER_INFO	0x1ff
#define PD_ACCESS 	0x200
#define PD_RELEASE	0x300
#define PD_SEND 	0x400
#define PD_GET_ADDRESS	0x600
#define PD_RESET        0x700
#define PD_SET_MODE	0x1400
#define CARRY 		1	        /* carry bit in flags register */

#if defined __TINY__
#define MEMORY_MODEL	"ti"
#elif defined __SMALL__
#define MEMORY_MODEL	"sm"
#elif defined __MEDIUM__
#define MEMORY_MODEL	"me"
#elif defined __COMPACT__
#define MEMORY_MODEL	"co"
#elif defined __LARGE__
#define MEMORY_MODEL	"la"
#else
#define MEMORY_MODEL	"??"
#endif

char *version  = "V1.2";

typedef unsigned short word;            /* 16 bits */
typedef unsigned char  byte;            /*  8 bits */

typedef byte ethernet_address[6];
typedef byte ip_address[4];

typedef struct {
  word             srcport;
  word             dstport;
  word             size;
  word             udpchs;
  byte             opcode;
  byte             htype;
  byte             hlen;
  byte             hops;
  unsigned long    id;
  word             sec;
  word             dummy;
  ip_address       client;
  ip_address       own;
  ip_address       server;
  ip_address       gateway;
  byte             hwad[16];
  char             srvname[64];
  char             bootfile[128];
  ip_address       cooky;
  byte             data[60];
  } udp_icmp_header;

typedef struct {
  word             hardware;
  word             protocol;
  byte             hlen;
  byte             plen;
  word             opcode;
  ethernet_address hsrc;
  ip_address       psrc;
  ethernet_address hdst;
  ip_address       pdst;
  } arp_header;

typedef struct {
  byte          VersHL;
  byte          Tos;
  word          TLen;
  word          id;
  word          FlgOff;
  byte          ttl;
  byte          prot;
  word          ChsHd;
  ip_address    src;
  ip_address    dst;
  } ip_header;

typedef struct {
  word             chs;
  word             len;
  byte             tcl;
  byte             typ;
  byte             dstnet[4];
  ethernet_address dstnode;
  word             dstsock;
  byte             srcnet[4];
  ethernet_address srcnode;
  word             srcsock;
  } ipx_header;

typedef union {
  ip_header        ip;
  ipx_header       ipx;
  arp_header       arp;
  } header_union;

typedef struct {
  word             dsss;
  byte             ctrl;
  header_union     h;
  } llc_header;

typedef struct {
  word             dsss;
  byte             ctrl;
  byte             orgacode[3];
  word             typ;
  header_union     h;
  } snap_header;

typedef union {
  byte             data[1500];
  header_union     e2;
  llc_header       llc;
  snap_header      snap;
  } ethernet_body;

typedef struct {
  ethernet_address dst;
  ethernet_address src;
  word             typ;
  ethernet_body    b;
  } ethernet_frame;

#define ETHERNET_II     1
#define ETHERNET_SNAP   2
#define ETHERNET_802_2  3
#define ETHERNET_802_3  4

#define IPX             1
#define IP              2
#define ARP             3
#define RARP            4

typedef struct {
  ethernet_address ea;
  ip_address       ia;
  } address_struct;

typedef struct {
  unsigned long    count;
  byte             flg;
  byte             idx;
  address_struct   src[3];
  } table_item;

typedef struct {
  byte        px;
  byte        py;
  byte        typ;
  char       *txt;
  table_item  itm;
  } main_table_item;

#define MAIN_TABLE_SIZE 18
main_table_item mtbl[MAIN_TABLE_SIZE] = {
  { 1,3,0,"EN_II:"}, {15,3,1,"IPX:"},  {27,3,2,"IP:"},
  {38,3,2,"ARP:"},   {50,3,2,"RARP:"}, {63,3,3,"Others: "},
  { 1,4,0,"SNAP: "}, {15,4,1,"IPX:"},  {27,4,2,"IP:"},
  {38,4,2,"ARP:"},   {50,4,2,"RARP:"}, {63,4,3,"Others: "},
  { 1,5,0,"802.2:"}, {15,5,1,"IPX:"},  {63,5,4,"Others: "},
  { 1,6,0,"802.3:"}, {15,6,1,"IPX:"},  {63,6,0,"Unknown:"}
  };

struct {
  byte             typ;
  unsigned long    count;
  byte             flg;
  byte             idx;
  address_struct   src[20];
  } dtbl;

#define IPTBLSIZE 24
typedef struct {
  byte             ipcnt;
  byte             flag;
  ethernet_address eadr;
  ip_address       ipad[4];
  } iptable_item;

struct {
  word             adcount;
  iptable_item     data[IPTBLSIZE];
  } iptbl = { 0 };

typedef struct {
  ip_header  iph;
  byte       ipd[1024];
  } ip_frame;

byte dhcp_found     = 0;
ip_address dhcpcky  = { 99, 130, 83, 99 };
ip_address null_adr = { 0, 0, 0, 0 };
ip_address net_mask = { 0, 0, 0, 0 };
ip_address net_adr  = { 0, 0, 0, 0 };
ip_address gate_way = { 0, 0, 0, 0 };
int ip_tblscroll    = 0;

byte lcnt    = 0;
char life[6] = "-\\|/";
byte showidx = 255;
byte procmod = 0;
word frame_type;
word protocol_type;
word protocol_code;
ip_header *iphd;

// forwards and externs
char *eadr2asc(unsigned char *p, int mode);

unsigned long      last_time;
unsigned long      curr_time;
unsigned long far *timer = (unsigned long *)MK_FP(0X0040,0X006C);
byte  update = 0;

byte  capabilities;
word  int_first  = INT_FIRST;
word  int_last   = INT_LAST;
word  pkt_interrupt;
word  pkt_type   = 0XFFFF;                /* any tape */
word  pkt_handle;
ethernet_address eth_addr;
char *pkt_line   = "PKT DRVR";
byte  old_driver = 0;
ethernet_address broadcast = { 0XFF,0XFF,0XFF,0XFF,0XFF,0XFF };

typedef struct {
  word  pkt_len;
  byte  pkt_data[BUFSIZE];
  } pkt_buffer;

char speed[16] = "???";
unsigned t0,t1;
unsigned long bytes_rcv = 0L;
unsigned long pkt_found = 0L;
unsigned long pkt_read  = 0L;
unsigned long pkt_lost  = 0L;
word  pkt_get           = 0;
word  pkt_put           = 0;
word  pkt_seq           = 0;
pkt_buffer pb[MAXBUFS];

// compiled with Borland C++  3.1
// with "Compile via assembler" option
// in Options | Compiler | Code generation ...
void far pkt_callback(void) {
  asm {
    pop  di; // compensate for compiler generated PUSH DI / POP DI
    push ds;                   // save driver's data segment
    mov  di,DGROUP;            // NOT in huge model !!!
    mov  ds,di;                // set C's data segment
    }
  disable();
  if(_AX) {
    pb[pkt_put & BPMASK].pkt_len |= 0X8000;
    pkt_put++;
    }
  else {
    pkt_found++;
    bytes_rcv += ( _CX + 12 );  // compensate for preamble and trailer
    if(pb[pkt_put & BPMASK].pkt_len || _CX >= BUFSIZE) {
      _ES = 0;
      _DI = 0;
      }
    else {
      pb[pkt_put & BPMASK].pkt_len = _CX;
      _ES = FP_SEG(pb[pkt_put & BPMASK].pkt_data);
      _DI = FP_OFF(pb[pkt_put & BPMASK].pkt_data);
      }
    }
  enable();
  asm {
    pop  ds; // restore driver's data segment
    push di; // compensate for compiler generated PUSH DI / POP DI
    }
  }

int pkt_init(void) {
  struct REGPACK regs;
  char far *temp;
  int pd_type;	                /* packet driver type */
  int pd_class;
  for (pkt_interrupt = int_first; pkt_interrupt <= int_last; ++pkt_interrupt ) {
    temp = (char far *)getvect( pkt_interrupt );
    if (!_fmemcmp( &(temp[3]), pkt_line, strlen( pkt_line ))) break;
    }
  if ( pkt_interrupt > int_last ) {
    printf("NO PACKET DRIVER FOUND ");
    if(int_first==int_last) printf("AT INTERRUPT 0x%02X\n",int_first);
    else printf("IN RANGE 0x%02X .. 0x%02X\n",int_first,int_last);
    exit(2);
    }

  /* lets find out about the driver */
  regs.r_ax = PD_DRIVER_INFO;
  intr( pkt_interrupt, &regs );
  capabilities = regs.r_ax & 7;

  /* handle old versions, assume a class and just keep trying */
  if (regs.r_flags & CARRY ) {
    for ( pd_class = 0; pd_class < 19; ++pd_class ) {
      for (pd_type = 1; pd_type < 128; ++pd_type ) {
	regs.r_ax = PD_ACCESS | pd_class;  /* ETH, SLIP */
	regs.r_bx = pd_type;		     /* type */
	regs.r_dx = 0;		     /* if number */
	regs.r_cx = 0;                     // sizeof( pkt_type);
	regs.r_ds = FP_SEG( &pkt_type );
	regs.r_si = FP_OFF( &pkt_type );
	regs.r_es = FP_SEG( pkt_callback );
	regs.r_di = FP_OFF( pkt_callback );
	intr( pkt_interrupt, &regs );
	if ( ! (regs.r_flags & CARRY) ) break;
	}

      if (pd_type < 128 ) {
	/* get ethernet address */
	regs.r_ax = PD_GET_ADDRESS;
	regs.r_bx = regs.r_ax;	/* handle */
	regs.r_es = FP_SEG( eth_addr );
	regs.r_di = FP_OFF( eth_addr );
	regs.r_cx = sizeof( eth_addr );
	intr( pkt_interrupt, &regs );
	/* we have found a working type, so kill it */
	regs.r_ax = PD_RELEASE;
	intr( pkt_interrupt, &regs );
	old_driver++;
	printf("Found OLD type of packet driver\n");
	break;
	}

      if ((pd_type == 128 ) && (pd_class > 18)) {
	printf("ERROR initializing packet driver\n\r");
	return( 1 );
	}
      }
    }
  else {
    pd_type = regs.r_dx;
    pd_class = regs.r_cx >> 8;
    /* get ethernet address */
    regs.r_ax = PD_GET_ADDRESS;
    regs.r_bx = 0;
    regs.r_es = FP_SEG( eth_addr );
    regs.r_di = FP_OFF( eth_addr );
    regs.r_cx = sizeof( eth_addr );
    intr( pkt_interrupt, &regs );
    printf("Found packet driver with basic ");
    switch (capabilities) {
      case 2:
      case 6: printf("and extended ");
	      if(capabilities==2) break;
      case 5: printf("and high-performance ");
      }
    printf("functions\n");
    }
  printf("Vector=%02X class=%d type=%d ethernet address=%s\n",
	    pkt_interrupt, pd_class, pd_type, eadr2asc(eth_addr,0));

  regs.r_ax = PD_ACCESS | pd_class;
  regs.r_bx = pd_type;                // any type
  regs.r_dx = 0;			// if number
  regs.r_cx = 0;                      // sizeof( pkt_type );
  regs.r_ds = FP_SEG( &pkt_type );
  regs.r_si = FP_OFF( &pkt_type );
  regs.r_es = FP_SEG( pkt_callback );
  regs.r_di = FP_OFF( pkt_callback );
  intr( pkt_interrupt, &regs );
  if(regs.r_flags & CARRY) {
    printf("ERROR #%02X accessing packet driver\n",(regs.r_dx>>8));
    return( 1 );
    }
  pkt_handle = regs.r_ax;
  return( 0 );
  }

void pkt_setmode(int mode) {
  struct REGPACK regs;
  // get ethernet address
  regs.r_ax = PD_SET_MODE;
  regs.r_bx = pkt_handle;
  regs.r_cx = mode;
  intr( pkt_interrupt, &regs );
  if(regs.r_flags & CARRY) printf("WARNING cannot set driver into mode: %d\n",mode);
  }

void pkt_release(void) {
  struct REGPACK regs;
  int error;
  regs.r_ax = PD_RELEASE;
  regs.r_bx = pkt_handle;
  intr( pkt_interrupt, &regs );
  if (regs.r_flags & CARRY ) printf("ERROR releasing packet driver\n");
  return;
  }

int pkt_send( char *buffer, int length ) {
  struct REGPACK regs;
  int retries;

  retries = 5;
  while (retries--) {
    regs.r_ax = PD_SEND;
    regs.r_ds = FP_SEG( buffer );
    regs.r_si = FP_OFF( buffer );
    regs.r_cx = length;
    intr( pkt_interrupt, &regs );
    if ( regs.r_flags & CARRY ) continue;
    return( 0 );
    }
  return( 1 );
  }


//---------------------------------------------------------------

char *prot2asc(unsigned char *p, byte code) {
  static char outbuf[20];
  word pcod;
  pcod = (p[1]&0XFF)<<8 | (p[0]&0XFF);
  if(code==4) switch(pcod) {
    case 0X0404: return("SNA");
    case 0X0606: return("DoD-IP");
    case 0XF0F0: return("NetBIOS");
    }
  else switch(pcod) {
    case 0X0805: return("X.25");
    case 0X809B: return("AppleTalk");
    case 0X6001: return("DECnet");
    case 0X6004: return("DEC LAT");
    }
  sprintf(outbuf,"Code: %04X",pcod);
  return(outbuf);
  }

char *hex2asc(unsigned char *p, word len) {
  static char outbuf[20];
  char *p2;
  for(p2=outbuf; len; len--,p++,p2+=2) sprintf(p2,"%02X",*p);
  *p = '\0';
  return(outbuf);
  }

char *ipad2asc(unsigned char *p) {
  static char outbuf[20];
  sprintf(outbuf,"%d.%d.%d.%d",p[0],p[1],p[2],p[3]);
  return(outbuf);
  }

char *eadr2asc(unsigned char *p, int mode) {
  static char outbuf[20];
  char *p2;
  int i;
  for(i=0, p2=outbuf; i<6; i++, p++) {
    if(mode) {
      sprintf(p2,"%02X",*p);
      p2 += 2;
      if(i==2) *p2++ = ':';
      }
    else {
      sprintf(p2,"%02X:",*p);
      p2 += 3;
      }
    }
  if(!mode) p2--;
  *p2 = '\0';
  if(mode==2) outbuf[6]='\0';
  if(mode==3) return(&outbuf[7]);
  else return(outbuf);
  }

word htoi(char *p, int count) {
  int i;
  for(i=0; *p && count; p++,count--) {
    if(!isxdigit(*p)) break;
    i <<= 4;
    if(isdigit(*p)) i |= (*p&0x0F);
    else i |= ((*p&0X0F) + 9);
    }
  return(i);
  }

void get_eth_addr(char *p, byte *d) {
  int i;
  for(i=0; *p && i < 6; i++) {
    *d++ = htoi(p,2);
    if(*++p) p++;
    if((*p==':')||(*p=='-')) p++;
    }
  }

word swap(word arg) {
  return((arg & 0xFF00) >> 8) | ((arg & 0xFF) << 8);
  }

//---------------------------------------------------------------

void dhcp_check(void) {
  int i,k,l,flag;
  ip_frame *ipf;
  ip_address nm,gw;
  udp_icmp_header *uihd;
  flag = 0;
  if(iphd->prot!=17) return;      // no UDP frame
  i = ((iphd->VersHL&0XF) << 2) - sizeof(ip_header);
  ipf  = (ip_frame *)iphd;
  uihd = (udp_icmp_header *)&ipf->ipd[i];
  if(swap(uihd->srcport)!=67) return;    // not from port 67
  if(swap(uihd->dstport)!=68) return;    // not to   port 68
  if(uihd->opcode!=2)         return;    // no DHCP response
  if(memcmp(&uihd->cooky,dhcpcky,sizeof(ip_address))) return; // no cooky
  i = 0;
  while(i<60) {
    k = uihd->data[i++];
    l = uihd->data[i++];
    if(k==1) {
      memcpy(&nm,&uihd->data[i],sizeof(ip_address));
      flag |= 1;
      }
    else if(k==3) {
      memcpy(&gw,&uihd->data[i],sizeof(ip_address));
      flag |= 2;
      }
    i += l;
    }
  if(flag==3) {
    memcpy(&net_mask,&nm,sizeof(ip_address));
    memcpy(&gate_way,&gw,sizeof(ip_address));
    for(i=0; i<4; i++) net_adr[i] = gate_way[i]&net_mask[i];
    dhcp_found = 1;
    }
  }

void calculate_speed(void) {
  unsigned long rate;
  rate = (bytes_rcv * 91) / ((t1 - t0) * 5); // Bytes/sec
  rate >>= 7;                                // Kbit/sec
  if(rate<2048L) sprintf(speed,"%4ld KBit/s",rate);
  else sprintf(speed,"%4ld MBit/s",rate>>10);
  bytes_rcv = 0L;
  t0 = t1;
  }

void guess_netmask(void) {
  int i,j,k,l;
  byte m;
  memcpy(&net_mask,&null_adr,sizeof(ip_address));
  for(i=0, k=-1; k<0&&i<iptbl.adcount; i++) if(iptbl.data[i].flag||iptbl.data[i].ipcnt==1) k = i;
  memcpy(&net_adr,&iptbl.data[k].ipad[0],sizeof(ip_address));
  for(j=0; j<4; j++)
    for(m=0X80, l=0; m; m>>=1) {
      for(i=k+1; i<iptbl.adcount; i++) if(iptbl.data[i].flag||iptbl.data[i].ipcnt==1) {
	l++;
	if((iptbl.data[i].ipad[0][j]&m)!=(iptbl.data[k].ipad[0][j]&m)) return;
	}
      if(!l) return;
      net_mask[j] |= m;
      }
  }

int is_local(ip_address ip) {
  int i;
  for(i=0; i<4; i++) if(net_adr[i]!=ip[i]&net_mask[i]) return(0);
  return(1);
  }

void guess_gateway(void) {
  int i,j,k,f1,f2,f3,flg;
  memcpy(&gate_way,&null_adr,sizeof(ip_address));
  for(i=f1=0; i<iptbl.adcount; i++) if(iptbl.data[i].ipcnt>1) {
    for(j=flg=0; j<iptbl.data[i].ipcnt; j++)
      if(is_local(iptbl.data[i].ipad[j])) { flg |= 1; k =j; } else flg |= 2;
    if(flg==3) { f1++; if(f1==1) { f2 = i; f3 = k; } }
    }
  if(f1==1) memcpy(&gate_way,&iptbl.data[f2].ipad[f3],sizeof(ip_address));
  }

void guess_network(void) {
  int i;
  if(dhcp_found) return;
  guess_netmask();
  if(!(net_mask[0]&3)) memcpy(&net_mask,&null_adr,sizeof(ip_address));
  for(i=0; i<4; i++) net_adr[i] &= net_mask[i];
  guess_gateway();
  }

char *procout(unsigned long val, unsigned long ref) {
  static char tmp[10];
  int  proc;
  if(val<0X1000000) proc = (val * 100L) / ref;
  else {
    ref /= 100L;
    proc = val / ref;
    }
  if(proc) sprintf(tmp,"%3d%%",proc);
  else if(val!=0L) sprintf(tmp," <1%%");
  else sprintf(tmp,"  0%%");
  return(tmp);
  }

void show_table(void) {
  int i,j,k;
  unsigned long lt;
  t1 = *timer;
  if(t1 < t0) {
    t0 = t1;
    bytes_rcv = 0L;
    }
  else if((t1-t0)>180L) calculate_speed();
  clrscr();
  textattr(0x07);
  printf("Total packets: %-8ld (%s lost)        Speed: %s\n\n",pkt_found,procout(pkt_lost,pkt_found),speed);
  for(i=0; i<MAIN_TABLE_SIZE; i++) {
    gotoxy(mtbl[i].px,mtbl[i].py);
    lt = mtbl[i].itm.count;
    if(i==showidx) {
      textattr(0x70);
      if(procmod) cprintf("%s %s",mtbl[i].txt,procout(lt,pkt_found));
      else cprintf("%s %ld",mtbl[i].txt,((lt<999999L)?lt:999999L));
      textattr(0x07);
      }
    else {
      if(procmod) printf("%s %s",mtbl[i].txt,procout(lt,pkt_found));
      else printf("%s %ld",mtbl[i].txt,((lt<999999L)?lt:999999L));
      }
    }
  if(showidx<128) {
    gotoxy(3,8);
    if(dtbl.idx) printf("Details of highlighted item:        (may be incomplete!)");
    for(i=0; i<dtbl.idx; i++) {
      gotoxy((i&1)?38:3,10+(i>>1));
      printf("%s  ",eadr2asc((char *)&dtbl.src[i].ea,1));
      if(dtbl.typ==1) printf("%s",hex2asc((char *)dtbl.src[i].ia,4));
      else if(dtbl.typ==2) printf("%s",ipad2asc((char *)&dtbl.src[i].ia));
      else if(dtbl.typ>2) printf("%s",prot2asc((char *)&dtbl.src[i].ia,dtbl.typ));
      }
    if(dtbl.flg) {
      gotoxy((dtbl.idx&1)?38:3,10+(dtbl.idx>>1));
      printf("(may be more ... )");
      }
    }
  else {
    gotoxy(1,8);
    guess_network();
    if(!net_mask[0]) printf("Not enough IP-traffic yet to guess network params ...");
      else {
      printf("%s:  ",(dhcp_found?"BOOTP":"Guess"));
      printf("Netmask=%s  ",ipad2asc(net_mask));
      printf("Network=%s  ",ipad2asc(net_adr));
      if(gate_way[0]) printf("Gateway=%s",   ipad2asc(gate_way));
      }
    for(i=0; i<iptbl.adcount&&i<12; i++) {
      k = i + ip_tblscroll;
      gotoxy(1,i+10);
      printf("%s ",eadr2asc((char *)&iptbl.data[k].eadr,1));
      for(j=0; j<iptbl.data[k].ipcnt; j++) printf("%c%-15s",
       ((!j&&iptbl.data[k].flag)?'+':' '),ipad2asc((char *)&iptbl.data[k].ipad[j]));
      }
    if(iptbl.adcount>12) {
      gotoxy(1,22);
      printf("<PgUp>,<PgDn> scrolls list");
      }
    }
  gotoxy(1,24);
  textattr(0x07);
  printf("%c <cursor>,<HOME> selects details  <TAB> toggles display  <ESC> terminates\r",life[lcnt]);
  }

void fill_iptbl(ethernet_address *ea, ip_address *ip) {
  int i,j;
  if(!memcmp(null_adr,ip,sizeof(ip_address))) return;
  for(i=0, j=1; i<iptbl.adcount; i++) if(!(j=memcmp(ea,&iptbl.data[i].eadr,sizeof(ethernet_address)))) break;
  if(!j) {
    if(protocol_type==ARP) {
      memcpy(&iptbl.data[i].ipad[0],ip,sizeof(ip_address));
      iptbl.data[i].flag = 1;
      }
    for(j=0; j<iptbl.data[i].ipcnt; j++) if(!memcmp(ip,&iptbl.data[i].ipad[j],sizeof(ip_address))) return;
    if(iptbl.data[i].ipcnt<4) memcpy(&iptbl.data[i].ipad[iptbl.data[i].ipcnt++],ip,sizeof(ip_address));
    }
  else if(iptbl.adcount<IPTBLSIZE) {
    i = iptbl.adcount++;
    memcpy(&iptbl.data[i].eadr,ea,sizeof(ethernet_address));
    memcpy(&iptbl.data[i].ipad[0],ip,sizeof(ip_address));
    iptbl.data[i].ipcnt = 1;
    }
  }

void inc_table_item(int idx, ethernet_address *ea, ip_address *ip) {
  int i;
  table_item *ti;
  if(protocol_type>IPX) fill_iptbl(ea,ip);
  ti = &mtbl[idx].itm;
  ti->count++;
  for(i=0; i<ti->idx; i++) if(!memcmp(ea,ti->src[i].ea,6)) return;
  if(ti->idx < 3) {
    if(ip) memcpy(ti->src[ti->idx].ia,ip,4);
    memcpy(ti->src[ti->idx++].ea,ea,6);
    }
  else ti->flg = 1;
  if(idx==showidx) {
    for(i=0; i<dtbl.idx; i++) if(!memcmp(ea,dtbl.src[i].ea,6)) return;
    if(dtbl.idx < 20) {
      if(ip) memcpy(dtbl.src[dtbl.idx].ia,ip,4);
      memcpy(dtbl.src[dtbl.idx++].ea,ea,6);
    }
    else dtbl.flg = 1;
    }
  }

void process_packet(ethernet_frame *ef) {
  int i;
  frame_type = protocol_type = protocol_code = 0;
  if(swap(ef->typ) > 1500) {
    frame_type    = ETHERNET_II;
    protocol_code = swap(ef->typ);
    inc_table_item(0,&ef->src,NULL);
    }
  else if(ef->b.snap.dsss==0XAAAA) {
    frame_type    = ETHERNET_SNAP;
    protocol_code = swap(ef->b.snap.typ);
    inc_table_item(6,&ef->src,NULL);
    }
  else if(ef->b.llc.dsss==0XE0E0) {
    frame_type    = ETHERNET_802_2;
    protocol_type = IPX;
    protocol_code = ef->b.llc.dsss;
    inc_table_item(12,&ef->src,NULL);
    inc_table_item(13,&ef->b.llc.h.ipx.srcnode,&ef->b.llc.h.ipx.srcnet);
    }
  else if((ef->b.llc.dsss==0XFFFF)
       &&(!memcmp(ef->dst,ef->b.e2.ipx.dstnode,6)
       || !memcmp(ef->src,ef->b.e2.ipx.srcnode,6) )) {
    frame_type    = ETHERNET_802_3;
    protocol_type = IPX;
    inc_table_item(15,&ef->src,NULL);
    inc_table_item(16,&ef->b.e2.ipx.srcnode,&ef->b.e2.ipx.srcnet);
    }
  else if((ef->b.llc.dsss!=0)&&(ef->b.llc.dsss==swap(ef->b.llc.dsss))) {
    frame_type    = ETHERNET_802_2;
    protocol_code = swap(ef->b.llc.dsss);
    inc_table_item(12,&ef->src,NULL);
    inc_table_item(14,&ef->src,(ip_address *)&ef->b.llc.dsss);
    }
  if((frame_type==ETHERNET_II)||(frame_type==ETHERNET_SNAP)) {
    switch(protocol_code) {
      case 0X0800: protocol_type = IP;
		   if(frame_type==ETHERNET_II) { i = 2; iphd = &ef->b.e2.ip; }
		   else { i = 8; iphd = &ef->b.snap.h.ip; }
		   inc_table_item(i,&ef->src,&iphd->src);
		   dhcp_check();
		   break;
      case 0X0806: protocol_type = ARP;
		   if(frame_type==ETHERNET_II) inc_table_item(3,&ef->src,&ef->b.e2.arp.psrc);
		   else inc_table_item(9,&ef->src,&ef->b.snap.h.arp.psrc);
		   break;
      case 0X8035: protocol_type = RARP;
		   if(frame_type==ETHERNET_II) inc_table_item(4,&ef->src,&ef->b.e2.arp.psrc);
		   else inc_table_item(10,&ef->src,&ef->b.snap.h.arp.psrc);
		   break;
      case 0X8137: protocol_type = IPX;
		   if(frame_type==ETHERNET_II) inc_table_item(1,&ef->b.e2.ipx.srcnode,&ef->b.e2.ipx.srcnet);
		   else inc_table_item(7,&ef->b.snap.h.ipx.srcnode,&ef->b.snap.h.ipx.srcnet);
		   break;
      default:     if(frame_type==ETHERNET_II) inc_table_item(5,&ef->src,(ip_address *)&protocol_code);
		   else inc_table_item(11,&ef->src,(ip_address *)&protocol_code);
		   break;

      }
    }
  if(!frame_type) inc_table_item(17,&ef->src,NULL);
  update++;
  pkt_read++;
  }

void help_text(void) {
  printf("\n\n\n");
  printf("  ETHWHAT %s%s by Jrgen Hoffmann (2009) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n",version,MEMORY_MODEL);
  printf("  usage: ethwhat [ options ]\n\n");
  printf("  valid options:\n");
  printf("    /I<int> define packet driver interrupt  (default: automatic)\n");
  printf("    /h /?   print this help text\n\n");
  }


void main(int argc, char *argv[]) {
  int  i,j,ch;
  char *p;

  for(i = 1; i < argc; i++)
    if(*argv[i]=='-' || *argv[i]=='/') {
      p = argv[i];
      switch(toupper(p[1])) {
	case 'I': if(isdigit(p[2])) {
		    if(toupper(p[3])=='X') int_first = htoi(&p[4],2);
		    else int_first = atoi(&p[2]);
		    int_last = int_first;
		    }                                               break;
	case 'H':
	case '?': help_text(); exit(1);
	} /* switch */
      } /* if */
  pkt_init();
  pkt_setmode(6);
  printf("\n");
  t0 = *timer;
  last_time = t0&0XFFFFFFE0L;
  ch = 0;
  printf("  No packets yet, press <ESC> to terminate ...\r");

  do {
    if(pb[pkt_get & BPMASK].pkt_len&0x8000) {
      process_packet((ethernet_frame *)&pb[pkt_get & BPMASK].pkt_data);
      pb[pkt_get & BPMASK].pkt_len = 0;
      pkt_get++;
      if(pkt_get >= pkt_put) {
        pkt_lost = pkt_found - pkt_read;
	pkt_get &= BPMASK;
	pkt_put &= BPMASK;
	}
      }
    if((curr_time=*timer&0XFFFFFFE0L)!=last_time) {
      last_time = curr_time;
      if(update) {
	show_table();
	update = 0;
	}
      else printf("%c\r",life[lcnt]);
      lcnt++;
      lcnt &= 3;
      }
    if(kbhit()) {
      ch = getch();
      if(!ch) {
	ch = getch();
	switch (ch) {
	  case 0X47: showidx = 255;
		     update++;                      break; // cursor home
	  case 0X48: if(showidx>127) showidx=0;
		     else if(showidx>5) {
		       if(showidx>13) showidx-=3;
		       else showidx-=6;
		       }
		     update++;                      break; // cursor up
	  case 0X49: ip_tblscroll -= 6;
		     if(ip_tblscroll<0) ip_tblscroll = 0;
		     update++;                      break; // Page up
	  case 0X4B: if(showidx>127) showidx=0;
		     else if(showidx) showidx--;
		     update++;                      break; // cursor left
	  case 0X4D: if(showidx>127) showidx=0;
		     else if(showidx<17) showidx++;
		     update++;                      break; // cursor right
	  case 0X50: if(showidx>127) showidx=0;
		     else if(showidx<8)  showidx+=6;
		     else if(showidx>10&&showidx<15) showidx+=3;
		     update++;                      break; // cursor down
	  case 0X51: ip_tblscroll += 6;
		     if((ip_tblscroll+12)>iptbl.adcount)
		       ip_tblscroll = iptbl.adcount-12;
		     if(ip_tblscroll<0) ip_tblscroll = 0;
		     update++;                      break; // Page down
	  }
	if(update) {
	  if(showidx<18) {
	    memcpy(&dtbl.count,&mtbl[showidx].itm,sizeof(table_item));
	    dtbl.typ = mtbl[showidx].typ;
	    }
	  last_time = 0L;
	  }
	}
      else if(ch==9) { procmod = !procmod; update++; last_time = 0L; }
      }
    } while(ch != 27);
  printf("%-78s\r","");

  pkt_setmode(3);
  pkt_release();
  }



