/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "abort.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:中断関数群                                                               *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
AbortDlgProc (HWND   hDlg,
              UINT   uMsg,
              WPARAM wParam,
              LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          LPABORTDLG lpDlg;
          RECT rc;

          SetWindowLongPtr (hDlg, DWLP_USER, lParam);
          lpDlg = (LPABORTDLG)lParam;
          GetWindowRect (hDlg, &rc);
          SetWindowPos (hDlg, 0,
                    (GetSystemMetrics (SM_CXSCREEN) - rc.right + rc.left) / 2,
                    (GetSystemMetrics (SM_CYSCREEN) - rc.bottom + rc.top) / 2,
                                            0, 0, SWP_NOSIZE | SWP_NOZORDER);
          SetDlgItemText (hDlg, IDC_STATICG1, lpDlg->lpszText);
        }
        return TRUE;
      case WM_COMMAND:
        if (LOWORD (wParam) == IDCANCEL)
          {
            LPABORTDLG lpDlg;

            lpDlg = (LPABORTDLG)GetWindowLongPtr (hDlg, DWLP_USER);
            lpDlg->fSignal = TRUE;
          }
        return TRUE;
    }
  return FALSE;
}
