/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "reload.h"
#include "resource.h"
#include "wcommon.h"


/******************************************************************************
*                                                                             *
* ja:再読み込みダイアログ関数群                                               *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
ReloadDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          LPTSTR lpszText, *ppszArray;
          HINSTANCE hInstance;
          LPRELOADDLG lpDlg;

          SetWindowLongPtr (hDlg, DWLP_USER, lParam);
          lpDlg = (LPRELOADDLG)lParam;
          hInstance = GetModuleHandle (NULL);
          /* ja:コンボボックスの設定 */
          lpszText = LoadText (hInstance, IDS_FTYPE_CRLF);
          ppszArray = StringSplitDelimiter (lpszText, _T(","));
          MemoryFree (lpszText);
          for (i = 0; ppszArray[i]; i++)
            ComboBoxItem_AddString (hDlg, IDC_COMBOBOX21, ppszArray[i]);
          MemoryFree (ppszArray);
          ComboBoxItem_SetCurSel (hDlg, IDC_COMBOBOX21, lpDlg->uRetCode);
          lpszText = LoadText (hInstance, IDS_FTYPE_CHARSET);
          ppszArray = StringSplitDelimiter (lpszText, _T(","));
          MemoryFree (lpszText);
          for (i = 0; ppszArray[i]; i++)
            ComboBoxItem_AddString (hDlg, IDC_COMBOBOX22, ppszArray[i]);
          MemoryFree (ppszArray);
          ComboBoxItem_SetCurSel (hDlg, IDC_COMBOBOX22, lpDlg->uCharSet);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                LPRELOADDLG lpDlg;

                lpDlg = (LPRELOADDLG)GetWindowLongPtr (hDlg, DWLP_USER);
                lpDlg->uRetCode
                            = ComboBoxItem_GetCurSel (hDlg, IDC_COMBOBOX21);
                lpDlg->uCharSet
                            = ComboBoxItem_GetCurSel (hDlg, IDC_COMBOBOX22);
              }
            case IDCANCEL:
              EndDialog (hDlg, LOWORD (wParam));
          }
        return TRUE;
    }
  return FALSE;
}
