/**
   Copyright 2004 TubeRide Project

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
using System;
using System.IO;
using System.Text;
using System.Collections;


namespace com.staytube.tuberide.util
{
	/// <summary>
	/// CSVt@Cǂݍރ[eBeBNX
	/// System.IO.StreamReaderpNX
	/// <pre>
	/// string fileName = "hoge.csv";
	/// string encode   = "Shift_JIS";
	/// CSVReader reader = new CSVReader(fileName, Encoding.GetEncoding(encode) );
	/// StringBuilder buf = new StringBuilder();
	/// //LAread()sƁAnet.everes.util.CSVDataSystem.Collenctions.ArrayList߂܂B
	/// ArrayList arrays = reader.read();
	/// reader.Close();
	/// //L̗v̂ŁAArrayListnet.everes.util.CSVData̔zɃLXg܂
	/// CSVData[] data = (CSVData[]) arrays.ToArray(System.Type.GetType("net.everes.util.CSVData"));
	/// //ĩ[vAs̃[v
	/// for(int i = 0;i < data.Length;i++) {
	///		//j̃[vi̍sɊւJ̃[v
	///		for(int j = 0;j < data[i].length;j++) {
	///			System.Console.WriteLine(data[i].data[j]);
	///		}
	///	}
	/// </pre>
	/// @author makoto tsuyuki(sf@stay-tube.com)
	/// </summary>
	/// <example>CSVReader̎gp@
	/// <code>
	/// string fileName = "hoge.csv";
	/// string encode   = "Shift_JIS";
	/// CSVReader reader = new CSVReader(fileName, Encoding.GetEncoding(encode) );
	/// StringBuilder buf = new StringBuilder();
	/// //LAread()sƁA<see cref="net.everes.util.CSVData"/><see cref="System.Collenctions.ArrayList"/>߂܂B
	/// ArrayList arrays = reader.read();
	/// reader.Close();
	/// //L̗v̂ŁAArrayList<see cref="net.everes.util.CSVData"/>̔zɃLXg܂
	/// CSVData[] data = (CSVData[]) arrays.ToArray(System.Type.GetType("net.everes.util.CSVData"));
	/// //ĩ[vAs̃[v
	/// for(int i = 0;i < data.Length;i++) {
	///		//j̃[vi̍sɊւJ̃[v
	///		for(int j = 0;j < data[i].length;j++) {
	///			System.Console.WriteLine(data[i].data[j]);
	///		}
	///	}
	/// </code>
	/// </example>
	public class CSVReader:StreamReader
	{
		/// <summary>
		/// B̃RXgN^<br />
		/// ǂݍރt@CƃGR[fBOw肷
		/// </summary>
		/// <param name="fileName">ǂݍރt@C</param>
		/// <param name="encode">t@Cǂݍލۂ̃GR[fBO</param>
		public CSVReader(string fileName, Encoding encode):base(fileName,encode) {
		}

		/// <summary>
		/// t@CɊ܂܂CSVPsnet.everes.util.CSVDataArrayListƂĕԂ<br />
		/// CSV͉s܂ރJ_uR[e[VŃGXP[vɑΉ邪A_uR[e[V̑ΉȂꍇ͐ǂݍ܂Ȃ<br />
		/// CSVɊ܂܂śACRLFƂĈ
		/// </summary>
		/// <returns>net.everes.util.CSVDataArrayList</returns>
		public ArrayList read() {
			ArrayList list = new ArrayList();
			while(true) {
				CSVLine line = readLine();
				if(line != null) list.Add(new CSVData(line));
				else break;
			}
			return list;
		}

		/// <summary>
		/// CSV̂PsԂ
		/// </summary>
		/// <returns>CSVLine</returns>
		public CSVLine readLine() {
			string line = base.ReadLine();
			if (line == null) return null;
		
			while (!isCSVLineFinished(line)) {
				string line2 = base.ReadLine();
				if (line2 == null) break;
				line += "\r\n" + line2;
			}
			return new CSVLine(line);
		}

		/// <summary>
		/// CSV̍sIĂ邩Ԃ<br />
		/// _uR[e[V̐̏ꍇ͏IĂȂ
		/// </summary>
		/// <param name="line">string mFs</param>
		/// <returns>true:IĂ@false:IĂȂ</returns>
		private bool isCSVLineFinished(string line) {
			int count = 0;
			char[] c = line.ToCharArray();
			for (int i=0; i < c.Length ; i++) {
				if (c[i] == '"') count++;
			}
			return count%2 == 0;
		}
	}
	

	/// <summary>
	/// CSV̂Ps\\<br />
	/// string̔z񂪊܂܂
	/// @author makoto tsuyuki(sf@stay-tube.com)
	/// </summary>
	public struct CSVData {
		string[] _data;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="line">CSVLine</param>
		public CSVData(CSVLine line) {
			string[] _data2 = line.toArray();
			this._data = new string[_data2.Length];
			for(int i = 0;i < _data2.Length ;i++) {
				this._data[i] = _data2[i];
			}
		}

		/// <summary>
		/// ܂܂J̃f[^stringzvpeB
		/// </summary>
		public string[] data {
			set { _data = value ; }
			get { return _data ; }
		}

		/// <summary>
		/// ܂܂J̐Ԃ
		/// </summary>
		/// <returns>int J̐</returns>
		public int size() {
			return _data.Length;
		}

		/// <summary>
		/// ܂܂JPsCSVɂĕԂ
		/// </summary>
		/// <returns>string CSV̂Psi_sj</returns>
		public string toString() {
			StringBuilder buf = new StringBuilder();
			for(int i = 0;i < _data.Length;i++) {
				if(_data[i] == null) continue ;
				else if(_data[i].IndexOf("\n") == -1) buf.Append(_data[i]);
				else buf.Append("\"" + _data[i] + "\"");
				if(i != _data.Length) buf.Append(",");
			}
			return buf.ToString();
		}
	}

	/// <summary>
	/// CSV̘_sNX
	/// @author makoto tsuyuki(sf@stay-tube.com)
	/// </summary>
	public class CSVLine {
		ArrayList list;

		/// <summary>
		/// RXgN^
		/// </summary>
		public CSVLine() {
			list = new ArrayList();
		}

		/// <summary>
		/// CSV̂PsɕێĂArrayListɒǉ
		/// </summary>
		/// <param name="line">string CSV̂Ps</param>
		public CSVLine(string line):this() {
			CSVTokenizer tokenizer = new CSVTokenizer(line);
			while (tokenizer.hasMoreTokens()) {
				add(tokenizer.nextToken());
			}
		}

		/// <summary>
		/// CSV̂PJɕێĂArrayListɒǉ
		/// </summary>
		/// <param name="data">string PJ̃f[^</param>
		public void add(String data) {
			if (data == null)
				list.Add("");
			else
				list.Add(data);
		}

		/// <summary>
		/// ɕێĂCSṼJstringzŕԂ
		/// </summary>
		/// <returns>string[] Jstringz</returns>
		public string[] toArray() {
			return (string[]) list.ToArray(System.Type.GetType("System.String"));
		}

	}

	/// <summary>
	/// CSV΂炷[eBeB[
	/// @author makoto tsuyuki(sf@stay-tube.com)
	/// </summary>
	public class CSVTokenizer {
		String[] data;
		int index;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="line">CSV̂Ps</param>
		public CSVTokenizer(String line) {
			this.data = parse(line);
			index = 0;
		}

		/// <summary>
		/// ̍ڂ̃f[^ԂB
		/// </summary>
		/// <returns>string ̍ڂ̃f[^</returns>
		public String nextToken() {
			try {
				return data[index++];
			} catch (Exception e) {
				return null;
			}
		}
	
		/// <summary>
		/// ܂f[^邩ۂԂB
		/// </summary>
		/// <returns>true: ܂f[^B false: f[^͂ȂB</returns>
		public bool hasMoreTokens() {
			return (data.Length > index);
		}
	
		/// <summary>
		/// SĂ̍ڂ̃f[^擾B
		/// </summary>
		/// <returns>string[] eڂƂɕꂽ̔zB</returns>
		public string[] getData() {
			return data;
		}
	
		/// <summary>
		/// CSV`1s̕󂯎Aeڂ̃f[^p[Xĕ̔zƂĕԂB
		/// </summary>
		/// <param name="line">string CSV`1s̕</param>
		/// <returns>string[] eڂƂɕꂽ̔zB</returns>
		private string[] parse(String line) {
			ArrayList array = new ArrayList();
			bool escape = false;
			StringBuilder buf = new StringBuilder();
			char[] c = line.ToCharArray();
			for (int i=0; i < c.Length; i++) {
				if (c[i] == ',' && !escape) {
					array.Add(unescape(buf.ToString()));
					buf = new StringBuilder();
				} else {
					if (c[i] == '"') {
						escape = !escape;
					}
					buf.Append(c[i]);
				}
			}
			array.Add(unescape(buf.ToString()));
		
			return (string[])array.ToArray(Type.GetType("System.String"));
		}
	
		/// <summary>
		/// GXP[vꂽAGXP[vĕԂB
		/// GXP[vĂȂ͂̂܂ܕԂB
		/// </summary>
		/// <param name="str">string AGXP[v镶</param>
		/// <returns>string AGXP[vꂽ</returns>
		private string unescape(string str) {
			if (str.StartsWith("\"")) {
				StringBuilder buf = new StringBuilder();
				char[] c = str.ToCharArray();
				for (int i=0; i < c.Length; i++) {
					if (c[i] == '"') {
						// "PƂŌꂽƂ͉ȂB
						// 1ԍŏ̕"̏ꍇ́AKGXP[vB
						int next = i+1;
						if (0<i && next<c.Length && c[next] == '"') {
							buf.Append(c[i]);
							i = next;
						}
					} else {
						buf.Append(c[i]);
					}
				}
				return buf.ToString();
			} else {
				return str;
			}
		}
	}


}
