/**
   Copyright 2004 TubeRide Project

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
using System;
using System.Text;

using com.staytube.tuberide.net;

namespace com.staytube.tuberide.util
{
	/// <summary>
	/// NetUtil ̊Tv̐łB
	/// @author makoto tsuyuki(sf@stay-tube.com)
	/// </summary>
	public class NetUtil
	{

		/// <summary>
		/// RXgN^
		/// </summary>
		public NetUtil()
		{
		}

		/// <summary>
		/// SMTPvgRp̃[AhX쐬(ISO-2022-JPŃGXP[v)
		/// </summary>
		/// <param name="address">string [AhX</param>
		/// <param name="name">string O</param>
		/// <returns>GXP[vꂽ[AhX</returns>
		/// <exception cref="IllegalMailAddressException">[AhXsȏꍇ</exception>
		public static string createMailAddress(string address, string name) 
		{
			if( (address.Length > 0) && (address.IndexOf("@") > 0) && (address.IndexOf(".",address.IndexOf("@")) > 0)) 
			{
				string to = "";
				if(name != null && name.Length > 0) 
				{
					Encoding enc = Encoding.GetEncoding("ISO-2022-JP");
					byte[] bytes = enc.GetBytes(name);
					if(name.Length == bytes.Length) to = name;
					else to = NetUtil.createI18nHeader("ISO-2022-JP",name);
				}
				return string.Format("{0}<{1}>",to,address);
			} 
			else 
			{
				IllegalMailAddressException e = new IllegalMailAddressException();
				throw e;
			}
		}

		/// <summary>
		/// SMTPvgRpMIMEGR[hꂽԂ
		/// </summary>
		/// <param name="encode">string GR[fBO(ISO-2022-JP)</param>
		/// <param name="text">string GR[h</param>
		/// <returns>string GR[hꂽ</returns>
		public static string createI18nHeader(string encode, string text) 
		{
			return string.Format("=?{0}?B?{1}?=",encode, NetUtil.base64Encode(encode,text));
		}

		/// <summary>
		/// w̃GR[fBO(ISO-2022-JP)base64GR[hԂ
		/// </summary>
		/// <param name="encode">string GR[fBO(ISO-2022-JP)</param>
		/// <param name="text">GR[h</param>
		/// <returns>GR[hꂽ</returns>
		public static string base64Encode(string encode, string text) 
		{
			if(text == null) return "";
			Encoding enc = Encoding.GetEncoding(encode);
			byte[] bytes = enc.GetBytes(text);
			return Convert.ToBase64String(bytes);
		}

	}
}
