/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample.servicebean;

import com.sample.BackingDTO;
import com.sample.Person;
import com.sample.PersonDB;
import com.sample.interceptor.LogIntercept;
import com.sample.iservicebean.ServiceBean41;
import com.sample.iservicebean.ServiceBean51;
import com.sample.iservicebean.ServiceBean61;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Scanner;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/**
 *
 * @author konishiyuji
 */
@RequestScoped
public class ServiceBean61Impl implements ServiceBean61 {
    @EJB
    private PersonDB personDB;

    @LogIntercept
    @Override
    public String execute(BackingDTO backingDTO) {
        StringBuilder sb = new StringBuilder();
        List<Person> list = personDB.getList();
        for (Person person : list){
            sb.append(person.getId());
            sb.append(",");
            sb.append(person.getName());
            sb.append("\n");
        }
        
        String csvFile = sb.toString();
        byte[] byteFile = csvFile.getBytes();  // file size(byte array)
        int lengthFile = byteFile.length;  // file size(byte length)
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        OutputStream outputstream = null;
        try {
            externalContext.responseReset();  // はじめにレスポンス情報を初期化
            externalContext.setResponseContentType("text/csv;charset=UTF-8");    // MIMWタイプをcsvにする
            externalContext.setResponseContentLength(lengthFile);  // データサイズをセット
            externalContext.setResponseHeader("Content-Disposition", "attachment; filename=\"output.csv\"");  // ファイルを添付
            outputstream = externalContext.getResponseOutputStream();  // オブジェクトをExternalContextオブジェクトから取得
            outputstream.write(byteFile);
            outputstream.flush();
            externalContext.responseFlushBuffer();  // ExternalContextオブジェクト単位でもフラッシュ
        } catch(IOException e) {
            // TODO
            e.printStackTrace();
        } finally {
            if(outputstream != null) {
                try {
                    outputstream.close();
                } catch(IOException e) {
                    // do nothing
                }
                outputstream = null;
            }
        }
        facesContext.responseComplete();  // このメソッドにより、JSFのライフサイクルが「Render Response」になる

        return "000";
    }
}
