// {ԍsNX

#include <sstream>
#include <cstdlib>
#include "lilib.h"

using namespace std;

// RXgN^
LongIntervalMatrix::LongIntervalMatrix(){
  m = 1;
  n = 1;

  value = new LongInterval *[1];
  value[0] = new LongInterval[1];
}

// RXgN^
LongIntervalMatrix::LongIntervalMatrix(int rows, int columns){
  int i;

  m = rows;
  n = columns;

  value = new LongInterval *[m];
  for(i = 0; i < m; i++){
    value[i] = new LongInterval[n];
  }
}

// RXgN^
LongIntervalMatrix::LongIntervalMatrix(const LongMatrix &x){
  int i, j;

  m = x.m;
  n = x.n;

  value = new LongInterval *[m];
  for(i = 0; i < m; i++){
    value[i] = new LongInterval[n];

    for(j = 0; j < n; j++){
      value[i][j] = x.value[i][j];
    }
  }
}

// Rs[RXgN^
LongIntervalMatrix::LongIntervalMatrix(const LongIntervalMatrix &x){
  int i, j;

  m = x.m;
  n = x.n;

  value = new LongInterval *[m];
  for(i = 0; i < m; i++){
    value[i] = new LongInterval[n];

    for(j = 0; j < n; j++){
      value[i][j] = x.value[i][j];
    }
  }
}

// fXgN^
LongIntervalMatrix::~LongIntervalMatrix(){
  int i;

  for(i = 0; i < m; i++){
    delete[] value[i];
  }
  delete[] value;
}

////////////////////////////////////////////////////////////////////////////////

// TCY̕ύX
void LongIntervalMatrix::resize(int rows, int columns){
  int i;

  if((m != rows) || (n != columns)){

    // ̈̔j
    for(i = 0; i < m; i++){
      delete[] value[i];
    }
    delete[] value;

    m = rows;
    n = columns;

    // ̈̍Ċm
    value = new LongInterval *[m];
    for(i = 0; i < m; i++){
      value[i] = new LongInterval[n];
    }
  }
}

////////////////////////////////////////////////////////////////////////////////

// SlƔa\̎擾
string LongIntervalMatrix::getMidRad() const{
  ostringstream output;
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      output << value[i][j].getMidRad() << "\t";
    }
    output << endl;
  }

  return output.str();
}

// [Ə[\̎擾
string LongIntervalMatrix::getInfSup() const{
  ostringstream output;
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      output << value[i][j].getInfSup() << "\t";
    }
    output << endl;
  }

  return output.str();
}

// s̎擾
int LongIntervalMatrix::rows() const{
  return m;
}

// 񐔂̎擾
int LongIntervalMatrix::columns() const{
  return n;
}

////////////////////////////////////////////////////////////////////////////////

// Sl̎擾
LongMatrix LongIntervalMatrix::mid() const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j].mid();
    }
  }

  return result;
}

// a̎擾
LongMatrix LongIntervalMatrix::rad() const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j].rad();
    }
  }

  return result;
}

// a̎擾
LongMatrix LongIntervalMatrix::diam() const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j].diam();
    }
  }

  return result;
}

// [̎擾
LongMatrix LongIntervalMatrix::inf() const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j].inf();
    }
  }

  return result;
}

// [̎擾
LongMatrix LongIntervalMatrix::sup() const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j].sup();
    }
  }

  return result;
}

// őΒl̎擾
LongMatrix LongIntervalMatrix::mag() const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j].mag();
    }
  }

  return result;
}

// ŏΒl̎擾
LongMatrix LongIntervalMatrix::mig() const{
  LongMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j].mig();
    }
  }

  return result;
}

////////////////////////////////////////////////////////////////////////////////

// s̎擾
LongInterval *LongIntervalMatrix::operator[](int row) const{
  return value[row];
}

// PZ
////////////////////////////////////////////////////////////////////////////////

// +LongIntervalMatrix
LongIntervalMatrix LongIntervalMatrix::operator +() const{
  return *this;
}

// -LongIntervalMatrix
LongIntervalMatrix LongIntervalMatrix::operator -() const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j];
      result.value[i][j].center.sign = -value[i][j].center.sign;
    }
  }

  return result;
}

// lZ
////////////////////////////////////////////////////////////////////////////////

// LongIntervalMatrix + int
LongIntervalMatrix LongIntervalMatrix::operator +(int x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x;
    }
  }

  return result;
}

// LongIntervalMatrix - int
LongIntervalMatrix LongIntervalMatrix::operator -(int x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x;
    }
  }

  return result;
}

// LongIntervalMatrix * int
LongIntervalMatrix LongIntervalMatrix::operator *(int x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] * x;
    }
  }

  return result;
}

// LongIntervalMatrix / int
LongIntervalMatrix LongIntervalMatrix::operator /(int x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] / x;
    }
  }

  return result;
}

// LongIntervalMatrix + LongFloat
LongIntervalMatrix LongIntervalMatrix::operator +(const LongFloat &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x;
    }
  }

  return result;
}

// LongIntervalMatrix - LongFloat
LongIntervalMatrix LongIntervalMatrix::operator -(const LongFloat &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x;
    }
  }

  return result;
}

// LongIntervalMatrix * LongFloat
LongIntervalMatrix LongIntervalMatrix::operator *(const LongFloat &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] * x;
    }
  }

  return result;
}

// LongIntervalMatrix / LongFloat
LongIntervalMatrix LongIntervalMatrix::operator /(const LongFloat &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] / x;
    }
  }

  return result;
}

// LongIntervalMatrix + LongInterval
LongIntervalMatrix LongIntervalMatrix::operator +(const LongInterval &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x;
    }
  }

  return result;
}

// LongIntervalMatrix - LongInterval
LongIntervalMatrix LongIntervalMatrix::operator -(const LongInterval &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x;
    }
  }

  return result;
}

// LongIntervalMatrix * LongInterval
LongIntervalMatrix LongIntervalMatrix::operator *(const LongInterval &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] * x;
    }
  }

  return result;
}

// LongIntervalMatrix / LongInterval
LongIntervalMatrix LongIntervalMatrix::operator /(const LongInterval &x) const{
  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] / x;
    }
  }

  return result;
}

// LongIntervalMatrix + LongMatrix
LongIntervalMatrix LongIntervalMatrix::operator +(const LongMatrix &x) const{
  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongIntervalMatrix + LongMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x.value[i][j];
    }
  }

  return result;
}

// LongIntervalMatrix - LongMatrix
LongIntervalMatrix LongIntervalMatrix::operator -(const LongMatrix &x) const{
  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongIntervalMatrix - LongMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x.value[i][j];
    }
  }

  return result;
}

// LongIntervalMatrix * LongMatrix
LongIntervalMatrix LongIntervalMatrix::operator *(const LongMatrix &x) const{
  if(n != x.m){
    cerr << "[ERROR] LongIntervalMatrix * LongMatrix : Inner matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, x.n);
  int i, j, k;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = 0;
      for(k = 0; k < n; k++){
        result.value[i][j] += value[i][k] * x.value[k][j];
      }
    }
  }

  return result;
}

// LongIntervalMatrix + LongIntervalMatrix
LongIntervalMatrix LongIntervalMatrix::operator +(const LongIntervalMatrix &x) const{
  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongIntervalMatrix + LongIntervalMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] + x.value[i][j];
    }
  }

  return result;
}

// LongIntervalMatrix - LongIntervalMatrix
LongIntervalMatrix LongIntervalMatrix::operator -(const LongIntervalMatrix &x) const{
  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongIntervalMatrix - LongIntervalMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, n);
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      result.value[i][j] = value[i][j] - x.value[i][j];
    }
  }

  return result;
}

// LongIntervalMatrix * LongIntervalMatrix
LongIntervalMatrix LongIntervalMatrix::operator *(const LongIntervalMatrix &x) const{
  if(n != x.m){
    cerr << "[ERROR] LongIntervalMatrix * LongIntervalMatrix : Inner matrix dimensions must agree." << endl;
    exit(1);
  }

  LongIntervalMatrix result(m, x.n);
  int i, j, k;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = 0;
      for(k = 0; k < n; k++){
        result.value[i][j] += value[i][k] * x.value[k][j];
      }
    }
  }

  return result;
}

// Z
////////////////////////////////////////////////////////////////////////////////

// LongIntervalMatrix += int
LongIntervalMatrix &LongIntervalMatrix::operator +=(int x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] += x;
    }
  }

  return *this;
}

// LongIntervalMatrix -= int
LongIntervalMatrix &LongIntervalMatrix::operator -=(int x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] -= x;
    }
  }

  return *this;
}

// LongIntervalMatrix *= int
LongIntervalMatrix &LongIntervalMatrix::operator *=(int x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] *= x;
    }
  }

  return *this;
}

// LongIntervalMatrix /= int
LongIntervalMatrix &LongIntervalMatrix::operator /=(int x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] /= x;
    }
  }

  return *this;
}

// LongIntervalMatrix += LongFloat
LongIntervalMatrix &LongIntervalMatrix::operator +=(const LongFloat &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] += x;
    }
  }

  return *this;
}

// LongIntervalMatrix -= LongFloat
LongIntervalMatrix &LongIntervalMatrix::operator -=(const LongFloat &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] -= x;
    }
  }

  return *this;
}

// LongIntervalMatrix *= LongFloat
LongIntervalMatrix &LongIntervalMatrix::operator *=(const LongFloat &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] *= x;
    }
  }

  return *this;
}

// LongIntervalMatrix /= LongFloat
LongIntervalMatrix &LongIntervalMatrix::operator /=(const LongFloat &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] /= x;
    }
  }

  return *this;
}

// LongIntervalMatrix += LongInterval
LongIntervalMatrix &LongIntervalMatrix::operator +=(const LongInterval &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] += x;
    }
  }

  return *this;
}

// LongIntervalMatrix -= LongInterval
LongIntervalMatrix &LongIntervalMatrix::operator -=(const LongInterval &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] -= x;
    }
  }

  return *this;
}

// LongIntervalMatrix *= LongInterval
LongIntervalMatrix &LongIntervalMatrix::operator *=(const LongInterval &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] *= x;
    }
  }

  return *this;
}

// LongIntervalMatrix /= LongInterval
LongIntervalMatrix &LongIntervalMatrix::operator /=(const LongInterval &x){
  int i, j;

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] /= x;
    }
  }

  return *this;
}

// LongIntervalMatrix = LongMatrix
LongIntervalMatrix &LongIntervalMatrix::operator =(const LongMatrix &x){
  int i, j;

  resize(x.m, x.n);

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] = x.value[i][j];
    }
  }

  return *this;
}

// LongIntervalMatrix += LongMatrix
LongIntervalMatrix &LongIntervalMatrix::operator +=(const LongMatrix &x){
  int i, j;

  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongIntervalMatrix += LongMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] += x.value[i][j];
    }
  }

  return *this;
}

// LongIntervalMatrix -= LongMatrix
LongIntervalMatrix &LongIntervalMatrix::operator -=(const LongMatrix &x){
  int i, j;

  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongIntervalMatrix -= LongMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] -= x.value[i][j];
    }
  }

  return *this;
}

// LongIntervalMatrix = LongIntervalMatrix
LongIntervalMatrix &LongIntervalMatrix::operator =(const LongIntervalMatrix &x){
  int i, j;

  resize(x.m, x.n);

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] = x.value[i][j];
    }
  }

  return *this;
}

// LongIntervalMatrix += LongIntervalMatrix
LongIntervalMatrix &LongIntervalMatrix::operator +=(const LongIntervalMatrix &x){
  int i, j;

  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongIntervalMatrix += LongIntervalMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] += x.value[i][j];
    }
  }

  return *this;
}

// LongIntervalMatrix -= LongIntervalMatrix
LongIntervalMatrix &LongIntervalMatrix::operator -=(const LongIntervalMatrix &x){
  int i, j;

  if((m != x.m) || (n != x.n)){
    cerr << "[ERROR] LongIntervalMatrix -= LongIntervalMatrix : Matrix dimensions must agree." << endl;
    exit(1);
  }

  for(i = 0; i < m; i++){
    for(j = 0; j < n; j++){
      value[i][j] -= x.value[i][j];
    }
  }

  return *this;
}

// lZith֐j
////////////////////////////////////////////////////////////////////////////////

// int + LongIntervalMatrix
LongIntervalMatrix operator +(int a, const LongIntervalMatrix &b){
  LongIntervalMatrix result(b.m, b.n);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = a + b.value[i][j];
    }
  }

  return result;
}

// int - LongIntervalMatrix
LongIntervalMatrix operator -(int a, const LongIntervalMatrix &b){
  LongIntervalMatrix result(b.m, b.n);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = a - b.value[i][j];
    }
  }

  return result;
}

// int * LongIntervalMatrix
LongIntervalMatrix operator *(int a, const LongIntervalMatrix &b){
  LongIntervalMatrix result(b.m, b.n);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = a * b.value[i][j];
    }
  }

  return result;
}

// int / LongIntervalMatrix
LongIntervalMatrix operator /(int a, const LongIntervalMatrix &b){
  LongIntervalMatrix result(b.m, b.n);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = a / b.value[i][j];
    }
  }

  return result;
}

// th֐
////////////////////////////////////////////////////////////////////////////////

// 
LongIntervalMatrix sqrt(const LongIntervalMatrix &a){
  LongIntervalMatrix result(a.m, a.n);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = sqrt(a.value[i][j]);
    }
  }

  return result;
}

// ]us
LongIntervalMatrix trans(const LongIntervalMatrix &a){
  LongIntervalMatrix result(a.n, a.m);
  int i, j;

  for(i = 0; i < result.m; i++){
    for(j = 0; j < result.n; j++){
      result.value[i][j] = a.value[j][i];
    }
  }

  return result;
}

////////////////////////////////////////////////////////////////////////////////

// std::ostream << LongIntervalMatrix
ostream &operator <<(std::ostream &output, const LongIntervalMatrix &x){
  output << x.getMidRad();

  return output;
}
