/*
 * Copyright (c) 2003,2004,2006 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <windows.h>
#include "wwin.h"
#include "black_white.h"

#define COLORMODE_WHITE 255
#define COLORMODE_BLACK 0

static WTop *top = NULL;
static WDrawable *draw = NULL;
static unsigned char colormode = 0;
static int x_prev, y_prev;

static int black_white_width = 120, black_white_height = 20;

static void mousemove(WWindow *_this, int x, int y, MouseMoveState state){
	int dx, dy;
	RECT rc;
	POINT pt;
	GetCursorPos(&pt);
	if (state == MOUSEMOVESTATE_L_DOWN){
		dx = pt.x - x_prev;
		dy = pt.y - y_prev;
		GetWindowRect(top->hWnd, &rc);
		rc.left += dx;
		rc.top += dy;
		SetWindowPos(top->hWnd, NULL, rc.left, rc.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
		x_prev = pt.x;
		y_prev = pt.y;
	}
}

static void mousebutton(WWindow *_this, int x, int y, MouseButtonState state){
	POINT pt;
	GetCursorPos(&pt);
	if (state == MOUSEBUTTONSTATE_L_PUSH){
		x_prev = pt.x;
		y_prev = pt.y;
	}else if(state == MOUSEBUTTONSTATE_L_RELEASE){
		x_prev = pt.x;
		y_prev = pt.y;
	}else if(state == MOUSEBUTTONSTATE_R_RELEASE){
		wwindow_hide(top);
	}
}

static void expose(WWindow *_this, WGraphics *g, int x, int y, int width, int height){
	wgraphics_set_pen(g, 3, 128, 128, 128);
	wgraphics_set_brush(g, colormode, colormode, colormode);
	wgraphics_rectangle(g, 0, 0, width, height);
}

static void timerproc(unsigned int id, void *data){
	if (colormode == COLORMODE_BLACK) colormode = COLORMODE_WHITE;
	else colormode  = COLORMODE_BLACK;
	wdrawable_invalidate_whole(draw);
}

void black_white_resize(int width, int height){
	black_white_width = width, black_white_height = height;
	if (!top || !draw) return;
	wwindow_set_size(top, width, height);
	wwindow_set_size(draw, width, height);
	wdrawable_invalidate_whole(draw);
}

WWindow *black_white_new(WApp *wapp){
	WTimer *timer;
	if (top) return top;
	top = wtop_new(wapp, 0, 0, black_white_width, black_white_height, WTOPMODE_POPUP);
	draw = wdrawable_new(wapp, top, 0, 0, black_white_width, black_white_height);
	wwindow_validate_callback(draw, VALIDATECALLBACK_MOUSEMOVE | VALIDATECALLBACK_MOUSEBUTTON);
	draw->mousemove = mousemove;
	draw->mousebutton = mousebutton;
	WDRAWABLE_EXPOSE(draw) = expose;
	timer = wapp_get_timer(wapp);
	wtimer_regist_callback(timer, 500, timerproc, NULL);
	wwindow_show(draw);
	SetWindowPos(top->hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	return top;
}

void black_white_show(void){
	wwindow_show(top);
}

void black_white_hide(void){
	wwindow_hide(top);
}

void black_white_get_pos(int *x, int *y){
	RECT rc;
	GetWindowRect(top->hWnd, &rc);
	if (x) *x = rc.left;
	if (y) *y = rc.top;
}
