/*
 * Copyright (c) 2003,2004,2006 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wwin.h"
#include "black_white.h"
#include "resizer.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <shlobj.h>

#define FILENAME	"w_magnet"

#define WIN_WIDTH	100
#define WIN_HEIGHT	 20

#define DIALOG_WIDTH	370
#define DIALOG_HEIGHT	430

#define CHECK_TRANS_X	20
#define CHECK_TRANS_Y	10
#define CHECK_TRANS_WIDTH	350
#define CHECK_TRANS_HEIGHT	20

#define CHECK_TRANS_WINDOW_X	20
#define CHECK_TRANS_WINDOW_Y	40
#define CHECK_TRANS_WINDOW_WIDTH	350
#define CHECK_TRANS_WINDOW_HEIGHT	20

#define L0_X	20
#define L0_Y	(CHECK_TRANS_WINDOW_Y + 40)
#define L0_WIDTH	90
#define L0_HEIGHT	25

#define L00_X	(L0_X + L0_WIDTH + 5)
#define L00_Y	(L0_Y - 10)
#define L00_WIDTH	30
#define L00_HEIGHT	50

#define TRACKBAR_TRANS_X	(L00_X + L00_WIDTH + 10)
#define TRACKBAR_TRANS_Y	(L0_Y)
#define TRACKBAR_TRANS_WIDTH	(DIALOG_WIDTH - (TRACKBAR_TRANS_X + 10 + L00_WIDTH))
#define TRACKBAR_TRANS_HEIGHT	30

#define L05_X	20
#define L05_Y	(TRACKBAR_TRANS_Y + TRACKBAR_TRANS_HEIGHT + 10)
#define L05_WIDTH	120
#define L05_HEIGHT	20

#define L01_X	(TRACKBAR_TRANS_X + TRACKBAR_TRANS_WIDTH + 5)
#define L01_Y	(L00_Y - 5)
#define L01_WIDTH	(L00_WIDTH)
#define L01_HEIGHT	(L00_HEIGHT + 10)

#define RADIO_VERT_WINDOW_X1 (L05_X + L05_WIDTH + 10)
#define RADIO_VERT_WINDOW_Y	(TRACKBAR_TRANS_Y + TRACKBAR_TRANS_HEIGHT + 10)
#define RADIO_VERT_WINDOW_WIDTH	50
#define RADIO_VERT_WINDOW_HEIGHT 20
#define RADIO_VERT_WINDOW_X2 (RADIO_VERT_WINDOW_X1 + RADIO_VERT_WINDOW_WIDTH + 10)

#define BUTTON_RESIZE_X 10
#define BUTTON_RESIZE_Y (RADIO_VERT_WINDOW_Y + RADIO_VERT_WINDOW_HEIGHT + 10)
#define BUTTON_RESIZE_WIDTH 300
#define BUTTON_RESIZE_HEIGHT 20

#define PIXMAP_WIDTH 25
#define PIXMAP_HEIGHT 20

#define COLOR_BG_X      20
#define COLOR_BG_Y      (BUTTON_RESIZE_Y + BUTTON_RESIZE_HEIGHT + 10)
#define COLOR_BG_WIDTH  30
#define COLOR_BG_HEIGHT 25

#define L1_X      60
#define L1_Y      (COLOR_BG_Y + 3)
#define L1_WIDTH  150
#define L1_HEIGHT (COLOR_BG_HEIGHT - 6)

#define L2_X      30
#define L2_Y      (L1_Y + 30)
#define L2_WIDTH  80
#define L2_HEIGHT L1_HEIGHT

#define COLOR_1_X      20
#define COLOR_1_Y      (L2_Y + 30)
#define COLOR_1_WIDTH  COLOR_BG_WIDTH
#define COLOR_1_HEIGHT COLOR_BG_HEIGHT

#define COLOR_2_X      60
#define COLOR_2_Y      COLOR_1_Y
#define COLOR_2_WIDTH  COLOR_BG_WIDTH
#define COLOR_2_HEIGHT COLOR_BG_HEIGHT

#define L3_X      100
#define L3_Y      (COLOR_1_Y + 3)
#define L3_WIDTH  170
#define L3_HEIGHT L1_HEIGHT

#define L4_X      30
#define L4_Y      (L3_Y + 30)
#define L4_WIDTH  80
#define L4_HEIGHT L1_HEIGHT

#define PRE_BG_X      130
#define PRE_BG_Y      L2_Y
#define PRE_BG_WIDTH  WIN_WIDTH
#define PRE_BG_HEIGHT WIN_HEIGHT

#define PRE_1_X      130
#define PRE_1_Y      L4_Y
#define PRE_1_WIDTH  WIN_WIDTH
#define PRE_1_HEIGHT WIN_HEIGHT

#define PRE_2_X      130
#define PRE_2_Y      (PRE_1_Y+WIN_HEIGHT)
#define PRE_2_WIDTH  WIN_WIDTH
#define PRE_2_HEIGHT WIN_HEIGHT

#define BUTTON_POS_X	20
#define BUTTON_POS_Y	(PRE_2_Y + PRE_2_HEIGHT + 10)
#define BUTTON_POS_WIDTH	 100
#define BUTTON_POS_HEIGHT 20

#define L5_X      30
#define L5_Y      (BUTTON_POS_Y + BUTTON_POS_HEIGHT + 15)
#define L5_WIDTH  180
#define L5_HEIGHT L1_HEIGHT

#define BUTTON_OK_X	200
#define BUTTON_OK_Y	(L5_Y + L5_HEIGHT + 15)
#define BUTTON_OK_WIDTH	 100
#define BUTTON_OK_HEIGHT 20


#define L6_X		(BUTTON_POS_X + BUTTON_POS_WIDTH + 5)
#define L6_Y		(BUTTON_POS_Y - 10)
#define L6_WIDTH	240
#define L6_HEIGHT	40

#define ENTRY_X      50
#define ENTRY_Y      BUTTON_OK_Y
#define ENTRY_WIDTH  110
#define ENTRY_HEIGHT BUTTON_OK_HEIGHT


BOOL g_t = FALSE, g_tw = FALSE;
/* COLORREF g_rgb_bg = 0x808080, g_rgb_1 = 0xff0000, g_rgb_2 = 0xffffff; */
COLORREF g_rgb_bg = 0x808080, g_rgb_1 = 0x504040, g_rgb_2 = 0xfff0f0;
WGraphics *g_pixmap, *g_w_magnet;
WDrawable *g_draw_pbg, *g_draw_p1, *g_draw_p2;
WEntry *g_entry;
WWindow *g_black_white = NULL;
WTrackbar *g_trackbar_trans = NULL;
WRadioButton *g_radio_horz = NULL, *g_radio_vert = NULL;
Resizer *g_resizer = NULL;

COLORREF color_dialog(HWND hWnd, COLORREF def){
	static COLORREF c16[16] =
		{0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 
		 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff, 0xffffff};
	CHOOSECOLOR cc;
	cc.lStructSize = sizeof(CHOOSECOLOR);
	cc.hwndOwner = hWnd;
	cc.hInstance = NULL;
	cc.rgbResult = def;
	cc.lpCustColors = c16;
	cc.Flags = 0;
	ChooseColor(&cc);
	return cc.rgbResult;
}

char *get_curdir(void){
	static char *string = NULL;
	int length, length2;
	if (string) free(string);
	length = MAX_PATH;
	string = (char *)malloc((length + 1) * sizeof(char));
	length2 = GetCurrentDirectoryA(length, string);
	if (length2 > length){
		string = realloc(string, (length2 + 1) * sizeof(char));
		GetCurrentDirectoryA(length2, string);
	}
	return string;
}

void create_shortcut(void){
	OLECHAR *saveto_ole = NULL;
	int length_ole, length_curdir, x, y;
	char pos[100];
	char str_g_t[10], str_g_tw[10], str_g_size[20];
	char *str_vt = "";
	char *current;
	char *linkto = NULL, *saveto = NULL;
	char link_params[200];
	unsigned long cb, cg1, cg2;
	IShellLink *pLink = NULL;
	IPersistFile *pPersist = NULL;
	CoInitialize(NULL);

	cb = (g_rgb_bg & 0xff0000) >> 16 | (g_rgb_bg & 0xff00) | (g_rgb_bg & 0xff) << 16;
	cg1 = (g_rgb_1 & 0xff0000) >> 16 | (g_rgb_1 & 0xff00) | (g_rgb_1 & 0xff) << 16;
	cg2 = (g_rgb_2 & 0xff0000) >> 16 | (g_rgb_2 & 0xff00) | (g_rgb_2 & 0xff) << 16;
	if (g_tw) g_t = FALSE;
	if (g_black_white){
		black_white_get_pos(&x, &y);
		sprintf(pos,"--position +%d+%d", x, y);
	}else{
		pos[0] = '\0';
	}
	sprintf(str_g_size, "--size %dx%d", g_resizer->rect_width, g_resizer->rect_height);
	str_g_t[0] = '\0';
	str_g_tw[0] = '\0';
	if (g_t){
		sprintf(str_g_t, "-t%d", wtrackbar_get_value(g_trackbar_trans));
	}
	if (g_tw){
		sprintf(str_g_tw, "-tw%d", wtrackbar_get_value(g_trackbar_trans));
	}
	if (WRADIOBUTTON_STATE(g_radio_vert) == WRADIOBUTTON_STATE_ON){
		str_vt = "-vt";
	}
	sprintf(link_params, "%s %s %s -b%06x -g%06x%06x %s %s",
		str_g_t, str_g_tw, str_vt, cb, cg1, cg2, pos, str_g_size);


	current = get_curdir();
	length_curdir = strlen(current);
	length_curdir += sizeof(FILENAME) + 10;

	if (CoCreateInstance(&CLSID_ShellLink, NULL, 
			CLSCTX_INPROC_SERVER, &IID_IShellLinkA, (void **)&pLink) != S_OK) goto end_create_shortcut;

	linkto = (char *)malloc(length_curdir * sizeof(char) + 20);

	sprintf(linkto, "%s\\%s.exe ", current, FILENAME);
	pLink->lpVtbl->SetPath(pLink, linkto);
	pLink->lpVtbl->SetArguments(pLink, link_params);
	if (pLink->lpVtbl->QueryInterface(pLink, &IID_IPersistFile, (void **)&pPersist) != S_OK) goto end_create_shortcut;

	saveto = (char *)malloc(strlen(wentry_get_text(g_entry))+10);
	sprintf(saveto, "%s.lnk", wentry_get_text(g_entry));

	length_ole = strlen(saveto);
	saveto_ole = malloc((length_ole + 1) * sizeof(OLECHAR));
	memset(saveto_ole, 0, (length_ole + 1) * sizeof(OLECHAR));
	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, saveto, -1, saveto_ole, length_ole);
	if (pPersist->lpVtbl->Save(pPersist, saveto_ole, TRUE) != S_OK) goto end_create_shortcut;
	
	MessageBox(NULL, "V[gJbg쐬܂D", "Information", MB_ICONINFORMATION | MB_OK);

end_create_shortcut:
	if (linkto) free(linkto);
	if (saveto) free(saveto);
	if (saveto_ole) free(saveto_ole);
	if (pLink) pLink->lpVtbl->Release(pLink);
	if (pPersist) pPersist->lpVtbl->Release(pPersist);
	CoUninitialize();
}


void destroy(WWindow *w){
	wapp_exitloop(wwindow_get_wapp(w));
}

typedef struct{
	unsigned char r, g, b;
}Color;

Color change_luminance(Color src, unsigned char y){
	Color dest;
	double cb, cr, r, g, b;
	cb = -0.16874 * (double)src.r - 0.33126 * (double)src.g + 0.5 * (double)src.b;
	cr =0.5 * (double)src.r - 0.41869 * (double)src.g - 0.08131 * (double)src.b;
	
	r = (double)y + 1.402*cr;
	g = (double)y - 0.34414*cb - 0.71414*cr;
	b = (double)y + 1.772 * cb;
	if (r > 255.0) r = 255.0;	if (g > 255.0) g = 255.0;	if (b > 255.0) b = 255.0;
	if (r < 0.0) r = 0.0;	if (g < 0.0) g = 0.0;	if (b < 0.0) b = 0.0;
	dest.r = (unsigned char)r;	dest.g = (unsigned char)g;	dest.b = (unsigned char)b;
	return dest;
}

void draw_w_magnet(WGraphics *draw, COLORREF rgb_bg, COLORREF rgb_1, COLORREF rgb_2){
	int i, j, y;
	double dx, dy, d;
	Color c_face[3], c_hilight[3], c_dark[3], c_grad, c_tmp, color_bg, color_1, color_2;
	WPoint
		p1[4] = {{ 0, 0}, { 3, 3}, {WIN_WIDTH - 4, 3}, {WIN_WIDTH - 1, 0}},
		p2[4] = {{ 0, 0}, { 3, 3}, { 3, WIN_HEIGHT - 4}, {0, WIN_HEIGHT - 1}},
		p3[4] = {{WIN_WIDTH - 1, 0}, {WIN_WIDTH - 4, 3}, {WIN_WIDTH - 4, WIN_HEIGHT - 4}, {WIN_WIDTH - 1, WIN_HEIGHT - 1}},
		p4[4] = {{WIN_WIDTH - 1, WIN_HEIGHT - 1}, {WIN_WIDTH - 4, WIN_HEIGHT - 4}, { 3, WIN_HEIGHT - 4}, { 0, WIN_HEIGHT - 1}};

	color_bg.r = (rgb_bg & 0xff);
	color_bg.g = (rgb_bg & 0xff00) >> 8;
	color_bg.b = (rgb_bg & 0xff0000) >> 16;
	color_1.r = (rgb_1 & 0xff);
	color_1.g = (rgb_1 & 0xff00) >> 8;
	color_1.b = (rgb_1 & 0xff0000) >> 16;
	color_2.r = (rgb_2 & 0xff);
	color_2.g = (rgb_2 & 0xff00) >> 8;
	color_2.b = (rgb_2 & 0xff0000) >> 16;

	c_tmp.r = (color_1.r + color_2.r)/2;
	c_tmp.g = (color_1.g + color_2.g)/2;
	c_tmp.b = (color_1.b + color_2.b)/2;

	c_dark[0] = c_dark[2] = change_luminance(c_tmp, 64);
	c_hilight[0] = c_hilight[2] = change_luminance(c_tmp, 192);

	c_face[1] = color_bg;
	c_dark[1] = change_luminance(color_bg, 96);
	c_hilight[1] = change_luminance(color_bg, 168);

	y = 0;
	for (j = 0; j < 3; j++){
		wgraphics_set_pen(draw, 1, c_hilight[j].r, c_hilight[j].g, c_hilight[j].b);
		wgraphics_set_brush(draw, c_hilight[j].r, c_hilight[j].g, c_hilight[j].b);
		wgraphics_polygon(draw, p1, 4);
		wgraphics_polygon(draw, p2, 4);
		wgraphics_set_pen(draw, 1, c_dark[j].r, c_dark[j].g, c_dark[j].b);
		wgraphics_set_brush(draw, c_dark[j].r, c_dark[j].g, c_dark[j].b);
		wgraphics_polygon(draw, p3, 4);
		wgraphics_polygon(draw, p4, 4);
		switch(j){
		case 0:		//\
			dx = WIN_WIDTH - 7;
			for (i = 3, d = 0.0; i < WIN_WIDTH - 3; i++, d += 1.0 / dx){
				c_grad.r = color_1.r + (color_2.r-color_1.r)*d;
				c_grad.g = color_1.g + (color_2.g-color_1.g)*d;
				c_grad.b = color_1.b + (color_2.b-color_1.b)*d;
				wgraphics_set_pen(draw, 1, c_grad.r, c_grad.g, c_grad.b);
				wgraphics_line(draw, i, y + 2, i, WIN_HEIGHT - 3);
			}
			break;
		case 1:		//m[}
			wgraphics_set_pen(draw, 1, c_face[j].r, c_face[j].g, c_face[j].b);
			wgraphics_set_brush(draw, c_face[j].r, c_face[j].g, c_face[j].b);
			wgraphics_rectangle(draw, 2, y + 2, WIN_WIDTH - 5, WIN_HEIGHT - 5);
			break;
		case 2:		//ړ
			dy = WIN_HEIGHT - 6;
			for (i = 2, d = 0.0; i < WIN_HEIGHT - 3; i++, d += 1.0 / dy){
				c_grad.r = color_1.r + (color_2.r-color_1.r)*d;
				c_grad.g = color_1.g + (color_2.g-color_1.g)*d;
				c_grad.b = color_1.b + (color_2.b-color_1.b)*d;
				wgraphics_set_pen(draw, 1, c_grad.r, c_grad.g, c_grad.b);
				wgraphics_line(draw, 2, y + i, WIN_WIDTH - 3, y + i);
			}
			break;
		}
		for (i = 0; i < 4; i++){
			p1[i].y += WIN_HEIGHT;	p2[i].y += WIN_HEIGHT;
			p3[i].y += WIN_HEIGHT;	p4[i].y += WIN_HEIGHT;
		}
		y += WIN_HEIGHT;
	}
}

void clicked_resize(WTextButton *w, WTextButtonState state){
	resizer_show((Resizer *)w->userdata.vp);
}

void resizer_resize(int width, int height){
	black_white_resize(width, height);
}

void draw_pixmap(WGraphics *draw, COLORREF rgb_bg, COLORREF rgb_1, COLORREF rgb_2){
	Color c;
	wgraphics_set_pen(draw, 1, 255, 255, 255);
	c.r = rgb_bg & 0xff; c.g = (rgb_bg & 0xff00) >> 8; c.b = (rgb_bg & 0xff0000) >> 16;
	wgraphics_set_brush(draw, c.r, c.g, c.b);
	wgraphics_rectangle(draw, 0, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
	c.r = rgb_1 & 0xff; c.g = (rgb_1 & 0xff00) >> 8; c.b = (rgb_1 & 0xff0000) >> 16;
	wgraphics_set_brush(draw, c.r, c.g, c.b);
	wgraphics_rectangle(draw, PIXMAP_WIDTH, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
	c.r = rgb_2 & 0xff; c.g = (rgb_2 & 0xff00) >> 8; c.b = (rgb_2 & 0xff0000) >> 16;
	wgraphics_set_brush(draw, c.r, c.g, c.b);
	wgraphics_rectangle(draw, PIXMAP_WIDTH*2, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
}

void clicked_trans(WTextButton *w, WTextButtonState state){
	g_t = (state == WTEXTBUTTON_STATE_ON);
	if (!g_t){
		g_tw = FALSE;
		wtextbutton_set_state((WTextButton *)(w->userdata.vp), state);
		EnableWindow(WTRACKBAR_HWND(g_trackbar_trans), FALSE);
	}else{
		EnableWindow(WTRACKBAR_HWND(g_trackbar_trans), TRUE);
	}
}

void clicked_trans_window(WTextButton *w, WTextButtonState state){
	g_tw = (state == WTEXTBUTTON_STATE_ON);
	if (g_tw){
		g_t = TRUE;
		wtextbutton_set_state((WTextButton *)(w->userdata.vp), state);
		EnableWindow(WTRACKBAR_HWND(g_trackbar_trans), TRUE);
	}else{
		EnableWindow(WTRACKBAR_HWND(g_trackbar_trans), TRUE);
	}
}

void draw_preview_face(WGraphics *face, int height){
	wgraphics_copyto(g_w_magnet, face, 0, height, WIN_WIDTH, WIN_HEIGHT, 0, 0);
}

void draw_preview_bg(WGraphics *g){
	draw_preview_face(g, WIN_HEIGHT);
}

void draw_preview_1_2(void){
	wdrawable_invalidate_whole(g_draw_p1);
	wdrawable_invalidate_whole(g_draw_p2);
}

void expose_bg(WDrawable *w, WGraphics *g, int x, int y, int width, int height){
	draw_preview_bg(g);
}

void expose_1(WDrawable *w, WGraphics *g, int x, int y, int width, int height){
	draw_preview_face(g, 0);
}

void expose_2(WDrawable *w, WGraphics *g, int x, int y, int width, int height){
	draw_preview_face(g, WIN_HEIGHT*2);
}

void clicked_color_bg(WGraphicButton *w, WGraphicButtonState state){
	COLORREF color;
	color = color_dialog(w->hWnd, g_rgb_bg);
	g_rgb_bg = color;
	draw_pixmap(g_pixmap, g_rgb_bg, g_rgb_1, g_rgb_2);
	draw_w_magnet(g_w_magnet, g_rgb_bg, g_rgb_1, g_rgb_2);
	wdrawable_invalidate_whole(g_draw_pbg);
	wgraphicbutton_invalidate(w);
}

void clicked_color_1(WGraphicButton *w, WGraphicButtonState state){
	COLORREF color;
	color = color_dialog(w->hWnd, g_rgb_1);
	g_rgb_1 = color;
	draw_pixmap(g_pixmap, g_rgb_bg, g_rgb_1, g_rgb_2);
	draw_w_magnet(g_w_magnet, g_rgb_bg, g_rgb_1, g_rgb_2);
	draw_preview_1_2();
	wgraphicbutton_invalidate(w);
}

void clicked_color_2(WGraphicButton *w, WGraphicButtonState state){
	COLORREF color;
	color = color_dialog(w->hWnd, g_rgb_2);
	g_rgb_2 = color;
	draw_pixmap(g_pixmap, g_rgb_bg, g_rgb_1, g_rgb_2);
	draw_w_magnet(g_w_magnet, g_rgb_bg, g_rgb_1, g_rgb_2);
	draw_preview_1_2();
	wgraphicbutton_invalidate(w);
}

void clicked_ok(WTextButton *w, WTextButtonState state){
	create_shortcut();
}

void clicked_pos(WTextButton *w, WTextButtonState state){
	g_black_white = black_white_new(wwindow_get_wapp(w));
	black_white_show();
}

void create_window(WApp *wapp){
	WTop *top;
	WTextButton *check_trans, *check_trans_window, *textbutton_ok, *textbutton_pos, *textbutton_resize;
	WGraphicButton *color_bg, *color_1, *color_2;
	Resizer *resizer;
	WLabel *l0, *l00, *l01, *l05, *l1, *l2, *l3, *l4, *l5, *l6;

	g_pixmap = wgraphics_new(PIXMAP_WIDTH * 3, PIXMAP_HEIGHT);
	draw_pixmap(g_pixmap, g_rgb_bg, g_rgb_1, g_rgb_2);
	top = wtop_new(wapp, 0, 0, DIALOG_WIDTH, DIALOG_HEIGHT, WTOPMODE_NORMAL);
	wtop_set_name(top, "WinMagnet Ver 1.47 V[gJbg쐬c[");
	wwindow_validate_callback(top, VALIDATECALLBACK_DESTROY);
	top->destroy = destroy;

	check_trans = wtextbutton_new(wapp, top, CHECK_TRANS_X, CHECK_TRANS_Y, CHECK_TRANS_WIDTH, CHECK_TRANS_HEIGHT, "}Olbg𓧖", WTEXTBUTTON_MODE_CHECKBOX);
	WTEXTBUTTON_CLICKED(check_trans) = clicked_trans;

	check_trans_window = wtextbutton_new(wapp, top,
		CHECK_TRANS_WINDOW_X, CHECK_TRANS_WINDOW_Y, CHECK_TRANS_WINDOW_WIDTH, CHECK_TRANS_WINDOW_HEIGHT, "tEBhE𓧖", WTEXTBUTTON_MODE_CHECKBOX);
	check_trans_window->userdata.vp = check_trans;
	WTEXTBUTTON_CLICKED(check_trans_window) = clicked_trans_window;

	check_trans->userdata.vp = check_trans_window;

	color_bg = wgraphicbutton_new(wapp,top,
		COLOR_BG_X, COLOR_BG_Y, COLOR_BG_WIDTH, COLOR_BG_HEIGHT, WGRAPHICBUTTON_MODE_NORMAL);
	wgraphicbutton_set_graphics(color_bg, g_pixmap, WGRAPHICBUTTON_SETGRAPHICSTATE_OFF, 0, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
	wgraphicbutton_set_graphics(color_bg, g_pixmap, WGRAPHICBUTTON_SETGRAPHICSTATE_PUSHING, 0, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
	WGRAPHICBUTTON_CLICKED(color_bg) = clicked_color_bg;

	l0 = wlabel_new(wapp, top, L0_X, L0_Y, L0_WIDTH, L0_HEIGHT, "x");
	l00 = wlabel_new(wapp, top, L00_X, L00_Y, L00_WIDTH, L00_HEIGHT, "");
	l01 = wlabel_new(wapp, top, L01_X, L01_Y, L01_WIDTH, L01_HEIGHT, "s");

	l05 = wlabel_new(wapp, top, L05_X, L05_Y, L05_WIDTH, L05_HEIGHT, "x{^̈ʒu");

	l1 = wlabel_new(wapp, top, L1_X, L1_Y, L1_WIDTH, L1_HEIGHT, "ʏ펞̐F̐ݒ");

	l2 = wlabel_new(wapp, top, L2_X, L2_Y, L2_WIDTH, L2_HEIGHT, "vr[");

	color_1 = wgraphicbutton_new(wapp, top,
		COLOR_1_X, COLOR_1_Y, COLOR_1_WIDTH, COLOR_1_HEIGHT, WGRAPHICBUTTON_MODE_NORMAL);
	wgraphicbutton_set_graphics(color_1, g_pixmap, WGRAPHICBUTTON_SETGRAPHICSTATE_OFF, PIXMAP_WIDTH, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
	wgraphicbutton_set_graphics(color_1, g_pixmap, WGRAPHICBUTTON_SETGRAPHICSTATE_PUSHING, PIXMAP_WIDTH, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
	WGRAPHICBUTTON_CLICKED(color_1) = clicked_color_1;

	color_2 = wgraphicbutton_new(wapp, top,
		COLOR_2_X, COLOR_2_Y, COLOR_2_WIDTH, COLOR_2_HEIGHT, WGRAPHICBUTTON_MODE_NORMAL);
	wgraphicbutton_set_graphics(color_2, g_pixmap, WGRAPHICBUTTON_SETGRAPHICSTATE_OFF, PIXMAP_WIDTH*2, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
	wgraphicbutton_set_graphics(color_2, g_pixmap, WGRAPHICBUTTON_SETGRAPHICSTATE_PUSHING, PIXMAP_WIDTH*2, 0, PIXMAP_WIDTH, PIXMAP_HEIGHT);
	WGRAPHICBUTTON_CLICKED(color_2) = clicked_color_2;

	l3 = wlabel_new(wapp, top, L3_X, L3_Y, L3_WIDTH, L3_HEIGHT, "\\̐F̐ݒ");

	l4 = wlabel_new(wapp, top, L4_X, L4_Y, L4_WIDTH, L4_HEIGHT, "vr[");

	l5 = wlabel_new(wapp, top, L5_X, L5_Y, L5_WIDTH, L5_HEIGHT, "V[gJbg");

	l6 = wlabel_new(wapp, top, L6_X, L6_Y, L6_WIDTH, L6_HEIGHT, "ɓ_łEBhËʒuWinMagnetN܂D");

	resizer = resizer_new(wapp, WIN_WIDTH, WIN_HEIGHT);
	resizer->resize = resizer_resize;
	g_resizer = resizer;

	g_entry = wentry_new(wapp, top, ENTRY_X, ENTRY_Y, ENTRY_WIDTH, ENTRY_HEIGHT, "WinMagnet");

	g_radio_horz = wradiobutton_new(wapp, top, NULL, 
		RADIO_VERT_WINDOW_X1, RADIO_VERT_WINDOW_Y, RADIO_VERT_WINDOW_WIDTH, RADIO_VERT_WINDOW_HEIGHT, "E[");
	g_radio_vert = wradiobutton_new(wapp, top, g_radio_horz,
		RADIO_VERT_WINDOW_X2, RADIO_VERT_WINDOW_Y, RADIO_VERT_WINDOW_WIDTH, RADIO_VERT_WINDOW_HEIGHT, "[");

	textbutton_ok = wtextbutton_new(wapp, top,
		BUTTON_OK_X, BUTTON_OK_Y, BUTTON_OK_WIDTH, BUTTON_OK_HEIGHT, "쐬I", WTEXTBUTTON_MODE_NORMAL);
	WTEXTBUTTON_CLICKED(textbutton_ok) = clicked_ok;

	textbutton_ok = wtextbutton_new(wapp, top,
		BUTTON_OK_X, BUTTON_OK_Y, BUTTON_OK_WIDTH, BUTTON_OK_HEIGHT, "쐬I", WTEXTBUTTON_MODE_NORMAL);
	WTEXTBUTTON_CLICKED(textbutton_ok) = clicked_ok;

	textbutton_pos = wtextbutton_new(wapp, top,
		BUTTON_POS_X, BUTTON_POS_Y, BUTTON_POS_WIDTH, BUTTON_POS_HEIGHT, "Nʒu", WTEXTBUTTON_MODE_NORMAL);
	WTEXTBUTTON_CLICKED(textbutton_pos) = clicked_pos;

	textbutton_resize = wtextbutton_new(wapp, top,
		BUTTON_RESIZE_X, BUTTON_RESIZE_Y, BUTTON_RESIZE_WIDTH, BUTTON_RESIZE_HEIGHT, "TCY", WTEXTBUTTON_MODE_NORMAL);
	WTEXTBUTTON_CLICKED(textbutton_resize) = clicked_resize;
	textbutton_resize->userdata.vp = (void *)resizer;

	g_trackbar_trans = wtrackbar_new(wapp, top,
		TRACKBAR_TRANS_X, TRACKBAR_TRANS_Y, TRACKBAR_TRANS_WIDTH, TRACKBAR_TRANS_HEIGHT, WTRACKBARMODE_HORZ);
	wtrackbar_set_max_min(g_trackbar_trans, 255, 1);
	wtrackbar_set_value(g_trackbar_trans, 127);
	EnableWindow(WTRACKBAR_HWND(g_trackbar_trans), FALSE);

	g_w_magnet = wgraphics_new(WIN_WIDTH, WIN_HEIGHT*3);
	draw_w_magnet(g_w_magnet, g_rgb_bg, g_rgb_1, g_rgb_2);

	g_draw_pbg = wdrawable_new(wapp, top, PRE_BG_X, PRE_BG_Y, PRE_BG_WIDTH, PRE_BG_HEIGHT);
	g_draw_p1 = wdrawable_new(wapp, top, PRE_1_X, PRE_1_Y, PRE_1_WIDTH, PRE_1_HEIGHT);
	g_draw_p2 = wdrawable_new(wapp, top, PRE_2_X, PRE_2_Y, PRE_2_WIDTH, PRE_2_HEIGHT);
	
	draw_preview_1_2();
	WDRAWABLE_EXPOSE(g_draw_pbg) = expose_bg;
	WDRAWABLE_EXPOSE(g_draw_p1) = expose_1;
	WDRAWABLE_EXPOSE(g_draw_p2) = expose_2;
	wdrawable_invalidate_whole(g_draw_pbg);

	wwindow_show(top);
	wwindow_show(check_trans);
	wwindow_show(check_trans_window);
	wwindow_show(color_bg);
	wwindow_show(color_1);
	wwindow_show(color_2);
	wwindow_show(l0);
	wwindow_show(l00);
	wwindow_show(l01);
	wwindow_show(l05);
	wwindow_show(l1);
	wwindow_show(l2);
	wwindow_show(l3);
	wwindow_show(l4);
	wwindow_show(l5);
	wwindow_show(l6);
	wwindow_show(g_draw_pbg);
	wwindow_show(g_draw_p1);
	wwindow_show(g_draw_p2);
	wwindow_show(g_entry);
	wwindow_show(g_radio_horz);
	wwindow_show(g_radio_vert);
	wwindow_show(textbutton_ok);
	wwindow_show(textbutton_pos);
	wwindow_show(textbutton_resize);
	wwindow_show(g_trackbar_trans);
}

int main(int argc, char **argv){
	WApp *wapp;
	wapp = wapp_new();

	create_window(wapp);
	wapp_run(wapp);
	return 0;
}
