/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <windows.h>
#include "osversion.h"

typedef enum {
	WINDOWS_95, WINDOWS_98, WINDOWS_ME, WINDOWS_NT35, WINDOWS_NT4, WINDOWS_2K, WINDOWS_XP, WINDOWS_UNKNOWN,
}_OS_VERSION;

char *osversion_get(void){
	char *version;
	OSVERSIONINFO vi;
	vi.dwOSVersionInfoSize = sizeof(vi);
	
	version = "";
	if (!GetVersionEx(&vi)){
		version = "";
	}else{
		if (vi.dwMajorVersion == 4){
			switch(vi.dwMinorVersion){
				case 0:
					if (vi.dwPlatformId == 1){
						version = "95";	//Windows95
					}else if (vi.dwPlatformId == 2){
						version = "NT4.0";	//NT4
					}
					break;
				case 10:
					version = "98";	//Windows98
					break;
				case 90:
					version = "ME";	//WindowsME
					break;
				default:
					version = "";
					break;
			}
		}else if (vi.dwMajorVersion == 3){
			version = "NT3.5";	//NT35
		}else if (vi.dwMajorVersion == 5){
			switch(vi.dwMinorVersion){
				case 0:
					version = "2000";	//Windows2000
					break;
				case 1:
					version = "XP";	//WindowsXP
					break;
				default:
					version = "";
					break;
			}
		}
	}
	return version;
}

