/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <windows.h>
#include <stdlib.h>
#include "topenum.h"

typedef struct {
	int numofwindow;
	int numofalloc;
	HWND *array;
	HWND focus;
}TOPENUM;

static BOOL CALLBACK EnumProc(HWND hWnd, LPARAM lParam);
static TOPENUM g_topenum = {0, 0, NULL, NULL};

void *topenum_malloc(int size){
	return malloc(size);
}

void *topenum_realloc(void *data, int size){
	return realloc(data, size);
}

void topenum_free(void *data){
	free(data);
}

HWND topenum_get(HWND **hwnd, int *number){
	g_topenum.numofwindow = 0;
	g_topenum.focus = NULL;
	g_topenum.numofalloc = 50;
	g_topenum.array = (HWND *)topenum_malloc(g_topenum.numofalloc * sizeof(HWND));
	if (!g_topenum.array){
		g_topenum.numofalloc = 0;
		return NULL;
	}
	if (EnumWindows(EnumProc, 0) == 0){
		*number = 0;
		 return NULL;
	}
	*number = g_topenum.numofwindow;
	*hwnd = g_topenum.array;
	return g_topenum.focus;
}

static BOOL CALLBACK EnumProc(HWND hWnd, LPARAM lParam){
	HWND hForeground;
	RECT rc;

	hForeground = GetForegroundWindow();

	GetWindowRect(hWnd, &rc);
	g_topenum.array[g_topenum.numofwindow] = hWnd;
	if (hWnd == hForeground) g_topenum.focus = hWnd;

	g_topenum.numofwindow++;
	if (g_topenum.numofwindow == g_topenum.numofalloc){
		g_topenum.numofalloc += 50;
		g_topenum.array = (HWND *)topenum_realloc(g_topenum.array, g_topenum.numofalloc * sizeof(HWND));
	}
	if (!g_topenum.array){
		g_topenum.numofwindow = 0;
		return FALSE;
	}
	return TRUE;
}

