#include "stkw.h"
#include "topenum.h"
#include "osversion.h"
#include <stdio.h>

#define WIN_WIDTH	100
#define WIN_HEIGHT	 20

#define W_MAGNET_WIDTH	(WIN_WIDTH + WIN_HEIGHT)
#define W_MAGNET_HEIGHT	WIN_HEIGHT

#define WINMAGNET_TITLE	"Win magnet Ver 1.42"


int g_magnet_x, g_magnet_y;
int g_prev_x, g_prev_y;
int g_dx_cursor_me, g_dy_cursor_me, g_dx_me_cling, g_dy_me_cling, g_dx_cursor_move, g_dy_cursor_move;
StkwTimer *g_timer;
StkwTop *g_stkw_top;
StkwPixmap *g_pixmap;
StkwDrawWindow *g_stkw_draw;
HWND g_wid, g_wid_to_cling, g_wid_to_move;
STKW_BOOL g_is_topmost = STKW_FALSE, g_is_movingwindow = STKW_FALSE;
int g_interval_dblclick;
STKW_BOOL g_transparent = STKW_FALSE, g_transparent_cling = STKW_FALSE;
int g_transval = 255;

#ifdef STKW_WIN32
HMODULE hLib = NULL;
LONG g_exstyle_cling_prev = 0;
BOOL (WINAPI *set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = NULL;
BOOL (WINAPI *get_layered_window_attributes)(HWND, COLORREF *, BYTE *, DWORD *) = NULL;
typedef struct{
	COLORREF key;
	BYTE alpha;
	DWORD flag;
}TRANSPARENT_LAYER;
TRANSPARENT_LAYER g_tl;
HWND hProgman = NULL;
#endif

typedef struct {
	int width, height;
}W_MAGNET_SIZE;

typedef struct {
	int x, y, width, height;
}W_MAGNET_RECT;

typedef struct {
	HWND wid;
	POINT pt;
	W_MAGNET_SIZE size;
	STKW_BOOL is_viewable;
}ENUMWINDOWS_INFO;

ENUMWINDOWS_INFO *g_enumwindows_info = NULL;

int g_numofwindows;

void callback_quit(StkwTextButton *w, STKW_TEXTBUTTON_STATE state){
	stkw_quitloop();
}

void callback_resize(StkwWindow *w, int width, int height){
	stkw_window_set_size(w, W_MAGNET_WIDTH, W_MAGNET_HEIGHT);
}

void set_transparent(HWND wid, STKW_BOOL transparent){
#ifdef STKW_WIN32
	if (set_layered_window_attributes){
		if (transparent) set_layered_window_attributes(wid, 0, g_transval, LWA_ALPHA);
		else set_layered_window_attributes(wid, 0, 255, LWA_ALPHA);
	}
#endif
}

int get_pos_size(HWND hWnd, POINT *pt, W_MAGNET_SIZE *size){
	RECT rc;
	if (GetWindowRect(hWnd, &rc) == 0) return 0;
	pt->x = rc.left; pt->y = rc.top;
	size->width = rc.right - rc.left;
	size->height = rc.bottom - rc.top;
	return 1;
}

void get_enuminfo(void){
	HWND *hwnds;
	int number;
	int i;
	topenum_get(&hwnds, &number);
	g_numofwindows = number;
	if (g_enumwindows_info != NULL) free(g_enumwindows_info);
	g_enumwindows_info = (ENUMWINDOWS_INFO *)malloc(g_numofwindows * sizeof(ENUMWINDOWS_INFO));
	for (i = 0; i < g_numofwindows; i++){
		g_enumwindows_info[i].wid = hwnds[i];
		get_pos_size(hwnds[i], &(g_enumwindows_info[i].pt), &(g_enumwindows_info[i].size));
		g_enumwindows_info[i].is_viewable = IsWindowVisible(hwnds[i]);
	}
	topenum_free(hwnds);
}

void draw_face(StkwDraw *w){
	StkwDraw *draw_pixmap;
	draw_pixmap = STKW_DRAW(g_pixmap);
	stkw_draw_lock(draw_pixmap);
	stkw_draw_lock(w);
	if (g_is_movingwindow){
		stkw_draw_copyto(draw_pixmap, w, 0, WIN_HEIGHT*2, WIN_WIDTH, WIN_HEIGHT, 0, 0);
	}else if (g_wid_to_cling){	
		stkw_draw_copyto(draw_pixmap, w, 0, 0, WIN_WIDTH, WIN_HEIGHT, 0, 0);
	}else{
		stkw_draw_copyto(draw_pixmap, w, 0, WIN_HEIGHT, WIN_WIDTH, WIN_HEIGHT, 0, 0);
	}
	stkw_draw_unlock(w);
	stkw_draw_unlock(draw_pixmap);
}

void release_haritsukuwindow(void){
#ifdef STKW_WIN32
	if (g_transparent && g_transparent_cling){
		if (set_layered_window_attributes){
			set_layered_window_attributes(g_wid_to_cling, g_tl.key, g_tl.alpha, g_tl.flag);
		}
		SetWindowLong(g_wid_to_cling, GWL_EXSTYLE, g_exstyle_cling_prev);
	}
#endif
	g_wid_to_cling = NULL;
	ShowWindow(g_wid, SW_SHOW);
	draw_face(STKW_DRAW(g_stkw_draw));
}


void onexit(void){
	if (!g_is_topmost && g_wid_to_cling)
		SetWindowPos(g_wid_to_cling, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	if (g_wid_to_cling) release_haritsukuwindow();
}

STKW_BOOL is_mouse_move(void){
	POINT pt;
	STKW_BOOL ret;
	static int x_prev = -1, y_prev = -1;
	int x, y;
	GetCursorPos(&pt);
	x = pt.x; y = pt.y;
	if (x_prev == y_prev == -1){
		ret = STKW_TRUE;
	}else if(x_prev == x && y_prev == y){
		ret = STKW_FALSE;
	}else{
		ret = STKW_TRUE;
	}
	x_prev = x; y_prev = y;
	return ret;
}

STKW_BOOL is_in_desk(int x, int y){
	int w, h;
	w = GetSystemMetrics(SM_CXSCREEN);
	h = GetSystemMetrics(SM_CYSCREEN);
	if (x >= 0 && y >= 0 && x < w && y < h) return STKW_TRUE;
	return STKW_FALSE;
}

void process_for_win95(){
	POINT pt; W_MAGNET_SIZE size;
	static STKW_BOOL is_checked = STKW_FALSE, is_win95 = STKW_FALSE;
	static int x_prev, y_prev;
	int x, y;
	if (!is_checked){
		if (strcmp(osversion_get(), "95") == 0) is_win95 = STKW_TRUE;
		is_checked = STKW_TRUE;
		get_pos_size(g_wid, &pt, &size);
		x_prev = pt.x; y_prev = pt.y;
	}
	if (!is_win95){
		SetWindowPos(g_wid, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
	}else{
		get_pos_size(g_wid, &pt, &size);
		x = pt.x; y = pt.y;
		if (x != x_prev || y != y_prev){
			SetWindowPos(g_wid, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
			x_prev = x;
			y_prev = y;
		}
	}
}

void callback_timer(StkwTimer *_this, int id, void *data){
	POINT pt; W_MAGNET_SIZE size;
	int ret;
	int x, y;
	static int prev_x = -1, prev_y = -1;
	if (g_wid_to_cling){
		ret = get_pos_size(g_wid_to_cling, &pt, &size);
		x = pt.x; y = pt.y;

#ifdef STKW_WIN32
		if (ret == 0 || (x == 10000 && y == 10000)){
		//ץ齪λ˥ɥ(10000,10000)˰ư
#else
		if (ret == 0){
#endif
			release_haritsukuwindow();
			return;
		}
		if (prev_x != x || prev_y != y){
			SetWindowPos(g_wid, NULL, g_dx_me_cling + x, g_dy_me_cling + y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
		}
		if (is_in_desk(g_dx_me_cling + x, g_dy_me_cling + y)){
			g_magnet_x = g_dx_me_cling + x;
			g_magnet_y = g_dy_me_cling + y;
		}
		prev_x = x;
		prev_y = y;
//#ifdef	STKW_WM_WINDOWS
		process_for_win95();
//#endif
		if (ret == 0){
			if (!g_is_topmost){
				SetWindowPos(g_wid_to_cling, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
			}
			release_haritsukuwindow();
			return;
		}
	}else{
		SetWindowPos(g_wid, NULL, g_magnet_x, g_magnet_y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
	}
}

void toggle_timerstate(STKW_BOOL state){
	static unsigned int id = 0;
	if (state){
		id = stkw_timer_add(g_timer, 50, (void *)1, callback_timer);
	}else if(id != 0){
		stkw_timer_remove(g_timer, id);
	}
}

void callback_mousemove(StkwWindow *w, int mx, int my, int state){
	POINT pt;
	int x, y;
	if ((state & STKW_MOUSE_L_ON)){
		GetCursorPos(&pt);
		x = pt.x; y = pt.y;
		g_magnet_x = x - g_dx_cursor_me;
		g_magnet_y = y - g_dy_cursor_me;
		SetWindowPos(g_wid, 0, g_magnet_x, g_magnet_y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
		if (g_is_movingwindow){
			if (mx != g_prev_x || my != g_prev_y){
				SetWindowPos(g_wid_to_move, HWND_TOP, x - g_dx_cursor_move, y - g_dy_cursor_move, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
			}
		}
	}
}

STKW_BOOL is_clip(W_MAGNET_RECT *rc1, W_MAGNET_RECT *rc2){
	int xa1, ya1, xa2, ya2;
	int xb1, yb1, xb2, yb2;
	STKW_BOOL is_clip_x, is_clip_y;

	is_clip_x = STKW_FALSE;
	is_clip_y = STKW_FALSE;

	xa1 = rc1 -> x;
	ya1 = rc1 -> y;
	xa2 = xa1 + rc1 -> width;
	ya2 = ya1 + rc1 -> height;
	xb1 = rc2 -> x;
	yb1 = rc2 -> y;
	xb2 = xb1 + rc2 -> width;
	yb2 = yb1 + rc2 -> height;

	if (xa2 < xb2 && xa2 > xb1) is_clip_x = STKW_TRUE;
	if (xa1 < xb2 && xa1 > xb1) is_clip_x = STKW_TRUE;
	if (xb2 < xa2 && xb2 > xa1) is_clip_x = STKW_TRUE;
	if (xb1 < xa2 && xb1 > xa1) is_clip_x = STKW_TRUE;
	if (ya2 < yb2 && ya2 > yb1) is_clip_y = STKW_TRUE;
	if (ya1 < yb2 && ya1 > yb1) is_clip_y = STKW_TRUE;
	if (yb2 < ya2 && yb2 > ya1) is_clip_y = STKW_TRUE;
	if (yb1 < ya2 && yb1 > ya1) is_clip_y = STKW_TRUE;
	if (is_clip_x & is_clip_y) return STKW_TRUE;

	return STKW_FALSE;
	
}

HWND get_wid_to_haritsuku(void){
	HWND wid_ret = NULL;
	W_MAGNET_RECT rc1, rc2;
	W_MAGNET_SIZE s;
	POINT pt;
	int i;
	get_pos_size(g_wid, &pt, &s);
	rc1.x = pt.x; rc1.y = pt.y;
	rc1.width = WIN_WIDTH;
	rc1.height = WIN_HEIGHT;
	get_enuminfo();
	for (i = g_numofwindows - 1; i >= 0; i--){
		if (g_enumwindows_info[i].is_viewable == STKW_FALSE) continue;
		if (g_enumwindows_info[i].wid == g_wid) continue;
		rc2.x = g_enumwindows_info[i].pt.x;
		rc2.y = g_enumwindows_info[i].pt.y;
		rc2.width = g_enumwindows_info[i].size.width;
		rc2.height = g_enumwindows_info[i].size.height;
		if (is_clip(&rc1, &rc2)){
			wid_ret = g_enumwindows_info[i].wid;
		}
	}
	return wid_ret;
}

STKW_BOOL check_dblclick(void){
	static STKW_BOOL first = STKW_TRUE;
	static unsigned int time_prev;
	unsigned int time_now;
	static STKW_BOOL ret;
	if (first){
		first = STKW_FALSE;
		time_prev = timeGetTime();
		return STKW_FALSE;
	}else{
		time_now = timeGetTime();
		ret = STKW_FALSE;
		if (time_now - time_prev < g_interval_dblclick){
			ret = STKW_TRUE;
		}
		time_prev = time_now;
	}
	return ret;
}

void callback_mousebutton(StkwWindow *w, int mx, int my, int state){
	POINT pt;
	W_MAGNET_SIZE size;
	W_MAGNET_RECT rc_h, rc_me;
	HWND wid_prev;
	int cx, cy, x, y, wid_x, wid_y, x_haritsuku, y_haritsuku, x_move, y_move;
	GetCursorPos(&pt);
	cx = pt.x; cy = pt.y;
	x = mx;	y = my;
	if ((state & STKW_MOUSE_L_PUSH)){
		SetWindowPos(g_wid, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
		get_pos_size(g_wid, &pt, &size);
		wid_x = pt.x; wid_y = pt.y;
		g_dx_cursor_me = cx - wid_x;
		g_dy_cursor_me = cy - wid_y;
		if (check_dblclick()){
			g_is_movingwindow = STKW_TRUE;
			g_wid_to_move = get_wid_to_haritsuku();
			get_pos_size(g_wid_to_move, &pt, &size);
			x_move = pt.x; y_move = pt.y;
			g_dx_cursor_move = cx - x_move;
			g_dy_cursor_move = cy - y_move;
		}
		g_prev_x = x;
		g_prev_y = y;
		toggle_timerstate(STKW_FALSE);
	}else if ((state & STKW_MOUSE_R_RELEASE)){
		wid_prev = g_wid_to_cling;
		g_wid_to_cling = get_wid_to_haritsuku();
		if (wid_prev == g_wid_to_cling){
			stkw_drawwindow_set_bgcolor(STKW_DRAWWINDOW(w), (STKW_DRAW_COLOR){127, 127, 127});
// ط			stkw_setwindow(w, STKW_WINDOW_BGCOLOR, stkw_color_rgb(127, 127, 127), NULL);
			if (!g_is_topmost){
				SetWindowPos(g_wid_to_cling, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
			}
			release_haritsukuwindow();
		}
		if (g_wid_to_cling == hProgman) g_wid_to_cling = NULL;
		if (g_wid_to_cling){
			stkw_drawwindow_set_bgcolor(STKW_DRAWWINDOW(w), (STKW_DRAW_COLOR){100, 150, 224});
// ط			stkw_setwindow(w, STKW_WINDOW_BGCOLOR, stkw_color_rgb(100, 150, 224), NULL);

			get_pos_size(g_wid_to_cling, &pt, &size);
			x_haritsuku = pt.x; y_haritsuku = pt.y;
			get_pos_size(g_wid, &pt, &size);
			wid_x = pt.x; wid_y = pt.y;
			g_dx_me_cling = wid_x - x_haritsuku;
			g_dy_me_cling = wid_y - y_haritsuku;
			g_is_topmost = ((GetWindowLong(g_wid_to_cling, GWL_EXSTYLE) & WS_EX_TOPMOST) != 0);
			SetWindowPos(g_wid_to_cling, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
			SetWindowPos(g_wid, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
#ifdef STKW_WIN32
			if (g_transparent && g_transparent_cling){
				g_exstyle_cling_prev = 
					SetWindowLong(g_wid_to_cling,GWL_EXSTYLE,
						GetWindowLong(g_wid_to_cling, GWL_EXSTYLE) | WS_EX_LAYERED);
				if (get_layered_window_attributes){
					get_layered_window_attributes(g_wid_to_cling, &g_tl.key, &g_tl.alpha, &g_tl.flag);
				}
				set_transparent(g_wid_to_cling, STKW_TRUE);
			}
#endif
		}
	}else if ((state & STKW_MOUSE_L_RELEASE)){
		g_is_movingwindow = STKW_FALSE;
		toggle_timerstate(STKW_TRUE);
		if (g_wid_to_cling){
			get_pos_size(g_wid_to_cling, &pt, &size);
			rc_h.x = pt.x; rc_h.y = pt.y; rc_h.width = size.width; rc_h.height = size.height;
			get_pos_size(g_wid, &pt, &size);
			rc_me.x = pt.x; rc_me.y = pt.y; rc_me.width = size.width; rc_me.height = size.height;
			if (is_clip(&rc_h, &rc_me) == STKW_FALSE){
				if (!g_is_topmost){
					SetWindowPos(g_wid_to_cling, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
				}
				release_haritsukuwindow();
				g_dx_me_cling = g_dy_me_cling = 0;
			}else{
				get_pos_size(g_wid_to_cling, &pt, &size);
				x_haritsuku = pt.x; y_haritsuku = pt.y;
				get_pos_size(g_wid, &pt, &size);
				wid_x = pt.x; wid_y = pt.y;
				g_dx_me_cling = wid_x - x_haritsuku;
				g_dy_me_cling = wid_y - y_haritsuku;
			}
		}else{
		}
	}
	draw_face(STKW_DRAW(w));
}

void callback_display(StkwDrawWindow *w, int x, int y, int width, int height){
	draw_face(STKW_DRAW(w));
}

void draw_pixmap(StkwPixmap *w){
	StkwDraw *draw;
	int i, j, y;
	double dx, dy, d;
	STKW_DRAW_COLOR c_line[3], c_face[3], c_hilight[3], c_dark[3], c_grad;
	STKW_DRAW_POINT
		p1[4] = {{ 0, 0}, { 3, 3}, {WIN_WIDTH - 4, 3}, {WIN_WIDTH - 1, 0}},
		p2[4] = {{ 0, 0}, { 3, 3}, { 3, WIN_HEIGHT - 4}, {0, WIN_HEIGHT - 1}},
		p3[4] = {{WIN_WIDTH - 1, 0}, {WIN_WIDTH - 4, 3}, {WIN_WIDTH - 4, WIN_HEIGHT - 4}, {WIN_WIDTH - 1, WIN_HEIGHT - 1}},
		p4[4] = {{WIN_WIDTH - 1, WIN_HEIGHT - 1}, {WIN_WIDTH - 4, WIN_HEIGHT - 4}, { 3, WIN_HEIGHT - 4}, { 0, WIN_HEIGHT - 1}};

	draw = STKW_DRAW(w);
	stkw_draw_lock(draw);

	//ŽĤ
	c_line[0].r    = 150; c_line[0].g    = 180; c_line[0].b    = 224;
	c_face[0] = c_line[0];
	c_hilight[0].r = 180; c_hilight[0].g = 220; c_hilight[0].b = 255;
	c_dark[0].r    = 110; c_dark[0].g    = 140; c_dark[0].b    = 127;

	//Ρޥ
	c_line[1].r    = 127; c_line[1].g    = 127; c_line[1].b    = 127;
	c_face[1] = c_line[1];
	c_hilight[1].r = 168; c_hilight[1].g = 168; c_hilight[1].b = 168;
	c_dark[1].r    =  96; c_dark[1].g    =  96; c_dark[1].b    =  96;

	//ư
	c_line[2].r    = 180; c_line[2].g    = 200; c_line[2].b    = 240;
	c_face[2].r    = 140; c_face[2].g    = 170; c_face[2].b    = 220;
	c_hilight[2].r = 200; c_hilight[2].g = 210; c_hilight[2].b = 220;
	c_dark[2].r    = 130; c_dark[2].g    = 140; c_dark[2].b    = 150;

	y = 0;
	for (j = 0; j < 3; j++){
		stkw_draw_set_pen(draw, 1, c_line[j]); 
		stkw_draw_rectangle(draw, 0, y, WIN_WIDTH, WIN_HEIGHT);
		stkw_draw_set_brush(draw, c_hilight[j]);
		stkw_draw_vpolygon(draw, p1, 4);
		stkw_draw_vpolygon(draw, p2, 4);
		stkw_draw_set_brush(draw, c_dark[j]);
		stkw_draw_vpolygon(draw, p3, 4);
		stkw_draw_vpolygon(draw, p4, 4);
		switch(j){
		case 0:		//ŽĤ
			dx = WIN_WIDTH - 7;
			for (i = 3, d = 0.0; i < WIN_WIDTH - 3; i++, d += 1.0 / dx){
				c_grad.r = 60+130*d; c_grad.g = 81+135*d; c_grad.b = 131+75*d;
				stkw_draw_set_pen(draw, 1, c_grad);
				stkw_draw_line(draw, i, y + 3, i, WIN_HEIGHT - 3);
			}
			break;
		case 1:		//Ρޥ
			stkw_draw_set_brush(draw, c_face[j]);
			stkw_draw_rectangle(draw, 3, y + 3, WIN_WIDTH - 6, WIN_HEIGHT - 6);
			break;
		case 2:		//ư
			dy = WIN_HEIGHT - 7;
			for (i = 3, d = 0.0; i < WIN_HEIGHT - 3; i++, d += 1.0 / dy){
				c_grad.r = 60+130*d; c_grad.g = 81+135*d; c_grad.b = 131+75*d;
				stkw_draw_set_pen(draw, 1, c_grad);
				stkw_draw_line(draw, 3, y + i, WIN_WIDTH - 3, y + i);
			}
			break;
		}
		for (i = 0; i < 4; i++){
			p1[i].y += WIN_HEIGHT;	p2[i].y += WIN_HEIGHT;
			p3[i].y += WIN_HEIGHT;	p4[i].y += WIN_HEIGHT;
		}
		y += WIN_HEIGHT;
	}
	stkw_draw_unlock(draw);
}

void get_position(char *arg, int *x, int *y){
	int width, height;
	width = GetSystemMetrics(SM_CXSCREEN);
	height = GetSystemMetrics(SM_CYSCREEN);
	char *p;
	*x = strtol(arg, &p, 10);
	if (p) *y = strtol(p, &p, 10);
	if (*x < 0){
		*x = width - W_MAGNET_WIDTH + *x;
	}
	if (*y < 0){
		*y = height - W_MAGNET_HEIGHT + *y;
	}
}

void w_magnet_init(int argc, char **argv, int *x, int *y){
	int i;
	for (i = 1; i < argc; i++){
		if (strcmp(argv[i], "--position") == 0 && i < argc - 1){
			get_position(argv[i+1], x, y);
			i++;
		}else if(strncmp(argv[i], "-tw", 3) == 0){
			if (strlen(argv[i]) == 3){
				g_transval = 128;
			}else{
				g_transval = atoi(&argv[i][3]);
				if (g_transval > 255) g_transval = 255;
				if (g_transval < 0) g_transval = 0;
			}
			g_transparent = STKW_TRUE;
			g_transparent_cling = STKW_TRUE;
		}else if(strncmp(argv[i], "-t", 2) == 0){
			if (strlen(argv[i]) == 2){
				g_transval = 128;
			}else{
				g_transval = atoi(&argv[i][2]);
				if (g_transval > 255) g_transval = 255;
				if (g_transval < 0) g_transval = 0;
			}
			g_transparent = STKW_TRUE;
			g_transparent_cling = STKW_FALSE;
		}
	}

#ifdef STKW_WIN32
	hLib = LoadLibraryA("user32.dll");
	if (hLib){
		(FARPROC)set_layered_window_attributes = GetProcAddress(hLib, "SetLayeredWindowAttributes");
		(FARPROC)get_layered_window_attributes = GetProcAddress(hLib, "GetLayeredWindowAttributes");
	}
#endif
}


void draw_first(StkwTimer *_this, int id, void *wf){
	draw_face(STKW_DRAW((StkwDrawWindow *)wf));
	stkw_timer_remove(_this, id);
}

int main(int argc, char **argv){
	int x, y;
	Stkw *stkw;
	StkwTop *top;
	StkwDrawWindow *wf;
	StkwTextButton *w_quit;

	timeBeginPeriod(1);
	atexit(onexit);
	stkw = stkw_new(&argc, &argv);
	if (!stkw) return 1;

	g_timer = stkw_get_timer(stkw);
	x = 0; y = 0;
	w_magnet_init(argc, argv, &x, &y);
	g_interval_dblclick = 300;
	g_magnet_x = x; g_magnet_y = y;
	g_stkw_top = top = stkw_top_new(stkw, W_MAGNET_WIDTH, W_MAGNET_HEIGHT, STKW_TOP_POPUP);
	g_wid = stkw_window_win32_get_hwnd(STKW_WINDOW(g_stkw_top));
	SetWindowPos(g_wid, 0, x, y, 0, 0, SWP_NOZORDER | SWP_NOSIZE | SWP_NOACTIVATE);
	stkw_top_set_name(g_stkw_top, WINMAGNET_TITLE);
	g_stkw_draw = wf = stkw_drawwindow_new(stkw, STKW_WINDOW(top), 0, 0, WIN_WIDTH, WIN_HEIGHT);
	w_quit = stkw_textbutton_new(stkw, STKW_WINDOW(top), WIN_WIDTH, 0, WIN_HEIGHT, WIN_HEIGHT);
	stkw_textbutton_set_text(w_quit, "x");
	g_pixmap = stkw_pixmap_new(stkw, WIN_WIDTH, WIN_HEIGHT*3);

	draw_pixmap(g_pixmap);
	w_quit->clicked = callback_quit;
	wf->expose = callback_display;
	STKW_WINDOW(wf)->mousebutton = callback_mousebutton;
	STKW_WINDOW(wf)->mousemove = callback_mousemove;
	STKW_WINDOW(wf)->resize = callback_resize;
	stkw_window_set_callback(STKW_WINDOW(wf),
		STKW_WINDOW_CALLBACK_RESIZE | STKW_WINDOW_CALLBACK_MOUSEMOVE | STKW_WINDOW_CALLBACK_MOUSEBUTTON);

	stkw_window_show(STKW_WINDOW(w_quit));
	stkw_window_show(STKW_WINDOW(wf));
	stkw_window_show(STKW_WINDOW(top));
	toggle_timerstate(STKW_TRUE);
	SetWindowPos(g_wid, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
#ifdef STKW_WIN32
	SetWindowLong(g_wid, GWL_EXSTYLE, GetWindowLong(g_wid, GWL_EXSTYLE) | WS_EX_LAYERED);
	hProgman = FindWindow("Progman", NULL);
#endif
	stkw_timer_add(g_timer, 1, wf, draw_first);
	set_transparent(g_wid, g_transparent);
	stkw_mainloop(stkw);
	timeEndPeriod(1);
	return 0;
}

