/*
 * Copyright (c) 2003,2004,2006 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

extern "C"{
#include "wwindow.h"
#include "topenum.h"
#include "osversion.h"
#include "winwrap.h"
#include "wwin.h"
}
#include <stdio.h>

#define WIN_LONG_DEFAULT 100
#define WIN_SHORT_DEFAULT 20

int win_width = 0;
int win_height = 0;


#define INTERVAL_DBLCLICK	300

int w_magnet_width;
int w_magnet_height;

#define WINMAGNET_TITLE	"Win magnet Ver 1.47"

typedef struct{
	unsigned char r, g, b;
}WMColor;


int g_magnet_x, g_magnet_y;
int g_prev_x, g_prev_y;
int g_dx_cursor_me, g_dy_cursor_me, g_dx_me_cling, g_dy_me_cling, g_dx_cursor_move, g_dy_cursor_move;
WTimer *g_timer;
WTop *g_wtop;
WGraphics *g_pixmap;
WDrawable *g_wdraw;
HWND g_wid, g_wid_to_cling, g_wid_to_move;
BOOL g_is_topmost = FALSE, g_is_movingwindow = FALSE;
unsigned int g_interval_dblclick;
BOOL g_transparent = FALSE, g_transparent_cling = FALSE;
int g_transval = 255;
WMColor	g_color1, g_color2, g_color_base;

bool g_vertical_mode = false;

HMODULE hLib = NULL;
LONG g_exstyle_cling_prev = 0;
BOOL (WINAPI *set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = NULL;
BOOL (WINAPI *get_layered_window_attributes)(HWND, COLORREF *, BYTE *, DWORD *) = NULL;
typedef struct{
	COLORREF key;
	BYTE alpha;
	DWORD flag;
}TRANSPARENT_LAYER;
TRANSPARENT_LAYER g_tl;
HWND hProgman = NULL;

typedef struct {
	int width, height;
}W_MAGNET_SIZE;

typedef struct {
	int x, y, width, height;
}W_MAGNET_RECT;

typedef struct {
	HWND wid;
	int x, y, width, height;
	BOOL is_viewable;
}ENUMWINDOWS_INFO;

ENUMWINDOWS_INFO *g_enumwindows_info = NULL;

int g_numofwindows;

void callback_quit(WTextButton *w, WTextButtonState state){
	wapp_exitloop(wwindow_get_wapp(w));
}

void callback_resize(WWindow *w, int width, int height){
	wwindow_set_size(w, w_magnet_width, w_magnet_height);
}

void set_transparent(HWND hWnd, BOOL transparent){
	if (set_layered_window_attributes){
		if (transparent) set_layered_window_attributes(hWnd, 0, g_transval, LWA_ALPHA);
		else set_layered_window_attributes(hWnd, 0, 255, LWA_ALPHA);
	}
}

void get_enuminfo(void){
	HWND *hwnds;
	int number;
	int i;
	ENUMWINDOWS_INFO *ei;
	topenum_get(&hwnds, &number);
	g_numofwindows = number;
	if (g_enumwindows_info) free(g_enumwindows_info);
	g_enumwindows_info = (ENUMWINDOWS_INFO *)malloc(g_numofwindows * sizeof(ENUMWINDOWS_INFO));
	for (i = 0; i < g_numofwindows; i++){
		ei = &(g_enumwindows_info[i]);
		ei->wid = hwnds[i];
		win_get_pos_size(hwnds[i], &(ei->x), &(ei->y), &(ei->width), &(ei->height));
		ei->is_viewable = IsWindowVisible(hwnds[i]);
	}
	topenum_free(hwnds);
}

void draw_face(WGraphics *w){
	int x, y;
	if (g_is_movingwindow){
		x = g_vertical_mode ? win_width*2 : 0;
		y = g_vertical_mode ? 0 : win_height*2;
	}else if (g_wid_to_cling){
		x = y = 0;
	}else{
		x = g_vertical_mode ? win_width : 0;
		y = g_vertical_mode ? 0 : win_height;
	}
	wgraphics_copyto(g_pixmap, w, x, y, win_width, win_height, 0, 0);
}

void reset_opacity(HWND hWnd){
	if (set_layered_window_attributes){
		set_layered_window_attributes(hWnd, g_tl.key, g_tl.alpha, g_tl.flag);
	}
	SetWindowLong(hWnd, GWL_EXSTYLE, g_exstyle_cling_prev);
}

void release_haritsukuwindow(void){
	if (g_transparent && g_transparent_cling){
		reset_opacity(g_wid_to_cling);
	}
	g_wid_to_cling = NULL;
	ShowWindow(g_wid, SW_SHOW);
	wdrawable_invalidate_whole(g_wdraw);
}


void on_exit(void){
	if (!g_is_topmost && g_wid_to_cling)
		win_set_topmost(g_wid_to_cling, FALSE);
	if (g_wid_to_cling) release_haritsukuwindow();
}

BOOL is_mouse_move(void){
	BOOL ret;
	static int x_prev = -1, y_prev = -1;
	int x, y;
	win_cursor_get_pos(&x, &y);
	if (x_prev == y_prev == -1){
		ret = TRUE;
	}else if(x_prev == x && y_prev == y){
		ret = FALSE;
	}else{
		ret = TRUE;
	}
	x_prev = x; y_prev = y;
	return ret;
}

BOOL is_in_desk(int x, int y){
	int w, h;
	w = GetSystemMetrics(SM_CXSCREEN);
	h = GetSystemMetrics(SM_CYSCREEN);
	if (x >= 0 && y >= 0 && x < w && y < h) return TRUE;
	return FALSE;
}

void process_for_win95(){
	static BOOL is_checked = FALSE, is_win95 = FALSE;
	static int x_prev, y_prev;
	int x, y;
	if (!is_checked){
		if (strcmp(osversion_get(), "95") == 0) is_win95 = TRUE;
		is_checked = TRUE;
		win_get_pos_size(g_wid, &x_prev, &y_prev, NULL, NULL);
	}
	if (!is_win95){
		win_set_top(g_wid);
	}else{
		win_get_pos_size(g_wid, &x, &y, NULL, NULL);
		if (x != x_prev || y != y_prev){
			win_set_top(g_wid);
			x_prev = x;
			y_prev = y;
		}
	}
}

void callback_timer(unsigned int id, void *data){
	int ret;
	int x, y;
	static int prev_x = -1, prev_y = -1;
	if (g_wid_to_cling){
		ret = win_get_pos_size(g_wid_to_cling, &x, &y, NULL, NULL);

		if (ret == 0 || (x == 10000 && y == 10000)){
		/* ץ齪λ˥ɥ(10000,10000)˰ư */
			release_haritsukuwindow();
			return;
		}
		if (prev_x != x || prev_y != y){
			win_move(g_wid, g_dx_me_cling + x, g_dy_me_cling + y);
		}
		if (is_in_desk(g_dx_me_cling + x, g_dy_me_cling + y)){
			g_magnet_x = g_dx_me_cling + x;
			g_magnet_y = g_dy_me_cling + y;
		}
		prev_x = x;
		prev_y = y;
		process_for_win95();
		if (ret == 0){
			if (!g_is_topmost){
				win_set_topmost(g_wid_to_cling, FALSE);
			}
			release_haritsukuwindow();
			return;
		}
	}else{
		win_move(g_wid, g_magnet_x, g_magnet_y);
	}
}

void toggle_timerstate(BOOL state){
	static unsigned int id = 0;
	if (state){
		id = wtimer_regist_callback(g_timer, 20, callback_timer, (void *)1);
	}else if(id != 0){
		wtimer_unregist_callback(g_timer, id);
	}
}

void callback_mousemove(WWindow *w, int mx, int my, MouseMoveState state){
	int x, y;
	if ((state & MOUSEMOVESTATE_L_DOWN)){
		win_cursor_get_pos(&x, &y);
		g_magnet_x = x - g_dx_cursor_me;
		g_magnet_y = y - g_dy_cursor_me;
		win_move(g_wid, g_magnet_x, g_magnet_y);
		if (g_is_movingwindow){
			if (mx != g_prev_x || my != g_prev_y){
				win_move(g_wid_to_move, x - g_dx_cursor_move, y - g_dy_cursor_move);
			}
		}
	}
}

BOOL is_clip(W_MAGNET_RECT *rc1, W_MAGNET_RECT *rc2){
	int xa1, ya1, xa2, ya2;
	int xb1, yb1, xb2, yb2;
	BOOL is_clip_x, is_clip_y;

	is_clip_x = FALSE;
	is_clip_y = FALSE;

	xa1 = rc1 -> x;
	ya1 = rc1 -> y;
	xa2 = xa1 + rc1 -> width;
	ya2 = ya1 + rc1 -> height;
	xb1 = rc2 -> x;
	yb1 = rc2 -> y;
	xb2 = xb1 + rc2 -> width;
	yb2 = yb1 + rc2 -> height;

	if (xa2 < xb2 && xa2 > xb1) is_clip_x = TRUE;
	if (xa1 < xb2 && xa1 > xb1) is_clip_x = TRUE;
	if (xb2 < xa2 && xb2 > xa1) is_clip_x = TRUE;
	if (xb1 < xa2 && xb1 > xa1) is_clip_x = TRUE;
	if (ya2 < yb2 && ya2 > yb1) is_clip_y = TRUE;
	if (ya1 < yb2 && ya1 > yb1) is_clip_y = TRUE;
	if (yb2 < ya2 && yb2 > ya1) is_clip_y = TRUE;
	if (yb1 < ya2 && yb1 > ya1) is_clip_y = TRUE;
	if (is_clip_x & is_clip_y) return TRUE;

	return FALSE;
	
}

HWND get_wid_to_haritsuku(void){
	HWND wid_ret = NULL;
	W_MAGNET_RECT rc1, rc2;
	int i;
	win_get_pos_size(g_wid, &(rc1.x), &(rc1.y), NULL, NULL);
	rc1.width = win_width;
	rc1.height = win_height;
	get_enuminfo();
	for (i = g_numofwindows - 1; i >= 0; i--){
		if (g_enumwindows_info[i].is_viewable == FALSE) continue;
		if (g_enumwindows_info[i].wid == g_wid) continue;
		rc2.x = g_enumwindows_info[i].x;
		rc2.y = g_enumwindows_info[i].y;
		rc2.width = g_enumwindows_info[i].width;
		rc2.height = g_enumwindows_info[i].height;
		if (is_clip(&rc1, &rc2)){
			wid_ret = g_enumwindows_info[i].wid;
		}
	}
	return wid_ret;
}

BOOL check_dblclick(void){
	static BOOL first = TRUE;
	static unsigned int time_prev;
	unsigned int time_now;
	static BOOL ret;
	if (first){
		first = FALSE;
		time_prev = timeGetTime();
		return FALSE;
	}else{
		time_now = timeGetTime();
		ret = FALSE;
		if (time_now - time_prev < g_interval_dblclick){
			ret = TRUE;
		}
		time_prev = time_now;
	}
	return ret;
}

void on_l_push(WWindow *w, int x, int y){
	int wid_x, wid_y, x_move, y_move, cx, cy;
	win_cursor_get_pos(&cx, &cy);

	win_set_top(g_wid);
	win_get_pos_size(g_wid, &wid_x, &wid_y, NULL, NULL);
	g_dx_cursor_me = cx - wid_x;
	g_dy_cursor_me = cy - wid_y;
	if (check_dblclick()){
		g_is_movingwindow = TRUE;
		g_wid_to_move = get_wid_to_haritsuku();
		win_get_pos_size(g_wid_to_move, &x_move, &y_move, NULL, NULL);
		g_dx_cursor_move = cx - x_move;
		g_dy_cursor_move = cy - y_move;
	}
	g_prev_x = x;
	g_prev_y = y;
	toggle_timerstate(FALSE);
}

void on_l_release(WWindow *w, int x, int y){
	int x_haritsuku, y_haritsuku, wid_x, wid_y;
	W_MAGNET_RECT rc_h, rc_me;
	g_is_movingwindow = FALSE;
	toggle_timerstate(TRUE);
	if (g_wid_to_cling){
		win_get_pos_size(g_wid_to_cling, &(rc_h.x), &(rc_h.y), &(rc_h.width), &(rc_h.height));
		win_get_pos_size(g_wid, &(rc_me.x), &(rc_me.y), &(rc_me.width), &(rc_me.height));
		if (is_clip(&rc_h, &rc_me) == FALSE){
			if (!g_is_topmost){
				win_set_topmost(g_wid_to_cling, FALSE);
			}
			release_haritsukuwindow();
			g_dx_me_cling = g_dy_me_cling = 0;
		}else{
			win_get_pos_size(g_wid_to_cling, &x_haritsuku, &y_haritsuku, NULL, NULL);
			win_get_pos_size(g_wid, &wid_x, &wid_y, NULL, NULL);
			g_dx_me_cling = wid_x - x_haritsuku;
			g_dy_me_cling = wid_y - y_haritsuku;
		}
	}else{
	}
}

void on_r_release(WWindow *w, int x, int y){
	HWND wid_prev;
	int x_haritsuku, y_haritsuku, wid_x, wid_y;

	wid_prev = g_wid_to_cling;
	g_wid_to_cling = get_wid_to_haritsuku();
	if (wid_prev == g_wid_to_cling){
		if (!g_is_topmost){
			win_set_topmost(g_wid_to_cling, FALSE);
		}
		release_haritsukuwindow();
	}
	if (g_wid_to_cling == hProgman) g_wid_to_cling = NULL;
	if (g_wid_to_cling){

		win_get_pos_size(g_wid_to_cling, &x_haritsuku, &y_haritsuku,NULL, NULL);
		win_get_pos_size(g_wid, &wid_x, &wid_y, NULL, NULL);
		g_dx_me_cling = wid_x - x_haritsuku;
		g_dy_me_cling = wid_y - y_haritsuku;
		g_is_topmost = ((GetWindowLong(g_wid_to_cling, GWL_EXSTYLE) & WS_EX_TOPMOST) != 0);
		win_set_topmost(g_wid_to_cling, TRUE);
		win_set_top(g_wid);
		if (g_transparent && g_transparent_cling){
			g_exstyle_cling_prev = 
				SetWindowLong(g_wid_to_cling,GWL_EXSTYLE,
					GetWindowLong(g_wid_to_cling, GWL_EXSTYLE) | WS_EX_LAYERED);
			if (get_layered_window_attributes){
				get_layered_window_attributes(g_wid_to_cling, &g_tl.key, &g_tl.alpha, &g_tl.flag);
			}
			set_transparent(g_wid_to_cling, TRUE);
		}
	}
}

void callback_mousebutton(WWindow *w, int x, int y, MouseButtonState state){
	if (state == MOUSEBUTTONSTATE_L_PUSH){
		on_l_push(w, x, y);
	}else if (state == MOUSEBUTTONSTATE_R_RELEASE){
		on_r_release(w, x, y);
	}else if (state == MOUSEBUTTONSTATE_L_RELEASE){
		on_l_release(w, x, y);
	}
	wdrawable_invalidate_whole((WDrawable *)w);
}

void callback_display(WDrawable *w, WGraphics *g, int x, int y, int width, int height){
	draw_face(g);
}

WMColor change_luminance(WMColor src, unsigned char y){
	WMColor dest;
	double cb, cr, r, g, b;
	cb = -0.16874 * (double)src.r - 0.33126 * (double)src.g + 0.5 * (double)src.b;
	cr =0.5 * (double)src.r - 0.41869 * (double)src.g - 0.08131 * (double)src.b;
	
	r = (double)y + 1.402*cr;
	g = (double)y - 0.34414*cb - 0.71414*cr;
	b = (double)y + 1.772 * cb;
	if (r > 255.0) r = 255.0;	if (g > 255.0) g = 255.0;	if (b > 255.0) b = 255.0;
	if (r < 0.0) r = 0.0;	if (g < 0.0) g = 0.0;	if (b < 0.0) b = 0.0;
	dest.r = (unsigned char)r;	dest.g = (unsigned char)g;	dest.b = (unsigned char)b;
	return dest;
}

void draw_pixmap(WGraphics *g){
	int i, j, x, y;
	double dx, dy, d;
	WMColor c_face[3], c_hilight[3], c_dark[3], c_grad, c_tmp;
	WPoint
		p1[4] = {{ 0, 0}, { 3, 3}, {win_width - 4, 3}, {win_width - 1, 0}},
		p2[4] = {{ 0, 0}, { 3, 3}, { 3, win_height - 4}, {0, win_height - 1}},
		p3[4] = {{win_width - 1, 0}, {win_width - 4, 3}, {win_width - 4, win_height - 4}, {win_width - 1, win_height - 1}},
		p4[4] = {{win_width - 1, win_height - 1}, {win_width - 4, win_height - 4}, { 3, win_height - 4}, { 0, win_height - 1}};

	c_tmp.r = (g_color1.r + g_color2.r)/2;
	c_tmp.g = (g_color1.g + g_color2.g)/2;
	c_tmp.b = (g_color1.b + g_color2.b)/2;

	c_dark[0] = c_dark[2] = change_luminance(c_tmp, 64);
	c_hilight[0] = c_hilight[2] = change_luminance(c_tmp, 192);

	c_face[1] = g_color_base;
	c_dark[1] = change_luminance(g_color_base, 96);
	c_hilight[1] = change_luminance(g_color_base, 168);

	x = 0, y = 0;
	for (j = 0; j < 3; j++){
		wgraphics_set_pen(g, 1, c_hilight[j].r, c_hilight[j].g, c_hilight[j].b);
		wgraphics_set_brush(g, c_hilight[j].r, c_hilight[j].g, c_hilight[j].b);
		wgraphics_polygon(g, p1, 4);
		wgraphics_polygon(g, p2, 4);
		wgraphics_set_pen(g, 1, c_dark[j].r, c_dark[j].g, c_dark[j].b);
		wgraphics_set_brush(g, c_dark[j].r, c_dark[j].g, c_dark[j].b);
		wgraphics_polygon(g, p3, 4);
		wgraphics_polygon(g, p4, 4);
		switch(j){
		case 0:		//ŽĤ
			dx = win_width - 7;
			for (i = 3, d = 0.0; i < win_width - 3; i++, d += 1.0 / dx){
				c_grad.r = g_color1.r + (unsigned char)((double)(g_color2.r-g_color1.r)*d);
				c_grad.g = g_color1.g + (unsigned char)((double)(g_color2.g-g_color1.g)*d);
				c_grad.b = g_color1.b + (unsigned char)((double)(g_color2.b-g_color1.b)*d);
				wgraphics_set_pen(g, 1, c_grad.r, c_grad.g, c_grad.b);
				wgraphics_line(g, x + i, y + 2, x + i, y + win_height - 3);
			}
			break;
		case 1:		//Ρޥ
			wgraphics_set_pen(g, 1, c_face[j].r, c_face[j].g, c_face[j].b);
			wgraphics_set_brush(g, c_face[j].r, c_face[j].g, c_face[j].b);
			wgraphics_rectangle(g, x + 2, y + 2, win_width - 5, win_height - 5);
			break;
		case 2:		//ư
			dy = win_height - 6;
			for (i = 2, d = 0.0; i < win_height - 3; i++, d += 1.0 / dy){
				c_grad.r = g_color1.r + (unsigned char)((double)(g_color2.r-g_color1.r)*d);
				c_grad.g = g_color1.g + (unsigned char)((double)(g_color2.g-g_color1.g)*d);
				c_grad.b = g_color1.b + (unsigned char)((double)(g_color2.b-g_color1.b)*d);
				wgraphics_set_pen(g, 1, c_grad.r, c_grad.g, c_grad.b);
				wgraphics_line(g, x + 2, y + i, x + win_width - 3, y + i);
			}
			break;
		}
		if (g_vertical_mode){
			for (i = 0; i < 4; i++){
				p1[i].x += win_width;	p2[i].x += win_width;
				p3[i].x += win_width;	p4[i].x += win_width;
			}
			x += win_width;
		}else{
			for (i = 0; i < 4; i++){
				p1[i].y += win_height;	p2[i].y += win_height;
				p3[i].y += win_height;	p4[i].y += win_height;
			}
			y += win_height;
		}
	}
}

void get_position(char *arg, int *x, int *y){
	int width, height;
	char *p;
	width = GetSystemMetrics(SM_CXSCREEN);
	height = GetSystemMetrics(SM_CYSCREEN);
	*x = strtol(arg, &p, 10);
	if (p) *y = strtol(p, &p, 10);
	if (*x < 0){
		*x = width - w_magnet_width + *x;
	}
	if (*y < 0){
		*y = height - w_magnet_height + *y;
	}
}

void get_size(char *arg, int &w, int &h){
	char *p;
	w = strtol(arg, &p, 10);
	if (p) p++, h = strtol(p, &p, 10);
	printf("%d %d\n", w, h);
}

char *get_char2(char *s){
	static char c[3];
	c[0] = s[0], c[1] = s[1], c[2] = '\0';
	return c;
}

#define SET_RGB(c, vr, vg, vb) (c).r = (vr), (c).g = (vg), (c).b = (vb)

void w_magnet_init(int argc, char **argv, int *x, int *y){
	int i;
/*
	SET_RGB(g_color1, 60, 81, 131);
	SET_RGB(g_color2, 190, 216, 206);
*/
	SET_RGB(g_color1, 64, 64, 80);
	SET_RGB(g_color2, 240, 240, 255);
	SET_RGB(g_color_base, 127, 127, 127);
	for (i = 1; i < argc; i++){
		if (strcmp(argv[i], "--position") == 0 && i < argc - 1){
			get_position(argv[i+1], x, y);
			i++;
		}else if (strcmp(argv[i], "--size") == 0 && i < argc - 1){
			get_size(argv[i+1], win_width, win_height);
			i++;
		}else if(strncmp(argv[i], "-vt", 3) == 0){
			g_vertical_mode = true;
		}else if(strncmp(argv[i], "-tw", 3) == 0){
			if (strlen(argv[i]) == 3){
				g_transval = 128;
			}else{
				g_transval = atoi(&argv[i][3]);
				if (g_transval > 255) g_transval = 255;
				if (g_transval < 0) g_transval = 0;
			}
			g_transparent = TRUE;
			g_transparent_cling = TRUE;
		}else if(strncmp(argv[i], "-t", 2) == 0){
			if (strlen(argv[i]) == 2){
				g_transval = 128;
			}else{
				g_transval = atoi(&argv[i][2]);
				if (g_transval > 255) g_transval = 255;
				if (g_transval < 0) g_transval = 0;
			}
			g_transparent = TRUE;
			g_transparent_cling = FALSE;
		}else if(strncmp(argv[i], "-g", 2) == 0){
			if(strlen(argv[i]) == 8){ /* Ǥʤ */
				g_color1.r = strtoul(get_char2(&(argv[i][2])), NULL, 16);
				g_color1.g = strtoul(get_char2(&(argv[i][4])), NULL, 16);
				g_color1.b = strtoul(get_char2(&(argv[i][6])), NULL, 16);
				g_color2 = g_color1;
			}else if(strlen(argv[i]) == 14){ /* Ǥ */
				g_color1.r = strtoul(get_char2(&(argv[i][ 2])), NULL, 16);
				g_color1.g = strtoul(get_char2(&(argv[i][ 4])), NULL, 16);
				g_color1.b = strtoul(get_char2(&(argv[i][ 6])), NULL, 16);
				g_color2.r = strtoul(get_char2(&(argv[i][ 8])), NULL, 16);
				g_color2.g = strtoul(get_char2(&(argv[i][10])), NULL, 16);
				g_color2.b = strtoul(get_char2(&(argv[i][12])), NULL, 16);
			}
		}else if(strncmp(argv[i], "-b", 2) == 0){
			if(strlen(argv[i]) == 8){
				g_color_base.r = strtoul(get_char2(&(argv[i][2])), NULL, 16);
				g_color_base.g = strtoul(get_char2(&(argv[i][4])), NULL, 16);
				g_color_base.b = strtoul(get_char2(&(argv[i][6])), NULL, 16);
			}
		}
	}

	if (win_width == 0) win_width = g_vertical_mode ? WIN_SHORT_DEFAULT : WIN_LONG_DEFAULT;
	if (win_height == 0) win_height = g_vertical_mode ? WIN_LONG_DEFAULT : WIN_SHORT_DEFAULT;
	if (g_vertical_mode){
		w_magnet_width = win_width;
		w_magnet_height = win_width + win_height;
	}else{
		w_magnet_width = win_width + win_height;
		w_magnet_height = win_height;
	}

	hLib = LoadLibraryA("user32.dll");
	if (hLib){
		(FARPROC)set_layered_window_attributes = GetProcAddress(hLib, "SetLayeredWindowAttributes");
		(FARPROC)get_layered_window_attributes = GetProcAddress(hLib, "GetLayeredWindowAttributes");
	}
}


void draw_first(unsigned int id, void *wf){
	wdrawable_invalidate_whole((WWindow *)wf);
	wtimer_unregist_callback(g_timer, id);
}

int main(int argc, char **argv){
	int x, y;
	WApp *wapp;
	WTop *top;
	WWindow *wf;
	WTextButton *w_quit;

	timeBeginPeriod(1);
	atexit(on_exit);
	wapp = wapp_new();
	if (!wapp) return 1;

	g_timer = wapp_get_timer(wapp);
	x = 0; y = 0;
	w_magnet_init(argc, argv, &x, &y);
	g_interval_dblclick = INTERVAL_DBLCLICK;
	g_magnet_x = x; g_magnet_y = y;
	g_wtop = top = wtop_new(wapp, x, y, w_magnet_width, w_magnet_height, WTOPMODE_POPUP);
	g_wid = g_wtop->hWnd;
	wtop_set_name(g_wtop, WINMAGNET_TITLE);
	if (g_vertical_mode){
		g_wdraw = wf = wdrawable_new(wapp, top, 0, win_width, win_width, win_height);
		w_quit = wtextbutton_new(wapp, top, 0, 0, win_width, win_width, "x", WTEXTBUTTON_MODE_NORMAL);
		g_pixmap = wgraphics_new(win_width*3, win_height);
	}else{
		g_wdraw = wf = wdrawable_new(wapp, top, 0, 0, win_width, win_height);
		w_quit = wtextbutton_new(wapp, top, win_width, 0, win_height, win_height, "x", WTEXTBUTTON_MODE_NORMAL);
		g_pixmap = wgraphics_new(win_width, win_height*3);
	}

	draw_pixmap(g_pixmap);
	WTEXTBUTTON_CLICKED(w_quit) = callback_quit;
	WDRAWABLE_EXPOSE(wf) = callback_display;
	wf->mousebutton = callback_mousebutton;
	wf->mousemove = callback_mousemove;
	wf->resize = callback_resize;
	wwindow_validate_callback(wf,(ValidateCallback)(
		VALIDATECALLBACK_RESIZE | VALIDATECALLBACK_MOUSEMOVE | VALIDATECALLBACK_MOUSEBUTTON));

	wwindow_show(w_quit);
	wwindow_show(wf);
	wwindow_show(top);
	toggle_timerstate(TRUE);
	win_set_topmost(g_wid, TRUE);
	SetWindowLong(g_wid, GWL_EXSTYLE, GetWindowLong(g_wid, GWL_EXSTYLE) | WS_EX_LAYERED);
	hProgman = FindWindow("Progman", NULL);
	wtimer_regist_callback(g_timer, 1, draw_first, wf);
	set_transparent(g_wid, g_transparent);
	wapp_run(wapp);
	timeEndPeriod(1);
	return 0;
}

