/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wapp.h"

WApp *wapp_new(void){
	WApp *_this;
	InitCommonControls();
	_this = (WApp *)malloc(sizeof(WApp));
	if (!_this) goto error_wapp_new;

	_this->wt = wtimer_new();
	if (!_this->wt) goto error_wapp_new;
	_this->num_windows = 0;

	return _this;
error_wapp_new:
	wapp_delete(_this);
	return NULL;
}

void wapp_delete(WApp *_this){
	if (!_this) return;
	if (_this->wt) wtimer_delete(_this->wt);
	free(_this);
}

void wapp_run(WApp *_this){
	MSG msg;
	for(;;){
		if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)){
			if (!GetMessage(&msg, NULL, 0, 0)) break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		wtimer_do_once(_this->wt);
		Sleep (1);
	}

}

void wapp_exitloop(WApp *_this){
	PostQuitMessage(0);
}

WTimer *wapp_get_timer(WApp *_this){
	if (!_this) return NULL;
	return _this->wt;
}

void wapp_add_window(WApp *_this, struct tagWWindow *w){
	_this->num_windows++;
}

void wapp_remove_window(WApp *_this, struct tagWWindow *w){
	_this->num_windows--;
}
