/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wdrawable.h"

static int wdrawable_wndproc(WWindow *_this, UINT uMsg, WPARAM wParam, LPARAM lParam){
	WGraphics g;
	PAINTSTRUCT ps;
	RECT rc;
	switch(uMsg){
		case WM_PAINT:
			if (WDRAWABLE_EXPOSE(_this)){
				g.width = g.height = g.isMemory = 0;
				g.hDC = BeginPaint(_this->hWnd, &ps);
				g.width_pen = 0;
				g.color_brush = g.color_pen = 0;
				rc = ps.rcPaint;
				WDRAWABLE_EXPOSE(_this)(_this, &g, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top);
				EndPaint(_this->hWnd, &ps);
			}
			break;
	}
	return 1;
}


WDrawable *wdrawable_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height){
	WDrawable *_this;
	_this = wwindow_new(wapp);
	if (!_this) goto error_wdrawable_new;
	WDRAWABLE_EXPOSE(wapp) = NULL;
	_this->hWnd = CreateWindowEx(WS_EX_LEFT, WWINDOW_WNDCLASS, "", WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
		x, y, width, height, parent->hWnd, NULL, GetModuleHandle(NULL), NULL);
	if (!_this->hWnd) goto error_wdrawable_new;
	wwindow_validate_callback(_this, 0);
	_this->chain_wndproc = wdrawable_wndproc;
	return _this;
error_wdrawable_new:
	wwindow_delete(_this);
	return NULL;
}

void wdrawable_invalidate(WDrawable *_this, int x, int y, int width, int height){
	RECT rc;
	rc.left = x; rc.top = y;
	rc.right = x + width; rc.bottom = y + height;
	InvalidateRect(_this->hWnd, &rc, TRUE);
}

void wdrawable_invalidate_whole(WDrawable *_this){
	InvalidateRect(_this->hWnd, NULL, TRUE);
}
