/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wgraphicbutton.h"

#define WG_STATE_OFF 0
#define WG_STATE_ON 1
#define WG_STATE_PUSHING 2

static void draw_button(WWindow *_this, HDC hDC){
	int x, y, sx, sy, sw, sh;
	WGraphics gd, *gs;
	RECT rc;
	UINT dfcs;
	dfcs = DFCS_BUTTONPUSH;

	gd.width = gd.height = gd.isMemory = 0;
	gd.hDC = hDC;
	gd.width_pen = 0;
	gd.color_brush = gd.color_pen = 0;
	x = y = 0;

	if (WGRAPHICBUTTON_CURRENTSTATE(_this) != WG_STATE_OFF){
		dfcs |= DFCS_PUSHED;
	}
	GetClientRect(_this->hWnd, &rc);
	DrawFrameControl(hDC, &rc, DFC_BUTTON, dfcs);
	switch(WGRAPHICBUTTON_CURRENTSTATE(_this)){
		case WG_STATE_OFF:
			gs = WGRAPHICBUTTON_GRAPHIC_OFF(_this);
			sx = WGRAPHICBUTTON_X_OFF(_this);
			sy = WGRAPHICBUTTON_Y_OFF(_this);
			sw = WGRAPHICBUTTON_WIDTH_OFF(_this);
			sh = WGRAPHICBUTTON_HEIGHT_OFF(_this);
			break;
		case WG_STATE_ON:
			gs = WGRAPHICBUTTON_GRAPHIC_ON(_this);
			sx = WGRAPHICBUTTON_X_ON(_this);
			sy = WGRAPHICBUTTON_Y_ON(_this);
			sw = WGRAPHICBUTTON_WIDTH_ON(_this);
			sh = WGRAPHICBUTTON_HEIGHT_ON(_this);
			break;
		case WG_STATE_PUSHING:
			x = y = 1;
			gs = WGRAPHICBUTTON_GRAPHIC_PUSHING(_this);
			sx = WGRAPHICBUTTON_X_PUSHING(_this);
			sy = WGRAPHICBUTTON_Y_PUSHING(_this);
			sw = WGRAPHICBUTTON_WIDTH_PUSHING(_this);
			sh = WGRAPHICBUTTON_HEIGHT_PUSHING(_this);
			break;
	}
	if (gs){
		x += (rc.right - sw) / 2;
		y += (rc.bottom - sh) / 2;
		wgraphics_copyto(gs, &gd, sx, sy, sw, sh, x, y);
	}
}

static int check_mouse_in(WWindow *_this){
	RECT rc;
	POINT pt;
	GetCursorPos(&pt);
	ScreenToClient(_this->hWnd, &pt);
	GetClientRect(_this->hWnd, &rc);
	if (pt.x < 0 || pt.y < 0 || pt.x > rc.right || pt.y > rc.bottom){
		return 0;
	}else{
		return 1;
	}
}

static void change_mouse_state(WWindow *_this){
	if (check_mouse_in(_this)){
		WGRAPHICBUTTON_CURRENTSTATE(_this) = WG_STATE_PUSHING;
	}else{
		if (WGRAPHICBUTTON_STATE(_this) == WGRAPHICBUTTON_STATE_ON){
			WGRAPHICBUTTON_CURRENTSTATE(_this) = WG_STATE_ON;
		}else{
			WGRAPHICBUTTON_CURRENTSTATE(_this) = WG_STATE_OFF;
		}
	}
}

static int wgraphicbutton_wndproc(WWindow *_this, UINT uMsg, WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
	HDC hDC;
    switch(uMsg){
		case WM_PAINT:
			hDC = BeginPaint(_this->hWnd, &ps);
			draw_button(_this, hDC);
			EndPaint(_this->hWnd, &ps);
			break;
		case WM_LBUTTONDBLCLK:
		case WM_LBUTTONDOWN:
			SetCapture(_this->hWnd);
			WGRAPHICBUTTON_IS_CAPTURE(_this) = 1;
			change_mouse_state(_this);
			hDC = GetDC(_this->hWnd);
			draw_button(_this, hDC);
			ReleaseDC(_this->hWnd, hDC);
			break;

		case WM_LBUTTONUP:
			ReleaseCapture();
			if (!WGRAPHICBUTTON_IS_CAPTURE(_this)) break;
			WGRAPHICBUTTON_IS_CAPTURE(_this) = 0;
			if (!check_mouse_in(_this)) break;

			if (WGRAPHICBUTTON_MODE(_this) == WGRAPHICBUTTON_MODE_NORMAL){
				WGRAPHICBUTTON_STATE(_this) = WGRAPHICBUTTON_STATE_OFF;
			}else{
				WGRAPHICBUTTON_STATE(_this) = (WGRAPHICBUTTON_STATE(_this) == WGRAPHICBUTTON_STATE_ON) ?
					WGRAPHICBUTTON_STATE_OFF : WGRAPHICBUTTON_STATE_ON;
			}
			WGRAPHICBUTTON_CURRENTSTATE(_this) = (WGRAPHICBUTTON_STATE(_this) == WGRAPHICBUTTON_STATE_ON) ?
					WG_STATE_ON : WG_STATE_OFF;
			hDC = GetDC(_this->hWnd);
			draw_button(_this, hDC);
			ReleaseDC(_this->hWnd, hDC);
			if (WGRAPHICBUTTON_CLICKED(_this)) WGRAPHICBUTTON_CLICKED(_this)(_this, WGRAPHICBUTTON_STATE(_this));

			break;
		case WM_MOUSEMOVE:
			if (WGRAPHICBUTTON_IS_CAPTURE(_this)){
				change_mouse_state(_this);
				hDC = GetDC(_this->hWnd);
				draw_button(_this, hDC);
				ReleaseDC(_this->hWnd, hDC);
			}
			break;
	}
	return 1;
}

void wgraphicbutton_set_graphics(WGraphicButton *_this, WGraphics *g, WGraphicButtonSetGraphicState state, int x, int y, int width, int height){
	switch(state){
		case WGRAPHICBUTTON_SETGRAPHICSTATE_OFF:
			WGRAPHICBUTTON_GRAPHIC_OFF(_this) = g;
			WGRAPHICBUTTON_X_OFF(_this) = x;
			WGRAPHICBUTTON_Y_OFF(_this) = y;
			WGRAPHICBUTTON_WIDTH_OFF(_this) = width;
			WGRAPHICBUTTON_HEIGHT_OFF(_this) = height;
			break;
		case WGRAPHICBUTTON_SETGRAPHICSTATE_ON:
			WGRAPHICBUTTON_GRAPHIC_ON(_this) = g;
			WGRAPHICBUTTON_X_ON(_this) = x;
			WGRAPHICBUTTON_Y_ON(_this) = y;
			WGRAPHICBUTTON_WIDTH_ON(_this) = width;
			WGRAPHICBUTTON_HEIGHT_ON(_this) = height;
			break;
		case WGRAPHICBUTTON_SETGRAPHICSTATE_PUSHING:
			WGRAPHICBUTTON_GRAPHIC_PUSHING(_this) = g;
			WGRAPHICBUTTON_X_PUSHING(_this) = x;
			WGRAPHICBUTTON_Y_PUSHING(_this) = y;
			WGRAPHICBUTTON_WIDTH_PUSHING(_this) = width;
			WGRAPHICBUTTON_HEIGHT_PUSHING(_this) = height;
			break;
	}
}

void wgraphicbutton_invalidate(WGraphicButton *_this){
	InvalidateRect(_this->hWnd, NULL, TRUE);
}

WGraphicButton *wgraphicbutton_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height, WGraphicButtonMode mode){
	WGraphicButton *_this;
	_this = wwindow_new(wapp);
	if (!_this) goto error_wgraphicbutton_new;
	WGRAPHICBUTTON_CLICKED(_this) = NULL;
	WGRAPHICBUTTON_IS_CAPTURE(_this) = 0;
	WGRAPHICBUTTON_STATE(_this) = WGRAPHICBUTTON_STATE_OFF;
	WGRAPHICBUTTON_MODE(_this) = mode;
	WGRAPHICBUTTON_GRAPHIC_OFF(_this) = NULL;
	WGRAPHICBUTTON_GRAPHIC_ON(_this) = NULL;
	WGRAPHICBUTTON_GRAPHIC_PUSHING(_this) = NULL;
	WGRAPHICBUTTON_CURRENTSTATE(_this) = WG_STATE_OFF;
	_this->hWnd = CreateWindowEx(WS_EX_LEFT, WWINDOW_WNDCLASS, "", WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
		x, y, width, height, parent->hWnd, NULL, GetModuleHandle(NULL), NULL);
	if (!_this->hWnd) goto error_wgraphicbutton_new;
	wwindow_validate_callback(_this, 0);
	_this->chain_wndproc = wgraphicbutton_wndproc;
	wwindow_validate_callback(_this, 0);
	return _this;

error_wgraphicbutton_new:
	wwindow_delete(_this);
	return NULL;
}

