/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef H_WGRAPHICBUTTON_H_
#define H_WGRAPHICBUTTON_H_

#include "wwindow.h"
#include "wgraphics.h"

#define WGraphicButton WWindow

typedef enum{
	WGRAPHICBUTTON_MODE_NORMAL, WGRAPHICBUTTON_MODE_TOGGLE,
}WGraphicButtonMode;

typedef enum{
	WGRAPHICBUTTON_STATE_OFF, WGRAPHICBUTTON_STATE_ON,
}WGraphicButtonState;

typedef enum{
	WGRAPHICBUTTON_SETGRAPHICSTATE_OFF, WGRAPHICBUTTON_SETGRAPHICSTATE_ON,
	WGRAPHICBUTTON_SETGRAPHICSTATE_PUSHING,
}WGraphicButtonSetGraphicState;

WGraphicButton *wgraphicbutton_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height, WGraphicButtonMode mode);

/**
 * g mۂĂ摜f[^ x, y, width, height Ŏw肳ꂽ̈̓e{^ state ̂Ƃɕ`悷
 */
void wgraphicbutton_set_graphics(WGraphicButton *, WGraphics *g, WGraphicButtonSetGraphicState state, int x, int y, int width, int height);
void wgraphicbutton_invalidate(WGraphicButton *);

#define WGRAPHICBUTTON_CLICKED(X) ((void (*)(WGraphicButton *, WGraphicButtonState s))(((WWindow *)X)->childdata[0].vp[0]))
#define WGRAPHICBUTTON_IS_CAPTURE(X) (((WWindow *)X)->childdata[1].i[0])
#define WGRAPHICBUTTON_CURRENTSTATE(X) (((WWindow *)X)->childdata[1].i[1])
#define WGRAPHICBUTTON_STATE(X) (((WWindow *)X)->childdata[2].i[0])
#define WGRAPHICBUTTON_MODE(X) (((WWindow *)X)->childdata[2].i[1])
#define WGRAPHICBUTTON_GRAPHIC_OFF(X) ((WGraphics *)(((WWindow *)X)->childdata[3].vp[0]))
#define WGRAPHICBUTTON_GRAPHIC_ON(X) ((WGraphics *)(((WWindow *)X)->childdata[3].vp[1]))
#define WGRAPHICBUTTON_GRAPHIC_PUSHING(X) ((WGraphics *)(((WWindow *)X)->childdata[0].vp[1]))
#define WGRAPHICBUTTON_X_ON(X) (((WWindow *)X)->childdata[4].i[0])
#define WGRAPHICBUTTON_X_OFF(X) (((WWindow *)X)->childdata[4].i[1])
#define WGRAPHICBUTTON_X_PUSHING(X) (((WWindow *)X)->childdata[5].i[0])
#define WGRAPHICBUTTON_Y_ON(X) (((WWindow *)X)->childdata[5].i[1])
#define WGRAPHICBUTTON_Y_OFF(X) (((WWindow *)X)->childdata[6].i[0])
#define WGRAPHICBUTTON_Y_PUSHING(X) (((WWindow *)X)->childdata[6].i[1])
#define WGRAPHICBUTTON_WIDTH_ON(X) (((WWindow *)X)->childdata[7].i[0])
#define WGRAPHICBUTTON_WIDTH_OFF(X) (((WWindow *)X)->childdata[7].i[1])
#define WGRAPHICBUTTON_WIDTH_PUSHING(X) (((WWindow *)X)->childdata[8].i[0])
#define WGRAPHICBUTTON_HEIGHT_ON(X) (((WWindow *)X)->childdata[8].i[1])
#define WGRAPHICBUTTON_HEIGHT_OFF(X) (((WWindow *)X)->childdata[9].i[0])
#define WGRAPHICBUTTON_HEIGHT_PUSHING(X) (((WWindow *)X)->childdata[9].i[1])

#endif /* H_WGRAPHICBUTTON_H_ */
