#include "wgraphics.h"

WGraphics *wgraphics_new(int width, int height){
	HWND hWnd;
	HDC hDC_tmp;
	HBITMAP hBitmap_prev;
	BITMAPINFO bi;
	WGraphics *_this;
	_this = (WGraphics *)malloc(sizeof(WGraphics));
	if (!_this) goto error_wgraphics_new;

	_this->hDC = CreateCompatibleDC(NULL);
	if (!_this->hDC) goto error_wgraphics_new;
	hWnd = GetDesktopWindow();
	hDC_tmp = GetDC(hWnd);
/*
	_this->hBmp = CreateCompatibleBitmap(hDC_tmp, width, height);
*/

	ZeroMemory(&bi, sizeof(bi));
	bi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bi.bmiHeader.biBitCount = 24;
	bi.bmiHeader.biPlanes = 1;
	bi.bmiHeader.biWidth = width;
	bi.bmiHeader.biHeight = height;
	_this->hBmp = CreateDIBSection(NULL, &bi, DIB_RGB_COLORS, (void **)(&_this->img), NULL, 0);

	ReleaseDC(hWnd, hDC_tmp);
	hBitmap_prev = (HBITMAP)SelectObject(_this->hDC, _this->hBmp);
	DeleteObject(hBitmap_prev);

	_this->isMemory = 1;
	_this->color_pen = _this->color_brush = RGB(0,0,0);
	_this->width_pen = 0;

	return _this;
error_wgraphics_new:
	wgraphics_delete(_this);
	return NULL;
}

void wgraphics_delete(WGraphics *_this){
	if (_this){
		if (!_this->isMemory) return;
		if (_this->hBmp) DeleteObject(_this->hBmp);
		if (_this->hDC) DeleteDC(_this->hDC);
		free(_this);
	}
}

void wgraphics_set_pen(WGraphics *_this, int width_pen, unsigned char r, unsigned char g, unsigned char b){
	_this->color_pen = RGB(r,g,b);
	_this->width_pen = 0;
}

void wgraphics_set_brush(WGraphics *_this, unsigned char r, unsigned char g, unsigned char b){
	_this->color_brush = RGB(r,g,b);
}


void wgraphics_line(WGraphics *_this, int x1, int y1, int x2, int y2){
	wgraphics_move_point(_this, x1, y1);
	wgraphics_lineto(_this, x2, y2);
}

void wgraphics_lineto(WGraphics *_this, int x, int y){
	HPEN hPen, hPen_prev;
	hPen = CreatePen(PS_SOLID, _this->width_pen, _this->color_pen);
	hPen_prev = (HPEN)SelectObject(_this->hDC, hPen);
	LineTo(_this->hDC, x, y);
	SelectObject(_this->hDC, hPen_prev);
	DeleteObject(hPen);
}

void wgraphics_move_point(WGraphics *_this, int x, int y){
	MoveToEx(_this->hDC, x, y, NULL);
}

void wgraphics_rectangle(WGraphics *_this, int x, int y, int width, int height){
	HPEN hPen, hPen_prev;
	HBRUSH hBrush, hBrush_prev;

	hPen = CreatePen(PS_SOLID, _this->width_pen, _this->color_pen);
	hBrush = CreateSolidBrush(_this->color_brush);
	hPen_prev = (HPEN)SelectObject(_this->hDC, hPen);
	hBrush_prev = (HBRUSH)SelectObject(_this->hDC, hBrush);

	Rectangle(_this->hDC, x, y, x+width, y+height);

	SelectObject(_this->hDC, hBrush_prev);
	SelectObject(_this->hDC, hPen_prev);
	DeleteObject(hBrush);
	DeleteObject(hPen);
}

void wgraphics_polygon(WGraphics *_this, WPoint *pt, int count){
	int i;
	POINT *wpt;

	HPEN hPen, hPen_prev;
	HBRUSH hBrush, hBrush_prev;

	if (count < 0) return;
	wpt = (POINT *)malloc(count * sizeof(POINT));
	if (!wpt) return;

	hPen = CreatePen(PS_SOLID, _this->width_pen, _this->color_pen);
	hBrush = CreateSolidBrush(_this->color_brush);
	hPen_prev = (HPEN)SelectObject(_this->hDC, hPen);
	hBrush_prev = (HBRUSH)SelectObject(_this->hDC, hBrush);

	for (i = 0; i < count; i++){
		wpt[i].x = pt[i].x; wpt[i].y = pt[i].y;
	}
	Polygon(_this->hDC, wpt, count);

	SelectObject(_this->hDC, hBrush_prev);
	SelectObject(_this->hDC, hPen_prev);
	DeleteObject(hBrush);
	DeleteObject(hPen);
}

void wgraphics_copyto(WGraphics *_this, WGraphics *dest, int x1, int y1, int width, int height, int x2, int y2){
	if (!_this || !dest) return;
	if (dest->hDC && _this->hDC){
		BitBlt(dest->hDC, x2, y2, width, height, _this->hDC, x1, y1, SRCCOPY);
	}
}
