#include "win_depend.h"

char *win_get_version(void){
	char *version;
	OSVERSIONINFO vi;
	vi.dwOSVersionInfoSize = sizeof(vi);
	
	version = "";
	if (!GetVersionEx(&vi)){
		version = "";
	}else{
		if (vi.dwMajorVersion == 4){
			switch(vi.dwMinorVersion){
				case 0:
					if (vi.dwPlatformId == 1){
						version = "Windows95";		//Windows95
					}else if (vi.dwPlatformId == 2){
						version = "WindowsNT4.0";	//NT4
					}
					break;
				case 10:
					version = "Windows98";	//Windows98
					break;
				case 90:
					version = "WindowsME";	//WindowsME
					break;
				default:
					version = "";
					break;
			}
		}else if (vi.dwMajorVersion == 3){
			version = "WindowsNT3.5";	//NT35
		}else if (vi.dwMajorVersion == 5){
			switch(vi.dwMinorVersion){
				case 0:
					version = "Windows2000";	//Windows2000
					break;
				case 1:
					version = "WindowsXP";	//WindowsXP
					break;
				default:
					version = "";
					break;
			}
		}
	}
	return version;
}

int win_get_pos_size(HWND hWnd, POINT *pt, WIN_SIZE *size){
	RECT rc;
	if (GetWindowRect(hWnd, &rc) == 0) return 0;
	if (pt){
		pt->x = rc.left; pt->y = rc.top;
	}
	if (size){
		size->width = rc.right - rc.left;
		size->height = rc.bottom - rc.top;
	}
	return 1;
}

int win_get_pos(HWND hWnd, int *x, int *y){
	RECT rc;
	if (GetWindowRect(hWnd, &rc) == 0) return 0;
	if (x) *x = rc.left;
	if (y) *y = rc.top;
	return 1;
}

int win_get_size(HWND hWnd, int *width, int *height){
	RECT rc;
	if (GetWindowRect(hWnd, &rc) == 0) return 0;
	if (width) *width = rc.right - rc.left;
	if (height) *height = rc.bottom - rc.top;
	return 1;
}

int win_get_pos_x(HWND hWnd){
	int x;
	if (!win_get_pos(hWnd, &x, NULL)) return 0;
	return x;
}

int win_get_pos_y(HWND hWnd){
	int y;
	if (!win_get_pos(hWnd, NULL, &y)) return 0;
	return y;
}

int win_get_size_width(HWND hWnd){
	RECT rc;
	if (GetWindowRect(hWnd, &rc) == 0) return 0;
	return rc.right - rc.left;
}

int win_get_size_height(HWND hWnd){
	RECT rc;
	if (GetWindowRect(hWnd, &rc) == 0) return 0;
	return rc.bottom - rc.top;
}

void win_raise(HWND hWnd){
	SetWindowPos(hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
}

void win_topmost(HWND hWnd){
	SetWindowPos(hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
}

void win_notopmost(HWND hWnd){
	SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
}

void win_moveto(HWND hWnd, int x, int y){
	SetWindowPos(hWnd, 0, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
}

typedef struct{
	HMODULE hLib;
	BOOL (*setlayeredwindowattributes)(HWND, COLORREF, BYTE, DWORD);
	BOOL (*getlayeredwindowattributes)(HWND, COLORREF *, BYTE *, DWORD *);
}_WIN_OPACITY;

static void _win_get_funcs_opacity(_WIN_OPACITY *object_ret){
	_WIN_OPACITY _this = {NULL, NULL, NULL}
	if (!_this.hLib){
		_this.hLib = LoadLibrary("user32.dll");
		if (_this.hLib){
		(FARPROC)_this.setlayeredwindowattributes = GetProcAddress(_this.hLib, "SetLayeredWindowAttributes");
		(FARPROC)_this.getlayeredwindowattributes = GetProcAddress(_this.hLib, "GetLayeredWindowAttributes");
	}
	object_ret = &_this;
}

void win_set_opacity(HWND hWnd, int opacity){
	_WIN_OPACITY *funcs;
	COLORREF key = 0;
	DWORD flag = 0;
	BYTE opacity_prev = 0;
	_win_get_func_opacity(funcs);
	if (!funcs->getlayeredwindowattributes || !funcs->setlayeredwindowattributes ) return;

	SetWindowLong(hWnd, GWL_EXSTYLE, GetWindowLong(hWnd, GWL_EXSTYLE) | WS_EX_LAYERED);
	funcs->getlayeredwindowattributes(hWnd, &key, &opacity_prev, &flag);
	funcs->setlayeredwindowattributes(hWnd, key, opacity, flag);
	SetWindowLong(hWnd, GWL_EXSTYLE, GetWindowLong(hWnd, GWL_EXSTYLE) & !WS_EX_LAYERED);
}

int win_get_opacity(HWND hWnd){
	_WIN_OPACITY *funcs;
	COLORREF key = 0;
	DWORD flag = 0;
	BYTE opacity = 0;
	_win_get_func_opacity(funcs);
	if (!funcs->getlayeredwindowattributes || !funcs->setlayeredwindowattributes ) return 255;

	SetWindowLong(hWnd, GWL_EXSTYLE, GetWindowLong(hWnd, GWL_EXSTYLE) | WS_EX_LAYERED);
	funcs->getlayeredwindowattributes(hWnd, &key, &opacity, &flag);
	SetWindowLong(hWnd, GWL_EXSTYLE, GetWindowLong(hWnd, GWL_EXSTYLE) & !WS_EX_LAYERED);
	return opacity;
}

HWND win_get_top_hwnd_from_point(int x, int y){
	POINT pt;
	pt.x = x; pt.y = y;
	return WindowFromPoint(&pt);
}

