/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "winwrap.h"

int win_get_pos_size(HWND hWnd, int *x, int *y, int *width, int *height){
	RECT rc;
	if (GetWindowRect(hWnd, &rc) == 0) return 0;
	if (x) *x = rc.left;
	if (y) *y = rc.top;
	if (width) *width = rc.right - rc.left;
	if (height) *height = rc.bottom - rc.top;
	return 1;
}

void win_set_topmost(HWND hWnd, BOOL b){
	HWND hWnd_mode;
	if (b) hWnd_mode = HWND_TOPMOST;
	else hWnd_mode = HWND_NOTOPMOST;
	SetWindowPos(hWnd, hWnd_mode, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
}

void win_set_top(HWND hWnd){
	SetWindowPos(hWnd, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
}

void win_cursor_get_pos(int *x, int *y){
	POINT pt;
	GetCursorPos(&pt);
	if (x) *x = pt.x;
	if (y) *y = pt.y;
}

	void win_move(HWND hWnd, int x, int y){
	SetWindowPos(hWnd, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
}
