/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wlabel.h"

void wlabel_set_text(WLabel *_this, char *text){
	if (!_this || _this->hWnd) return;
	SetWindowTextA(_this->hWnd, text);
}

WLabel *wlabel_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height, char *text){
	WLabel *_this;
	_this = wwindow_new(wapp);
	if (!_this) goto error_wlabel_new;
	_this->hWnd = CreateWindowEx(WS_EX_LEFT, "Static", text,
		WS_CHILD | WS_CLIPCHILDREN | SS_LEFT | WS_CLIPSIBLINGS,
		x, y, width, height, parent->hWnd, NULL, GetModuleHandle(NULL), NULL);
	if (!_this->hWnd) goto error_wlabel_new;
	return _this;

error_wlabel_new:
	wwindow_delete(_this);
	return NULL;
}

