#include "wpixbutton.h"

static int wpixbutton_wndproc(WWindow *_this, UINT uMsg, WPARAM wParam, LPARAM lParam){
	DWORD bstate;
	POINT pt;
	RECT rc;
    switch(uMsg){
		case WM_LBUTTONDBLCLK:
		case WM_LBUTTONDOWN:
			WPIXBUTTON_IS_CAPTURE(_this) = 1;
			break;
		case WM_LBUTTONUP:
			if (!WPIXBUTTON_IS_CAPTURE(_this)) break;
			WPIXBUTTON_IS_CAPTURE(_this) = 0;
			GetCursorPos(&pt);
			ScreenToClient(_this->hWnd, &pt);
			GetClientRect(_this->hWnd, &rc);
			if (pt.x < 0 || pt.y < 0 || pt.x > rc.right || pt.y > rc.bottom) break;
			bstate = (DWORD)SendMessage(WPIXBUTTON_BUTTONHWND(_this), BM_GETCHECK, 0, 0);
			WPIXBUTTON_STATE(_this) = (bstate == BST_CHECKED) ? WPIXBUTTON_STATE_OFF : WPIXBUTTON_STATE_ON;
			if (WPIXBUTTON_MODE(_this) == WPIXBUTTON_MODE_NORMAL) WPIXBUTTON_STATE(_this) = WPIXBUTTON_STATE_OFF;
			if (WPIXBUTTON_CLICKED(_this)) WPIXBUTTON_CLICKED(_this)(_this, WPIXBUTTON_STATE(_this));
			break;
	}
	return 1;
}

/*
static int wpixbutton_wndproc(WWindow *_this, UINT uMsg, WPARAM wParam, LPARAM lParam){
	DWORD bstate;
	if (uMsg == WM_COMMAND){
		bstate = (DWORD)SendMessage(WPIXBUTTON_BUTTONHWND(_this), BM_GETCHECK, 0, 0);
		WPIXBUTTON_STATE(_this) = (bstate == BST_CHECKED) ? WPIXBUTTON_STATE_ON : WPIXBUTTON_STATE_OFF;
		if (WPIXBUTTON_MODE(_this) == WPIXBUTTON_MODE_NORMAL) WPIXBUTTON_STATE(_this) = WPIXBUTTON_STATE_OFF;
		if (WPIXBUTTON_CLICKED(_this)) WPIXBUTTON_CLICKED(_this)(_this, WPIXBUTTON_STATE(_this));
	}
	return 1;
}
*/

void wpixbutton_set_image(WPixButton *_this, WGraphics *g){
	if (!_this) return;
	SendMessage(WPIXBUTTON_BUTTONHWND(_this), BM_SETIMAGE, IMAGE_BITMAP, (LPARAM)(HANDLE)g->hBmp);
}

static LRESULT CALLBACK TransProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam){
	WNDPROC wndproc;
	HWND hParent;
	switch(uMsg){
		case WM_MOUSEMOVE:
		case WM_LBUTTONDOWN:
		case WM_LBUTTONUP:
		case WM_LBUTTONDBLCLK:
		case WM_RBUTTONDOWN:
		case WM_RBUTTONUP:
			hParent = GetParent(hWnd);
			SendMessage(hParent, uMsg, wParam, lParam);
			break;
	}
	wndproc = (WNDPROC)GetWindowLong(hWnd, GWL_USERDATA);
	if (wndproc){
		return CallWindowProc(wndproc, hWnd, uMsg, wParam, lParam);
	}else{
		return 0;
	}
}

static void callback_destruct(void *data){
	WWindow *_this = data;
	if (_this){
		if (IsWindow(WPIXBUTTON_BUTTONHWND(_this))){
			DestroyWindow(WPIXBUTTON_BUTTONHWND(_this));
		}
	}
}

WPixButton *wpixbutton_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height, WGraphics *g, WPixButtonMode mode){
	DWORD state;
	WPixButton *_this;
	_this = wwindow_new(wapp);
	if (!_this) goto error_wpixbutton_new;
	WPIXBUTTON_CLICKED(_this) = NULL;
	WPIXBUTTON_IS_CAPTURE(_this) = 0;
	WPIXBUTTON_STATE(_this) = WPIXBUTTON_STATE_OFF;
	WPIXBUTTON_MODE(_this) = mode;
	_this->hWnd = CreateWindowEx(WS_EX_LEFT, WWINDOW_WNDCLASS, "", WS_CHILD | WS_CLIPCHILDREN,
		x, y, width, height, parent->hWnd, NULL, GetModuleHandle(NULL), NULL);
	if (!_this->hWnd) goto error_wpixbutton_new;
	state = WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | BS_BITMAP | BS_CENTER;
	if (mode == WPIXBUTTON_MODE_TOGGLE){
		state |= BS_AUTOCHECKBOX;
	}
	WPIXBUTTON_BUTTONHWND(_this) = CreateWindowEx(WS_EX_LEFT, "Button", NULL, state,
		0, 0, width, height, _this->hWnd, (HMENU)1, GetModuleHandle(NULL), NULL);
	if (g) wpixbutton_set_image(_this, g);
	wwindow_validate_callback(_this, 0);
	_this->chain_wndproc = wpixbutton_wndproc;
	SetWindowLong(WPIXBUTTON_BUTTONHWND(_this), GWL_USERDATA, 
		SetWindowLong(WPIXBUTTON_BUTTONHWND(_this), GWL_WNDPROC, (LONG)TransProc));
	wwindow_regist_destructor(_this, callback_destruct);
	return _this;

error_wpixbutton_new:
	wwindow_delete(_this);
	return NULL;
}

