#ifndef H_WPIXBUTTON_H_
#define H_WPIXBUTTON_H_

#include "wwindow.h"
#include "wgraphics.h"

#define WPixButton WWindow

typedef enum{
	WPIXBUTTON_MODE_NORMAL, WPIXBUTTON_MODE_TOGGLE,
}WPixButtonMode;

typedef enum{
	WPIXBUTTON_STATE_OFF, WPIXBUTTON_STATE_ON,
}WPixButtonState;

WPixButton *wpixbutton_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height, WGraphics *g, WPixButtonMode mode);
void wpixbutton_set_image(WPixButton *, WGraphics *);

#define WPIXBUTTON_CLICKED(X) ((void (*)(WPixButton *, WPixButtonState s))(((WWindow *)X)->childdata[0].vp[0]))
#define WPIXBUTTON_BUTTONHWND(X) ((HWND)(((WWindow *)X)->childdata[0].vp[1]))
#define WPIXBUTTON_IS_CAPTURE(X) (((WWindow *)X)->childdata[1].b[0].b0)
#define WPIXBUTTON_STATE(X) (((WWindow *)X)->childdata[2].i[0])
#define WPIXBUTTON_MODE(X) (((WWindow *)X)->childdata[2].i[1])

#endif /* H_WTEXTBUTTON_H_ */
