/*
 * Copyright (c) 2003,2004,2006 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wradiobutton.h"
#include <stdio.h>

static void unselect_others(WRadioButton *_this){
	WRadioButton *iter;
	iter = WRADIOBUTTON_PREV(_this);
	while(iter){
		SendMessage(WRADIOBUTTON_BUTTONHWND(iter), BM_SETCHECK, BST_UNCHECKED, 0);
		iter = WRADIOBUTTON_PREV(iter);
	}
	iter = WRADIOBUTTON_NEXT(_this);
	while(iter){
		SendMessage(WRADIOBUTTON_BUTTONHWND(iter), BM_SETCHECK, BST_UNCHECKED, 0);
		iter = WRADIOBUTTON_NEXT(iter);
	}
}

static int wradiobutton_wndproc(WWindow *_this, UINT uMsg, WPARAM wParam, LPARAM lParam){
	DWORD bstate;
	POINT pt;
	RECT rc;
    switch(uMsg){
		case WM_LBUTTONDBLCLK:
		case WM_LBUTTONDOWN:
			WRADIOBUTTON_IS_CAPTURE(_this) = 1;
			break;
		case WM_LBUTTONUP:
			if (!WRADIOBUTTON_IS_CAPTURE(_this)) break;
			WRADIOBUTTON_IS_CAPTURE(_this) = 0;
			GetCursorPos(&pt);
			ScreenToClient(_this->hWnd, &pt);
			GetClientRect(_this->hWnd, &rc);
			if (pt.x < 0 || pt.y < 0 || pt.x > rc.right || pt.y > rc.bottom) break;
			bstate = (DWORD)SendMessage(WRADIOBUTTON_BUTTONHWND(_this), BM_GETCHECK, 0, 0);
			WRADIOBUTTON_STATE(_this) = (bstate == BST_CHECKED) ? WRADIOBUTTON_STATE_OFF : WRADIOBUTTON_STATE_ON;
			if (WRADIOBUTTON_CLICKED(_this)) WRADIOBUTTON_CLICKED(_this)(_this, WRADIOBUTTON_STATE(_this));
			unselect_others(_this);
			break;
	}
	return 1;
}

void wradiobutton_set_text(WRadioButton *_this, char *text){
	if (!_this || _this->hWnd) return;
	SetWindowTextA(WRADIOBUTTON_BUTTONHWND(_this), text);
}

void wradiobutton_select(WRadioButton *_this){
	SendMessage(WRADIOBUTTON_BUTTONHWND(_this), BM_SETCHECK, BST_CHECKED, 0);
	unselect_others(_this);
}

static LRESULT CALLBACK TransProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam){
	WNDPROC wndproc;
	HWND hParent;
	switch(uMsg){
		case WM_MOUSEMOVE:
		case WM_LBUTTONDOWN:
		case WM_LBUTTONUP:
		case WM_LBUTTONDBLCLK:
		case WM_RBUTTONDOWN:
		case WM_RBUTTONUP:
			hParent = GetParent(hWnd);
			SendMessage(hParent, uMsg, wParam, lParam);
			break;
	}
	wndproc = (WNDPROC)GetWindowLong(hWnd, GWL_USERDATA);
	if (wndproc){
		return CallWindowProc(wndproc, hWnd, uMsg, wParam, lParam);
	}else{
		return 0;
	}
}

static void callback_destruct(void *data){
	WWindow *_this = data;
	if (_this){
		if (WRADIOBUTTON_PREV(_this) && WRADIOBUTTON_NEXT(_this)){
			WRADIOBUTTON_NEXT(WRADIOBUTTON_PREV(_this)) = WRADIOBUTTON_NEXT(_this);
			WRADIOBUTTON_PREV(WRADIOBUTTON_NEXT(_this)) = WRADIOBUTTON_PREV(_this);
		}else if(WRADIOBUTTON_PREV(_this)){
			WRADIOBUTTON_NEXT(WRADIOBUTTON_PREV(_this)) = NULL;
		}else if(WRADIOBUTTON_NEXT(_this)){
			WRADIOBUTTON_PREV(WRADIOBUTTON_NEXT(_this)) = NULL;
		}

		if (IsWindow(WRADIOBUTTON_BUTTONHWND(_this))){
			DestroyWindow(WRADIOBUTTON_BUTTONHWND(_this));
		}
	}
}

static WRadioButton *find_last(WRadioButton *group){
	WRadioButton *iter = group;
	for(;;){
		if (WRADIOBUTTON_NEXT(iter)){
			iter = WRADIOBUTTON_NEXT(iter);
		}else{
			return iter;
		}
	}
}

WRadioButton *wradiobutton_new(WApp *wapp, WWindow *parent, WRadioButton *group, int x, int y, int width, int height, char *text){
	DWORD state;
	WRadioButton *_this;
	_this = wwindow_new(wapp);
	if (!_this) goto error_wradiobutton_new;
	WRADIOBUTTON_CLICKED(_this) = NULL;
	WRADIOBUTTON_IS_CAPTURE(_this) = 0;
	WRADIOBUTTON_STATE(_this) = WRADIOBUTTON_STATE_OFF;

	_this->hWnd = CreateWindowEx(WS_EX_LEFT, WWINDOW_WNDCLASS, "", WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
		x, y, width, height, parent->hWnd, NULL, GetModuleHandle(NULL), NULL);
	if (!_this->hWnd) goto error_wradiobutton_new;

	state = WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | WS_CLIPSIBLINGS | BS_AUTORADIOBUTTON;

	WRADIOBUTTON_BUTTONHWND(_this) = CreateWindowEx(WS_EX_LEFT, "Button", text, state,
		0, 0, width, height, _this->hWnd, (HMENU)1, GetModuleHandle(NULL), NULL);
	wwindow_validate_callback(_this, 0);
	_this->chain_wndproc = wradiobutton_wndproc;

	SetWindowLong(WRADIOBUTTON_BUTTONHWND(_this), GWL_USERDATA, 
		SetWindowLong(WRADIOBUTTON_BUTTONHWND(_this), GWL_WNDPROC, (LONG)TransProc));
	wwindow_regist_destructor(_this, callback_destruct);

	if (group){
		WRADIOBUTTON_PREV(_this) = find_last(group);
		WRADIOBUTTON_NEXT(WRADIOBUTTON_PREV(_this)) = _this;
	}else{
		WRADIOBUTTON_PREV(_this) = NULL;
		wradiobutton_select(_this);
	}
	WRADIOBUTTON_NEXT(_this) = NULL;

	return _this;

error_wradiobutton_new:
	wwindow_delete(_this);
	return NULL;
}

