/*
 * Copyright (c) 2003,2004,2006 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef H_WRADIOBUTTON_H_
#define H_WRADIOBUTTON_H_

#include "wwindow.h"

#define WRadioButton WWindow

typedef enum{
	WRADIOBUTTON_STATE_OFF, WRADIOBUTTON_STATE_ON,
}WRadioButtonState;

WRadioButton *wradiobutton_new(WApp *wapp, WWindow *parent, WRadioButton *group, int x, int y, int width, int height, char *text);	
void wradiobutton_set_text(WRadioButton *, char *);
void wradiobutton_select(WRadioButton *);

#define WRADIOBUTTON_CLICKED(X) ((void (*)(WRadioButton *, WRadioButtonState s))(((WWindow *)X)->childdata[0].vp[0]))
#define WRADIOBUTTON_BUTTONHWND(X) ((HWND)(((WWindow *)X)->childdata[0].vp[1]))
#define WRADIOBUTTON_IS_CAPTURE(X) (((WWindow *)X)->childdata[1].b[0].b0)
#define WRADIOBUTTON_STATE(X) (((WWindow *)X)->childdata[2].i[0])
#define WRADIOBUTTON_PREV(X) ((WRadioButton *)(((WWindow *)X)->childdata[3].vp[0]))
#define WRADIOBUTTON_NEXT(X) ((WRadioButton *)(((WWindow *)X)->childdata[3].vp[1]))

#endif /* H_WRADIOBUTTON_H_ */
