/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wtextbutton.h"

static int wtextbutton_wndproc(WWindow *_this, UINT uMsg, WPARAM wParam, LPARAM lParam){
	DWORD bstate;
	POINT pt;
	RECT rc;
    switch(uMsg){
		case WM_LBUTTONDBLCLK:
		case WM_LBUTTONDOWN:
			WTEXTBUTTON_IS_CAPTURE(_this) = 1;
			break;
		case WM_LBUTTONUP:
			if (!WTEXTBUTTON_IS_CAPTURE(_this)) break;
			WTEXTBUTTON_IS_CAPTURE(_this) = 0;
			GetCursorPos(&pt);
			ScreenToClient(_this->hWnd, &pt);
			GetClientRect(_this->hWnd, &rc);
			if (pt.x < 0 || pt.y < 0 || pt.x > rc.right || pt.y > rc.bottom) break;
			bstate = (DWORD)SendMessage(WTEXTBUTTON_BUTTONHWND(_this), BM_GETCHECK, 0, 0);
			WTEXTBUTTON_STATE(_this) = (bstate == BST_CHECKED) ? WTEXTBUTTON_STATE_OFF : WTEXTBUTTON_STATE_ON;
			if (WTEXTBUTTON_MODE(_this) == WTEXTBUTTON_MODE_NORMAL) WTEXTBUTTON_STATE(_this) = WTEXTBUTTON_STATE_OFF;
			if (WTEXTBUTTON_CLICKED(_this)) WTEXTBUTTON_CLICKED(_this)(_this, WTEXTBUTTON_STATE(_this));
			break;
	}
	return 1;
}

/*
static int wtextbutton_wndproc(WWindow *_this, UINT uMsg, WPARAM wParam, LPARAM lParam){
	DWORD bstate;
	if (uMsg == WM_COMMAND){
		bstate = (DWORD)SendMessage(WTEXTBUTTON_BUTTONHWND(_this), BM_GETCHECK, 0, 0);
		WTEXTBUTTON_STATE(_this) = (bstate == BST_CHECKED) ? WTEXTBUTTON_STATE_ON : WTEXTBUTTON_STATE_OFF;
		if (WTEXTBUTTON_MODE(_this) == WTEXTBUTTON_MODE_NORMAL) WTEXTBUTTON_STATE(_this) = WTEXTBUTTON_STATE_OFF;
		if (WTEXTBUTTON_CLICKED(_this)) WTEXTBUTTON_CLICKED(_this)(_this, WTEXTBUTTON_STATE(_this));
	}
	return 1;
}
*/

void wtextbutton_set_text(WTextButton *_this, char *text){
	if (!_this || _this->hWnd) return;
	SetWindowTextA(WTEXTBUTTON_BUTTONHWND(_this), text);
}

void wtextbutton_set_state(WTextButton *_this, WTextButtonState state){
	WPARAM checked;
	switch(state){
		case WTEXTBUTTON_STATE_ON:
			checked = BST_CHECKED;
			break;
		case WTEXTBUTTON_STATE_OFF:
			checked = BST_UNCHECKED;
			break;
	}
	SendMessage(WTEXTBUTTON_BUTTONHWND(_this), BM_SETCHECK, checked, 0);
}

static LRESULT CALLBACK TransProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam){
	WNDPROC wndproc;
	HWND hParent;
	switch(uMsg){
		case WM_MOUSEMOVE:
		case WM_LBUTTONDOWN:
		case WM_LBUTTONUP:
		case WM_LBUTTONDBLCLK:
		case WM_RBUTTONDOWN:
		case WM_RBUTTONUP:
			hParent = GetParent(hWnd);
			SendMessage(hParent, uMsg, wParam, lParam);
			break;
	}
	wndproc = (WNDPROC)GetWindowLong(hWnd, GWL_USERDATA);
	if (wndproc){
		return CallWindowProc(wndproc, hWnd, uMsg, wParam, lParam);
	}else{
		return 0;
	}
}

static void callback_destruct(void *data){
	WWindow *_this = data;
	if (_this){
		if (IsWindow(WTEXTBUTTON_BUTTONHWND(_this))){
			DestroyWindow(WTEXTBUTTON_BUTTONHWND(_this));
		}
	}
}

WTextButton *wtextbutton_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height, char *text, WTextButtonMode mode){
	DWORD state;
	WTextButton *_this;
	_this = wwindow_new(wapp);
	if (!_this) goto error_wtextbutton_new;
	WTEXTBUTTON_CLICKED(_this) = NULL;
	WTEXTBUTTON_IS_CAPTURE(_this) = 0;
	WTEXTBUTTON_STATE(_this) = WTEXTBUTTON_STATE_OFF;
	WTEXTBUTTON_MODE(_this) = mode;
	_this->hWnd = CreateWindowEx(WS_EX_LEFT, WWINDOW_WNDCLASS, "", WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
		x, y, width, height, parent->hWnd, NULL, GetModuleHandle(NULL), NULL);
	if (!_this->hWnd) goto error_wtextbutton_new;
	state = WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE | WS_CLIPSIBLINGS;
	if (mode != WTEXTBUTTON_MODE_CHECKBOX){
		state |= BS_PUSHLIKE;
	}
	if (mode != WTEXTBUTTON_MODE_NORMAL){
		state |= BS_AUTOCHECKBOX;
	}
	WTEXTBUTTON_BUTTONHWND(_this) = CreateWindowEx(WS_EX_LEFT, "Button", text, state,
		0, 0, width, height, _this->hWnd, (HMENU)1, GetModuleHandle(NULL), NULL);
	wwindow_validate_callback(_this, 0);
	_this->chain_wndproc = wtextbutton_wndproc;
	SetWindowLong(WTEXTBUTTON_BUTTONHWND(_this), GWL_USERDATA, 
		SetWindowLong(WTEXTBUTTON_BUTTONHWND(_this), GWL_WNDPROC, (LONG)TransProc));
	wwindow_regist_destructor(_this, callback_destruct);
	return _this;

error_wtextbutton_new:
	wwindow_delete(_this);
	return NULL;
}

