/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wtimer.h"

#define BLOCK 50

WTimer *wtimer_new(void){
	WTimer *_this;
	_this = (WTimer *)malloc(sizeof(WTimer));
	if (!_this) goto error_wtimer_new;

	_this->num_array = 0;
	_this->alloc_array = BLOCK;
	_this->array = (WTimerWaiter *)malloc(_this->alloc_array * sizeof(WTimerWaiter));
	if (!_this->array) goto error_wtimer_new;

	timeBeginPeriod(1);
	return _this;
error_wtimer_new:
	wtimer_delete(_this);
	return NULL;
}

void wtimer_delete(WTimer *_this){
	if (!_this) return;
	if (_this->array) free(_this->array);
	free(_this);
	timeEndPeriod(1);
}

unsigned int wtimer_regist_callback(WTimer *_this, unsigned int interval, void (*func)(unsigned int, void *), void *data){
	unsigned int i;
	if (!_this || !_this->array) goto error_wtimer_regist_callback;
	for (i = 0; i < _this->num_array; i++){
		if (!_this->array[i].callback){
			_this->array[i].interval = interval;
			_this->array[i].callback = func;
			_this->array[i].data = data;
			_this->array[i].next = timeGetTime() + interval;
			return i+1;
		}
	}

	_this->array[_this->num_array].interval = interval;
	_this->array[_this->num_array].callback = func;
	_this->array[_this->num_array].data = data;
	_this->array[_this->num_array].next = timeGetTime() + interval;
	_this->num_array++;
	if (_this->num_array == _this->alloc_array){
		_this->alloc_array += BLOCK;
		_this->array = (WTimerWaiter *)realloc(_this->array, sizeof(WTimerWaiter));
		if (!_this->array){
			_this->num_array = 0;
			goto error_wtimer_regist_callback;
		}
	}
	return _this->num_array;
error_wtimer_regist_callback:
	return 0;
}

void wtimer_unregist_callback(WTimer *_this, unsigned int id){
	if (!_this || id > _this->num_array) goto error_wtimer_unregist_callback;
	_this->array[id-1].callback = NULL;
	return;
error_wtimer_unregist_callback:
	return;
}

void wtimer_do_once(WTimer *_this){
	DWORD time;
	unsigned int i;
	if (!_this) return;
	time = timeGetTime();
	for (i = 0; i < _this->num_array; i++){
		if (!_this->array[i].callback) continue;
		if (_this->array[i].next <= time){
			_this->array[i].callback(i+1, _this->array[i].data);
			_this->array[i].next += _this->array[i].interval;
		}
	}
	return;
}
