/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef H_WTIMER_H_
#define H_WTIMER_H_

#include <windows.h>
#include <stdlib.h>


typedef struct {
	void (*callback)(unsigned int id, void *data);
	void *data;
	DWORD next;
	unsigned int interval;
}WTimerWaiter;

typedef struct {
	unsigned int num_array, alloc_array;
	WTimerWaiter *array;
}WTimer;

WTimer *wtimer_new(void);
void wtimer_do_once(WTimer *);

/** @func wtimer_regist_callback
 * @retval 1ȏ o^ꂽ^C}id
 * @retval 0 s
 */
unsigned int wtimer_regist_callback(WTimer *, unsigned int interval, void (*func)(unsigned int, void *), void *data);
void wtimer_unregist_callback(WTimer *_this, unsigned int id);
void wtimer_delete(WTimer *);

#endif /* H_WTIMER_H_ */
