/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wtop.h"


WTop *wtop_new(WApp *wapp, int x, int y, int width, int height, WTopMode tm){
	RECT rc;
	DWORD style, style_ex;
	WTop *_this;
	_this = wwindow_new(wapp);
	if (!_this) goto error_wtop_new;

	switch(tm){
		case WTOPMODE_NORMAL:
			style = WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_CLIPSIBLINGS;
			style_ex = WS_EX_LEFT;
			break;
		case WTOPMODE_POPUP:
			style = WS_POPUP | WS_CLIPCHILDREN | WS_CLIPSIBLINGS;
			style_ex = WS_EX_TOOLWINDOW;
			break;
	}
	_this->hWnd = CreateWindowEx(style_ex, WWINDOW_WNDCLASS, "", style,
		x, y, width, height, NULL, NULL, GetModuleHandle(NULL), NULL);
	rc.left = x; rc.top = y;
	rc.right = x + width; rc.bottom = y + height;
	AdjustWindowRectEx(&rc, style, FALSE, style_ex);
	SetWindowPos(_this->hWnd, HWND_TOP, 0, 0, rc.right - rc.left, rc.bottom - rc.top, SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);

	return _this;
error_wtop_new:
	return NULL;
}

void wtop_delete(WApp *wapp){
	wwindow_delete((WWindow *)wapp);
}

void wtop_set_name(WTop *_this, char *name){
	if (!_this) return;
	SetWindowTextA(_this->hWnd, name);
}
