/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "wtrackbar.h"

static int wtrackbar_wndproc(WWindow *_this, UINT uMsg, WPARAM wParam, LPARAM lParam){
	int value;
	switch(uMsg){
		case WM_NOTIFY:
			value = wtrackbar_get_value(_this);
			if (WTRACKBAR_VALUE_CHANGED(_this)) WTRACKBAR_VALUE_CHANGED(_this)(_this, value);
			break;
	}
	return 1;
}

void wtrackbar_set_max_min(WTrackbar *_this, int max, int min){
	SendMessage(WTRACKBAR_HWND(_this), TBM_SETRANGEMIN, FALSE, min);
	SendMessage(WTRACKBAR_HWND(_this), TBM_SETRANGEMAX, TRUE, max);
}

void wtrackbar_set_value(WTrackbar *_this, int value){
	SendMessage(WTRACKBAR_HWND(_this), TBM_SETPOS, TRUE, value);
}

int wtrackbar_get_value(WTrackbar *_this){
	return SendMessage(WTRACKBAR_HWND(_this), TBM_GETPOS, 0, 0);
}

WTrackbar *wtrackbar_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height, WTrackbarMode mode){
	DWORD style;
	WTrackbar *_this;
	_this = wwindow_new(wapp);
	if (!_this) goto error_wtrackbar_new;
	InitCommonControls();
	_this->hWnd = CreateWindowEx(WS_EX_LEFT, WWINDOW_WNDCLASS, "", WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
		x, y, width, height, parent->hWnd, NULL, GetModuleHandle(NULL), NULL);
	if (!_this->hWnd) goto error_wtrackbar_new;

	style = WS_CHILDWINDOW | WS_VISIBLE | WS_CLIPCHILDREN | TBS_BOTH | TBS_NOTICKS | WS_CLIPSIBLINGS;
	switch(mode){
		case WTRACKBARMODE_VERT:
			style |= TBS_VERT;
			break;
		case WTRACKBARMODE_HORZ:
			style |= TBS_HORZ;
			break;
	}
	WTRACKBAR_HWND(_this) = CreateWindowEx(WS_EX_LEFT, TRACKBAR_CLASS, "",
		style, 0, 0, width, height, _this->hWnd, (HMENU)1, GetModuleHandle(NULL), NULL);
	if (!WTRACKBAR_HWND(_this)) goto error_wtrackbar_new;

	WTRACKBAR_VALUE_CHANGED(_this) = NULL;
	wwindow_validate_callback(_this, 0);
	_this->chain_wndproc = wtrackbar_wndproc;
	return _this;

error_wtrackbar_new:
	wwindow_delete(_this);
	return NULL;
}

