/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef H_WTRACKBAR_H_
#define H_WTRACKBAR_H_

#include "wwindow.h"
#include <commctrl.h>

#define WTrackbar WWindow

typedef enum{
	WTRACKBARMODE_HORZ, WTRACKBARMODE_VERT,
}WTrackbarMode;

WTrackbar *wtrackbar_new(WApp *wapp, WWindow *parent, int x, int y, int width, int height, WTrackbarMode mode);
void wtrackbar_set_max_min(WTrackbar *_this, int min, int max);
void wtrackbar_set_value(WTrackbar *_this, int value);
int wtrackbar_get_value(WTrackbar *_this);

#define WTRACKBAR_HWND(X) ((HWND)(((WWindow *)X)->childdata[0].vp[0]))
#define WTRACKBAR_VALUE_CHANGED(X) ((void (*)(WTrackbar *, int value))(((WWindow *)X)->childdata[0].vp[1]))


#endif /* H_WTRACKBAR_H_ */
