/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "wwindow.h"

static WWindow **array = NULL;
static int num_array = 0, alloc_array = 0;
#define BLOCK_ALLOC 50

static LRESULT CALLBACK WndProc_empty(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam){
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

static void register_window(void){
	WNDCLASSEX wc;
	ZeroMemory(&wc, sizeof(wc));
	wc.cbSize = sizeof(wc);
	wc.style = 0;
	wc.hbrBackground = (HBRUSH)(COLOR_BTNFACE + 1);
	wc.hInstance = GetModuleHandle(NULL);
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hIconSm = wc.hIcon;
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.lpfnWndProc = WndProc_empty;
	wc.lpszClassName = WWINDOW_WNDCLASS;
	RegisterClassEx(&wc);
}


WWindow *wwindow_new(WApp *wapp){
	WWindow *_this;
	_this = (WWindow *)malloc(sizeof(WWindow));
	if (!_this) goto error_wwindow_new;

	_this->vc = 0;
	_this->wapp = wapp;
	_this->hWnd = NULL;
	_this->wndproc = NULL;

	_this->resize = NULL;
	_this->mousebutton = NULL;
	_this->mousemove = NULL;
	_this->close = NULL;
	_this->destroy = NULL;


	_this->chain_wndproc = NULL;

	_this->alloc_destructors = BLOCK_ALLOC;
	_this->num_destructors = 0;
	_this->destructor_of_childclass =
		(void (**)(void *))malloc(_this->alloc_destructors * sizeof(void (*)(void *)));
	if (!_this->destructor_of_childclass) goto error_wwindow_new;

	wapp_add_window(wapp, _this);

	if (!array){
		register_window();
		alloc_array = BLOCK_ALLOC;
		array = (WWindow **)malloc(alloc_array * sizeof(WWindow *));
		if (!array) goto error_wwindow_new;
	}
	array[num_array] = _this;
	num_array++;
	if (num_array == alloc_array){
		alloc_array += BLOCK_ALLOC;
		array = (WWindow **)realloc(array, alloc_array * sizeof(WWindow *));
		if (!array) goto error_wwindow_new;
	}


	return _this;
error_wwindow_new:
	wwindow_delete(_this);
	return NULL;
}

void wwindow_regist_destructor(WWindow *_this, void (*func)(void *)){
	if (!_this) return;
	_this->destructor_of_childclass[_this->num_destructors] = func;
	_this->num_destructors++;
	if (_this->num_destructors == _this->alloc_destructors){
		_this->alloc_destructors += BLOCK_ALLOC;
		_this->destructor_of_childclass =
			(void (**)(void *))realloc(_this->destructor_of_childclass, sizeof(void (*)(void *)));
		if (!_this->destructor_of_childclass) _this->num_destructors = 0;
	}
}

void wwindow_delete(WWindow *_this){
	int i;
	if (_this){
		for (i = 0; i < _this->num_destructors; i++){
			_this->destructor_of_childclass[i](_this);
		}
		if (IsWindow(_this->hWnd)){
			DestroyWindow(_this->hWnd);
			wapp_remove_window(_this->wapp, _this);
		}
		free(_this);
	}
}

static WWindow *wwindow_get_instance_fromhwnd(HWND hWnd){
	int i;
	for (i = 0; i < num_array; i++){
		if (array[i]->hWnd == hWnd) return array[i];
	}
	return NULL;
}

static LRESULT CALLBACK wwindow_Wndproc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam){
	WWindow *_this;
	MouseMoveState mms;
	int x, y;
	_this = wwindow_get_instance_fromhwnd(hWnd);
	if (!_this || !_this->wndproc) return 0;
	x = (int)(WORD)LOWORD(lParam);
	y = (int)(WORD)HIWORD(lParam);
	if ((_this->vc & VALIDATECALLBACK_MOUSEBUTTON) && _this->mousebutton){
		switch(uMsg){
		case WM_LBUTTONDOWN:
			SetCapture(hWnd);
			_this->mousebutton(_this, x, y, MOUSEBUTTONSTATE_L_PUSH);
			break;
		case WM_RBUTTONDOWN:
			SetCapture(hWnd);
			_this->mousebutton(_this, x, y, MOUSEBUTTONSTATE_R_PUSH);
			break;
		case WM_LBUTTONUP:
			ReleaseCapture();
			_this->mousebutton(_this, x, y, MOUSEBUTTONSTATE_L_RELEASE);
			break;
		case WM_RBUTTONUP:
			ReleaseCapture();
			_this->mousebutton(_this, x, y, MOUSEBUTTONSTATE_R_RELEASE);
			break;
		}
	}
	if (uMsg == WM_SYSCOMMAND && wParam == SC_CLOSE && 
			(_this->vc & VALIDATECALLBACK_CLOSE) && _this->close){
		if (_this->close(_this)){
			return 0;
		}
	}else if (uMsg == WM_DESTROY){
		if ((_this->vc & VALIDATECALLBACK_DESTROY) && _this->destroy){
			_this->destroy(_this);
		}
		_this->hWnd = NULL;
	}else if (uMsg == WM_MOUSEMOVE && (_this->vc & VALIDATECALLBACK_MOUSEMOVE) && _this->mousemove){
		mms = wParam & MK_LBUTTON ? MOUSEMOVESTATE_L_DOWN : MOUSEMOVESTATE_L_UP;
		mms |= wParam & MK_RBUTTON ? MOUSEMOVESTATE_R_DOWN : MOUSEMOVESTATE_R_UP;
		_this->mousemove(_this, x, y, mms);
	}else if (uMsg == WM_SIZE && (_this->vc & VALIDATECALLBACK_RESIZE) && _this->resize){
		_this->resize(_this, (int)(WORD)LOWORD(lParam), (int)(WORD)HIWORD(lParam));
	}

	if (_this->chain_wndproc){
		if (!(_this->chain_wndproc(_this, uMsg, wParam, lParam))) return 0;
	}
	return CallWindowProc(_this->wndproc, hWnd, uMsg, wParam, lParam);
}

void wwindow_validate_callback(WWindow *_this, ValidateCallback vc){
	if (!_this) return;
	_this->vc |= vc;
	if (!_this->wndproc){
		_this->wndproc = (WNDPROC)SetWindowLong(_this->hWnd, GWL_WNDPROC, (LONG)wwindow_Wndproc);
	}
}

WApp *wwindow_get_wapp(WWindow *_this){
	if (!_this) return NULL;
	return _this->wapp;
}

void wwindow_show(WWindow *_this){
	if (!_this) return;
	ShowWindow(_this->hWnd, SW_SHOW);
}

void wwindow_hide(WWindow *_this){
	if (!_this) return;
	ShowWindow(_this->hWnd, SW_HIDE);
}

void wwindow_set_size(WWindow *_this, int width, int height){
	if (!_this) return;
	SetWindowPos(_this->hWnd, HWND_TOP, 0, 0, width, height, SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);
}


