/*
 * Copyright (c) 2003,2004 Mocchi in Japan, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef H_WWINDOW_H_
#define H_WWINDOW_H_

#include <windows.h>
#include <stdlib.h>
#include "wapp.h"

#define WWINDOW_WNDCLASS "wwindow_wndclass"

typedef enum {
	MOUSEMOVESTATE_L_UP = 0, MOUSEMOVESTATE_R_UP = 0,
	MOUSEMOVESTATE_L_DOWN = 1, MOUSEMOVESTATE_R_DOWN = 2, 
}MouseMoveState;

typedef enum {
	MOUSEBUTTONSTATE_L_PUSH, MOUSEBUTTONSTATE_R_PUSH,
	MOUSEBUTTONSTATE_L_RELEASE, MOUSEBUTTONSTATE_R_RELEASE,
}MouseButtonState;

typedef enum {
	VALIDATECALLBACK_MOUSEBUTTON = 0x01, VALIDATECALLBACK_MOUSEMOVE = 0x02,
	VALIDATECALLBACK_CLOSE = 0x04, VALIDATECALLBACK_DESTROY = 0x08, 
	VALIDATECALLBACK_RESIZE = 0x10,
}ValidateCallback;

typedef struct{
	unsigned char b0 : 1;
	unsigned char b1 : 1;
	unsigned char b2 : 1;
	unsigned char b3 : 1;
	unsigned char b4 : 1;
	unsigned char b5 : 1;
	unsigned char b6 : 1;
	unsigned char b7 : 1;
	unsigned char b8 : 1;
}Bool8;

typedef struct tagWWindow{
	WApp *wapp;

	HWND hWnd;
	WNDPROC wndproc;
	ValidateCallback vc;
	void (*mousemove)(struct tagWWindow *, int x, int y, MouseMoveState);
	void (*mousebutton)(struct tagWWindow *, int x, int y, MouseButtonState);
	void (*resize)(struct tagWWindow *, int width, int height);
	/**
	 * [UEBhE悤ƂƂɌĂяoD
	 * R[obN֐[lԂƃEBhEj󂵂ȂD
	 * [ԂƔj󂷂D
	 */
	int (*close)(struct tagWWindow *);
	void (*destroy)(struct tagWWindow *);

	int num_destructors, alloc_destructors;

	/**
	 * P̃NXp̃EBhEvV[W
	 * ߂l[̂Ƃ wwindow  CallWindowProc ĂԁD
	 */
	int (*chain_wndproc)(struct tagWWindow *, UINT, WPARAM, LPARAM);
	void (**destructor_of_childclass)(void *);

	union{
		void *vp;
		int i;
	}userdata; ///< [Up̃JX^̈

	union{
		void *vp[2];
		int i[2];
		double d;
		Bool8 b[8];
	}childdata[10]; ///< qNXp̗̈
}WWindow;

WWindow *wwindow_new(WApp *);
void wwindow_delete(WWindow *);
void wwindow_validate_callback(WWindow *, ValidateCallback);
void wwindow_regist_destructor(WWindow *_this, void (*func)(void *));

void wwindow_show(WWindow *);
void wwindow_hide(WWindow *);
void wwindow_set_size(WWindow *, int width, int height);

WApp *wwindow_get_wapp(WWindow *);

#define WWINDOW(X) (((WWindow *)(X))->root)


#endif /* H_WWINDOW_H_ */

