/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	(strlcpy|strlcat) شؿ
 *@date		Fri,31 Oct,2008
 *@date		Thu,14 Oct,2010
 *@date		Thu,28 May,2015
 *@author	Copyright(C)2008-2015 G-HAL
 */
#ifndef __ALTERNATIVE_STRLCPY_H__
#define __ALTERNATIVE_STRLCPY_H__

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#include <sys/types.h>


#if (!defined(HAVE_STRICMP) && defined(HAVE_CONFIG_H)) || (!defined(HAVE_CONFIG_H) && !defined(MSDOS))
# define	stricmp		strcasecmp
# define	strnicmp	strncasecmp
#endif


#if (!defined(HAVE_STRLCPY) && defined(HAVE_CONFIG_H)) || defined(NEED_ALTERNATIVE_STRLCPY)
# if defined(HAVE_G_STRLCPY)
#  define	strlcpy	g_strlcpy
# else
#  include <stddef.h>
#  ifdef __cplusplus
extern "C" {
#  endif
extern size_t strlcpy(char *dst, const char *src, size_t size)
		__attribute__ ((__bounded__(__string__,1,3)));
#  ifdef __cplusplus
}
#  endif
#  define	ENABLE_ALTERNATIVE_STRLCPY
# endif
#endif
#if (!defined(HAVE_STRLCAT) && defined(HAVE_CONFIG_H)) || defined(NEED_ALTERNATIVE_STRLCAT)
# if defined(HAVE_G_STRLCAT)
#  define	strlcat	g_strlcat
# else
#  include <stddef.h>
#  ifdef __cplusplus
extern "C" {
#  endif
extern size_t strlcat(char *dst, const char *src, size_t size)
		__attribute__ ((__bounded__(__string__,1,3)));
#  ifdef __cplusplus
}
#  endif
#  define	ENABLE_ALTERNATIVE_STRLCAT
# endif
#endif


#endif /* __ALTERNATIVE_STRLCPY_H__ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
