/**@file
 *
 *@brief	QRL Maker
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Sat,27 Oct,2018
 *@date		Sun,20 Jan,2019
 *@date		Wed,28 Oct,2020
 *@date		Sat,31 Oct,2020
 *@date		Sun,15 Nov,2020
 *@date		Sat,21 Nov,2020
 *@date		Sun,27 Dec,2020
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Sun,21 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Mon,24 May,2021
 *@date		Fri,28 May,2021
 *@date		Sat,29 May,2021
 *@date		Wed,02 Jun,2021
 *@date		Sat,18 Feb,2023
 *
 *@author	Copyright(C)2016-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "qrl.h"
#include "settings.h"
#include "qrlmaker.h"
#include "dialog_inputdialog.h"
#include "ui_dialog_inputdialog.h"
#include <QCoreApplication>
#include <QString>
#include <QTranslator>
#include <QDateTime>
#include <QPoint>
#include <QSize>
#include <QResizeEvent>
#include <QMoveEvent>

Dialog_InputDialog::Dialog_InputDialog(const QRLMaker* const q, Settings::QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::ArgumentType_Kind arg_kind, QWidget *parent) noexcept :
	QDialog(parent),
	ui(new(std::nothrow) Ui::Dialog_InputDialog),
	qrlmaker(NULL)
{
	assert (NULL != q);
	assert (NULL != ui);

	this->qrlmaker = q;

	this->kind = arg_kind;
	if ((this->kind < 0) || (Settings::QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::SENTINEL <= this->kind)) {
		this->kind = Settings::QRLChip_Library::QRL_Syntax::QRL_Header::Argument_Type::SENTINEL;
	}
	this->str = "";
	this->err = false;

	ui->setupUi(this);

	{
		Settings::ini->beginGroup(Settings::AppConfig.get_AppName());

		const QPoint pos  = Settings::SettingsCandidates.dialog_inputdialog_pos ;
		const QSize  size = Settings::SettingsCandidates.dialog_inputdialog_size;

		Settings::ini->endGroup();

		if (!size.isEmpty() && !pos.isNull()) {
			this->resize(size);
			this->move(pos);
		}
	}

	return;
}

Dialog_InputDialog::~Dialog_InputDialog() noexcept
{
	assert (NULL != ui);
	assert (NULL != qrlmaker);

	delete ui;
	return;
}

void Dialog_InputDialog::setParam(const QString& label, const QString* const text) noexcept
{
	const QString datatype = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.ChipArgument, Settings::QRLChipLibrary.Syntax.Header.argument_type_kind[kind].comment);

	const QString msg = QString("<P>%1</P><P>(%2)</P>").arg(label).arg(datatype);
	ui->label->setText(msg);

	if (NULL == text) {
		ui->lineEdit->setText("");
		this->str = "";
	} else {
		ui->lineEdit->setText(*text);
		this->str = *text;
	}
	ui->lineEdit->setFocus();
	this->err = false;
	return;
}

const QString Dialog_InputDialog::getText(void) const noexcept
{
	return this->str;
}

bool Dialog_InputDialog::getErr(void) const noexcept
{
	return this->err;
}

void Dialog_InputDialog::moveEvent(QMoveEvent* const event) noexcept
{
	if (!event->oldPos().isNull() && !event->pos().isNull()) {
		Settings::SettingsCandidates.dialog_inputdialog_pos = event->pos();
	}
	return;
}

void Dialog_InputDialog::resizeEvent(QResizeEvent* const event) noexcept
{
	if (!event->oldSize().isEmpty() && !event->size().isEmpty()) {
		Settings::SettingsCandidates.dialog_inputdialog_size = event->size();
	}
	return;
}

void Dialog_InputDialog::on_buttonBox_accepted(void) noexcept
{
	const QString tmp = ui->lineEdit->text();
	this->str = tmp;
	const bool ret = qrlmaker->QRLLibrary()->check_argumenttype_freestring(kind, tmp);
	if (ret) {
		this->err = false;
		accept();
	} else {
		this->err = true;
		const QString datatype = QCoreApplication::translate(Settings::QRLChipLibrary.tr_context.ChipArgument, Settings::QRLChipLibrary.Syntax.Header.argument_type_kind[kind].comment);
		errmsg = QDateTime::currentDateTime().toString(QObject::tr("ddd,dd MMM,yyyy hh:mm:ss")) + " "
				+ tr("Argument Type Mismatch, Or Contains Characters That Cannot Be Used : %1 -> '%2'").arg(datatype).arg(tmp);
		reject();
	}
	return;
}

void Dialog_InputDialog::on_buttonBox_rejected(void) noexcept
{
	this->err = false;
	reject();
	return;
}
// [ End of File ]
