/**@file
 *
 *@brief	QRL Maker
 *@date		Sat,27 Oct,2018
 *@date		Sun,20 Jan,2019
 *@date		Sun,15 Nov,2020
 *@date		Sat,21 Nov,2020
 *@date		Fri,19 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sun,23 May,2021
 *@date		Sat,29 May,2021
 *@date		Wed,02 Jun,2021
 *
 *@author	Copyright(C)2018-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef DIALOG_LISTDIALOG_H
#define DIALOG_LISTDIALOG_H

#include "qrl.h"
#include "settings.h"
#include "qrlmaker.h"
#include <QDialog>
#include <QString>
#include <QStringList>
#include <QResizeEvent>
#include <QMoveEvent>

namespace Ui {
class Dialog_ListDialog;
}

class Dialog_ListDialog : public QDialog
{
	Q_OBJECT

public:
	explicit Dialog_ListDialog(const QRLMaker* const q, const QStringList* const arg_list, QWidget *parent = 0) noexcept;
	~Dialog_ListDialog() noexcept;

	void setParam(const QString& label, const QString* const text) noexcept;
	const QString getText(void) const noexcept;
	bool getErr(void) const noexcept;
	QString getErrMsg(void) noexcept;

protected:
	void moveEvent(QMoveEvent* const event) noexcept;
	void resizeEvent(QResizeEvent* const event) noexcept;

private slots:
	void on_buttonBox_accepted(void) noexcept;
	void on_buttonBox_rejected(void) noexcept;

private:
	Ui::Dialog_ListDialog *ui;

	const QRLMaker* qrlmaker;

	const QStringList* list;
	QString str;
	bool err;
	QString errmsg;
};



inline QString Dialog_ListDialog::getErrMsg(void) noexcept
{
	return std::move(this->errmsg);
}

#endif // DIALOG_LISTDIALOG_H
// [ End of File ]
