/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015
 *@date		Mon,21 Sep,2015
 *@date		Sat,03 Oct,2015 - Mon,12 Oct,2015
 *@date		Tue,13 Oct,2015 - Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Thu,29 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sun,10 Jan,2016 - Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016
 *@date		Sun,09 Jul,2017
 *@date		Sun,16 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,17 Mar,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018 - Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Sat,19 Jan,2019
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Thu,19 Nov,2020
 *@date		Sun,29 Nov,2020
 *@date		Sun,27 Dec,2020
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Sun,21 Feb,2021
 *@date		Mon,22 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Thu,03 Jun,2021
 *@date		Fri,04 Jun,2021
 *@date		Sun,06 Jun,2021
 *@date		Sun,13 Jun,2021
 *@date		Mon,14 Jun,2021
 *@date		Wed,13 Jul,2022
 *@date		Sat,16 Jul,2022
 *@date		Wed,04 Jan,2023
 *@date		Fri,28 Apr,2023
 *@date		Sun,25 Jun,2023
 *@date		Thu,02 Nov,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef FORM_MAINFORM_H
#define FORM_MAINFORM_H

#include <cstdint>
#include <math.h>
#include "settings.h"
#include "qrlmaker.h"
#include "mapeditor.h"
#include "imagebuilder.h"
#include "qrl.h"
#include "mainwindow.h"
#include <QString>
#include <QWidget>
#include <QPoint>
#include <QPaintEvent>
#include <QFocusEvent>
#include <QMouseEvent>
#include <QKeyEvent>
#include <QTimer>
#include "xy_.h"

namespace Ui {
class Form_MainForm;
}

class Form_MainForm : public QWidget
{
	Q_OBJECT

public:
	explicit Form_MainForm(QWidget* parent = 0) noexcept;
	~Form_MainForm(void) noexcept;

	void setMainWindow(QRLMaker* const q, MainWindow* const mw) noexcept;

	bool action_new(void) noexcept;
	bool action_open(QString& filename) noexcept;
	bool action_import(QString& filename) noexcept;
	bool action_save(QString& filename) noexcept;

	void select_form_treeitem_name(const QString& msg, const QString& msg_tr) noexcept;
	void select_form_treeitem(enum Settings::EditorCommand::EditorCommand_TYPE mode_arg, const QRL::QRLChipLibrary* const chip) noexcept;
	bool action_cancel(void) noexcept;
	bool action_selectall(void) noexcept;
	bool action_unselectall(void) noexcept;
	bool action_undo(void) noexcept;
	bool action_redo(void) noexcept;
	bool action_cut(void) noexcept;
	bool action_copy(void) noexcept;
	bool action_paste(void) noexcept;
	bool action_delete(void) noexcept;

	int_fast8_t get_undo_count(void) const noexcept;
	int_fast8_t get_redo_count(void) const noexcept;
	const QString get_undo_msg(const int_fast8_t buf_ptr) const noexcept;
	const QString get_redo_msg(const int_fast8_t buf_ptr) const noexcept;
	int_fast8_t get_undo_ptr(void) const noexcept;

public slots:
	void scale_changed(float value) noexcept;
	void position_changed_x(int value) noexcept;
	void position_changed_y(int value) noexcept;

protected:
	void paintEvent(QPaintEvent* const e) noexcept;
	void focusInEvent(QFocusEvent* const e) noexcept;
	void mousePressEvent(QMouseEvent* const pEvent) noexcept;
	void mouseMoveEvent(QMouseEvent* const pEvent) noexcept;
	void mouseReleaseEvent(QMouseEvent* const pEvent) noexcept;
	void wheelEvent(QWheelEvent* const pEvent) noexcept;
	void timerEvent(QTimerEvent* const tEvent) noexcept;
	void keyPressEvent(QKeyEvent* const event) noexcept;

private:
	QRLMaker* qrlmaker;

	MapEditor* mapeditor;
	ImageBuilder_QRLMap_DisplayImage* display_img;
	ImageBuilder_QRLMap_SaveImage* save_img;

	int blink_color;
  #if defined(DEBUG)
	int blink_counter;
	int blink_counter_direction;
	qint64 interval_timer_basetime;
	QTimer* interval_timer;
  #endif

	QTimer* mouse_timer;
	QMouseEvent* mousePress_PendingEvent;
	QMouseEvent* mouseRelease_PendingEvent;
	bool mouse_waiting_timeout;
	int mouse_press_count;
	int mouse_release_count;

	void mouseTimeout(void) noexcept;
	void mouseExecPendingEvent(void) noexcept;
	void mousePressUserEvent(QMouseEvent* const pEvent) noexcept;
	void mouseMoveUserEvent(QMouseEvent* const pEvent) noexcept;
	void mouseReleaseUserEvent(QMouseEvent* const pEvent) noexcept;
	void mouseDoubleClickUserEvent(QMouseEvent* const pEvent) noexcept;

	QRL::ChipAddr mouseptr2chipaddr_x(int_fast32_t ptr_x) const noexcept;
	QRL::ChipAddr mouseptr2chipaddr_y(int_fast32_t ptr_y) const noexcept;
	QRL::ChipAddrXY mouseptr2arrowaddr(const XY_<int_fast32_t>& ptr, QRL::ChipArrow* const arrow) const noexcept;

	int_fast8_t get_argument_num_of_chip(const QRL::QRLChipLibrary* const chip, const XY_<int_fast16_t>& ofs, const XY_<int_fast8_t>& adj) const noexcept;
	int_fast8_t get_argument_num_on_image(const struct QRL::ChipAddrXY& cur_chipaddr, const XY_<int_fast32_t>& cur) const noexcept;
	void buildImage(enum MapEditor_Type::MouseMode mouse) noexcept;
	void buildImage(enum MapEditor_Type::MouseMode mouse, const QRL::ChipAddrXY& chip_ptr, const XY_<int_fast32_t>& mouse_ptr, QString* const msg) noexcept;
	void showStatusMessage(const struct QRL::ChipAddrXY& cur_chipaddr) noexcept;
	void showStatusMessage(const XY_<int_fast32_t>& cur) noexcept;

	void relocation_scrollbar(void) noexcept;

	MainWindow* mainwindow;
	QString selected_form_treeitem_name;
	QString selected_form_treeitem_name_tr;

	bool needRefresh;
	QPoint dragStartPosition;
	XY_<int> sliderPosition;

	struct {
		bool flag;
		int id;
		XY_<int_fast32_t> mouse_ptr;
		bool with_ctrl;
		int_fast8_t x;
		int_fast8_t y;
	} dragscroll;

	struct {
		float scaling;
		XY_<int_fast16_t> ofs;
	} old_screen, cur_screen;

	struct QRL::ChipAddrXY old_chipaddr;

	enum Settings::EditorCommand::EditorCommand_TYPE mode;

	struct QRL::ChipAddrXY focus_addr;
};



inline int_fast8_t Form_MainForm::get_undo_count(void) const noexcept
{
	return mapeditor->QRLMap_().get_undo_count();
}

inline int_fast8_t Form_MainForm::get_redo_count(void) const noexcept
{
	return mapeditor->QRLMap_().get_redo_count();
}

inline const QString Form_MainForm::get_undo_msg(const int_fast8_t buf_ptr) const noexcept
{
	return mapeditor->QRLMap_().get_undo_msg(buf_ptr);
}

inline const QString Form_MainForm::get_redo_msg(const int_fast8_t buf_ptr) const noexcept
{
	return mapeditor->QRLMap_().get_redo_msg(buf_ptr);
}

inline int_fast8_t Form_MainForm::get_undo_ptr(void) const noexcept
{
	return mapeditor->QRLMap_().get_undo_ptr();
}

inline void Form_MainForm::select_form_treeitem_name(const QString& msg, const QString& msg_tr) noexcept
{
	selected_form_treeitem_name = msg;
	selected_form_treeitem_name_tr = msg_tr;
	return;
}

#endif // FORM_MAINFORM_H
// [ End of File ]
