/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sun,30 Dec,2018
 *@date		Mon,31 Dec,2018
 *@date		Mon,21 Jan,2019
 *@date		Fri,25 Jan,2019
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Thu,31 Jan,2019
 *@date		Sun,29 Nov,2020
 *@date		Fri,19 Feb,2021
 *@date		Sat,20 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *@date		Wed,13 Jul,2022
 *@date		Sun,25 Jun,2023
 *
 *@author	Copyright(C)2015-2023 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include <stdio.h>
#include <string.h>
#include "settings.h"
#include "mapeditor.h"
#include "imagebuilder.h"
#include "form_mainform.h"
#include "mytypes.h"
#include "qrl.h"
#include "qrlmap.h"
#include <QString>
#include <QStringList>
#include <QColor>
#include "xy_.h"

void Form_MainForm::buildImage(enum MapEditor_Type::MouseMode mouse) noexcept
{
	const QRL::ChipAddrXY chip_ptr = {
		.x = -1,
		.y = -1,
	};
	const XY_<int_fast32_t> mouse_ptr = {
		.x = -1,
		.y = -1,
	};
	buildImage(mouse, chip_ptr, mouse_ptr, NULL);
	return;
}

void Form_MainForm::buildImage(enum MapEditor_Type::MouseMode mouse, const QRL::ChipAddrXY& chip_ptr, const XY_<int_fast32_t>& mouse_ptr, QString* const msg) noexcept
{
	display_img->CalcScreenParam();
	const XY_<int_fast32_t> screen_size = {
		.x = this->width(),
		.y = this->height(),
	};
	const bool chip_ptr_enable = ((0 <= chip_ptr.x) && (0 <= chip_ptr.y));
	const struct QRL::ChipAddrXY cur_chipaddr = {
		.x = (chip_ptr_enable ? chip_ptr.x : mouseptr2chipaddr_x(mouse_ptr.x)),
		.y = (chip_ptr_enable ? chip_ptr.y : mouseptr2chipaddr_y(mouse_ptr.y)),
	};
	QRL::ChipArrow arrow;
	const struct QRL::ChipAddrXY cur_arrowaddr = mouseptr2arrowaddr(mouse_ptr, &arrow);
	const int_fast8_t pointed_argument_num = get_argument_num_on_image(cur_chipaddr, mouse_ptr);

	if (display_img->scaling() != this->old_screen.scaling) {
		display_img->ResetImage();
		this->cur_screen.scaling = display_img->scaling();
		this->needRefresh = true;
	}

	if ((0 <= mouse_ptr.x) && (0 <= mouse_ptr.y)) {
		focus_addr = cur_chipaddr;
	}

	// Draw the Item(s)
	this->needRefresh |= mapeditor->EditCommand(this->mode, mouse, cur_chipaddr, arrow, pointed_argument_num, msg);

	// Make Base Image
	if (this->needRefresh) {
		display_img->MakeBaseImage(blink_color);
		this->needRefresh = false;
	}

	{ // Draw Overlay Images
		display_img->MakeOverlayImage(blink_color, this->mode, mouse, screen_size, this->cur_screen.ofs, cur_chipaddr, arrow, cur_arrowaddr, focus_addr);

		memcpy(&(this->old_screen), &(this->cur_screen), sizeof(this->old_screen));
		memcpy(&(this->old_chipaddr), &(cur_chipaddr), sizeof(this->old_chipaddr));
	}

	{ // Make Display Image
		display_img->MakeDisplayImage(screen_size, this->cur_screen.ofs);
	}

	showStatusMessage(cur_chipaddr);

	this->update();

	return;
}
// [ End of File ]
