/**@file
 *
 *@brief	QRL Maker
 *@date		Sat,17 Mar,2018
 *@date		Mon,24 Dec,2018
 *@date		Sat,29 Dec,2018
 *@date		Sat,20 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2018-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QPoint>
#include <QCursor>

void MainWindow::contextmenu_Cancel(void) noexcept
{
	ui->form_mainform->action_cancel();
	return;
}

void MainWindow::contextmenu_Normal(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::NORMAL);
	return;
}

void MainWindow::contextmenu_Select(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::SELECT);
	return;
}

void MainWindow::contextmenu_Rectangular(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::RECTANGULAR);
	return;
}

void MainWindow::contextmenu_Cut(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::CUT);
	return;
}

void MainWindow::contextmenu_Paste(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::PASTE);
	return;
}

void MainWindow::contextmenu_Delete(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::DELETE);
	return;
}

void MainWindow::contextmenu_SetArrowTrue(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::SET_ARROW_TRUE);
	return;
}

void MainWindow::contextmenu_SetArrowFalse(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::SET_ARROW_FALSE);
	return;
}

void MainWindow::contextmenu_EditArgument(void) noexcept
{
	select_form_treeitem(Settings::EditorCommand::EDIT_ARGUMENT);
	return;
}

void MainWindow::on_form_mainform_customContextMenuRequested(_unused const QPoint& pos) noexcept
{
	Form_MainFormContextMenu.exec(QCursor::pos());
	return;
}
// [ End of File ]
