/**@file
 *
 *@brief	QRL Maker
 *@date		Sun,31 May,2015 - Tue,08 Sep,2015
 *@date		Fri,11 Sep,2015 - Sat,19 Sep,2015
 *@date		Sun,20 Sep,2015
 *@date		Sat,03 Oct,2015 - Sat,10 Oct,2015
 *@date		Tue,13 Oct,2015 - Thu,15 Oct,2015
 *@date		Sun,18 Oct,2015
 *@date		Thu,22 Oct,2015 - Sun,25 Oct,2015
 *@date		Mon,26 Oct,2015
 *@date		Wed,28 Oct,2015
 *@date		Sat,31 Oct,2015
 *@date		Sat,07 Nov,2015
 *@date		Mon,11 Jan,2016
 *@date		Thu,11 Feb,2016 - Sun,14 Feb,2016
 *@date		Sun,16 Apr,2017
 *@date		Sun,09 Jul,2017
 *@date		Sat,15 Jul,2017
 *@date		Sun,16 Jul,2017 - Mon,17 Jul,2017
 *@date		Sun,23 Jul,2017
 *@date		Wed,26 Jul,2017
 *@date		Thu,27 Jul,2017
 *@date		Sat,05 Aug,2017
 *@date		Sat,17 Mar,2018
 *@date		Mon,16 Jul,2018
 *@date		Sat,21 Jul,2018
 *@date		Sat,27 Oct,2018
 *@date		Fri,23 Nov,2018
 *@date		Tue,27 Nov,2018 - Thu,29 Nov,2018
 *@date		Sat,15 Dec,2018
 *@date		Fri,21 Dec,2018
 *@date		Sat,22 Dec,2018
 *@date		Mon,24 Dec,2018
 *@date		Fri,28 Dec,2018
 *@date		Sun,27 Jan,2019
 *@date		Tue,29 Jan,2019
 *@date		Mon,11 Mar,2019
 *@date		Thu,18 Feb,2021
 *@date		Fri,19 Feb,2021
 *@date		Tue,23 Feb,2021
 *@date		Sat,29 May,2021
 *
 *@author	Copyright(C)2015-2021 G-HAL. All rights reserved.
 *
 */
/**\mainpage
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the copyright holders nor the names of its contributors
 may be used to endorse or promote products derived from this software
 without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <assert.h>
#include <cstdint>
#include <stdio.h>
#include <string.h>
#include "settings.h"
#include "form_mainform.h"
#include "mytypes.h"
#include "qrl.h"
#include "xy_.h"

QRL::ChipAddr Form_MainForm::mouseptr2chipaddr_x(int_fast32_t ptr_x) const noexcept
{
	if (ptr_x < display_img->ScreenParam()->gauge.x) { return 0; }
	const QRL::ChipAddr x1 = ((ptr_x - display_img->ScreenParam()->gauge.x) / display_img->ScreenParam()->scs.x + this->cur_screen.ofs.x);
	if (Settings::BuildImage.Chip.Count.x <= x1) { return (Settings::BuildImage.Chip.Count.x - 1); }
	const int_fast16_t x1r = ((ptr_x - display_img->ScreenParam()->gauge.x) % display_img->ScreenParam()->scs.x);
	if (x1r < (display_img->ScreenParam()->gap.x / 2)) {
		return (1 <= x1) ? (x1 - 1) : 0;
	}
	return x1;
}

QRL::ChipAddr Form_MainForm::mouseptr2chipaddr_y(int_fast32_t ptr_y) const noexcept
{
	if (ptr_y < display_img->ScreenParam()->gauge.y) { return 0; }
	const QRL::ChipAddr y1 = ((ptr_y - display_img->ScreenParam()->gauge.y) / display_img->ScreenParam()->scs.y + this->cur_screen.ofs.y);
	if (Settings::BuildImage.Chip.Count.y <= y1) { return (Settings::BuildImage.Chip.Count.y - 1); }
	const int_fast16_t y1r = ((ptr_y - display_img->ScreenParam()->gauge.y) % display_img->ScreenParam()->scs.y);
	if (y1r < (display_img->ScreenParam()->gap.y / 2)) {
		return (1 <= y1) ? (y1 - 1) : 0;
	}
	return y1;
}

QRL::ChipAddrXY Form_MainForm::mouseptr2arrowaddr(const XY_<int_fast32_t>& ptr, QRL::ChipArrow* const arrow) const noexcept
{
	assert (NULL != arrow);

	QRL::ChipAddrXY ret;

	if (ptr.x < display_img->ScreenParam()->gauge.x) {
		ret.x = -1;
	} else {
		ret.x = ((ptr.x - display_img->ScreenParam()->gauge.x) / display_img->ScreenParam()->scs.x + this->cur_screen.ofs.x);
		if (Settings::BuildImage.Chip.Count.x <= ret.x) {
			ret.x = -1;
		}
	}

	if (ptr.y < display_img->ScreenParam()->gauge.y) {
		ret.y = -1;
	} else {
		ret.y = ((ptr.y - display_img->ScreenParam()->gauge.y) / display_img->ScreenParam()->scs.y + this->cur_screen.ofs.y);
		if (Settings::BuildImage.Chip.Count.y <= ret.y) {
			ret.y = -1;
		}
	}

	const int_fast16_t x1r = ((ptr.x - display_img->ScreenParam()->gauge.x) % display_img->ScreenParam()->scs.x);
	const int_fast16_t y1r = ((ptr.y - display_img->ScreenParam()->gauge.y) % display_img->ScreenParam()->scs.y);
	const int_fast16_t ofs_x = x1r - display_img->ScreenParam()->gap.x - (display_img->ScreenParam()->core.x / 2);
	const int_fast16_t ofs_y = y1r - display_img->ScreenParam()->gap.y - (display_img->ScreenParam()->core.y / 2);
	(*arrow) = QRL::ChipArrow_MIN;
	if (x1r < display_img->ScreenParam()->gap.x) {
		if (y1r < display_img->ScreenParam()->gap.y) {
			(*arrow) = QRL::ChipArrow_MIN;
		} else {
			if (ofs_y < 0) {
				(*arrow) = QRL::ChipArrow_LEFT;
			} else {
				ret.x -= 1;
				(*arrow) = QRL::ChipArrow_RIGHT;
			}
		}
	} else if (y1r < display_img->ScreenParam()->gap.y) {
		if (ofs_x < 0) {
			ret.y -= 1;
			(*arrow) = QRL::ChipArrow_DOWN;
		} else {
			(*arrow) = QRL::ChipArrow_UP;
		}

	} else {
		if (0 <= ofs_x) {
			if (0 <= ofs_y) {
				if ((ofs_y * 2) <= ofs_x) {
					(*arrow) = QRL::ChipArrow_RIGHT;
				} else if ((ofs_x * 2) <= ofs_y) {
					(*arrow) = QRL::ChipArrow_DOWN;
				} else {
					(*arrow) = QRL::ChipArrow_DOWNRIGHT;
				}
			} else {
				if ((-ofs_y * 2) <= ofs_x) {
					(*arrow) = QRL::ChipArrow_RIGHT;
				} else if ((ofs_x * 2) <= -ofs_y) {
					(*arrow) = QRL::ChipArrow_UP;
				} else {
					(*arrow) = QRL::ChipArrow_UPRIGHT;
				}
			}
		} else {
			if (0 <= ofs_y) {
				if ((ofs_y * 2) <= -ofs_x) {
					(*arrow) = QRL::ChipArrow_LEFT;
				} else if ((-ofs_x * 2) <= ofs_y) {
					(*arrow) = QRL::ChipArrow_DOWN;
				} else {
					(*arrow) = QRL::ChipArrow_DOWNLEFT;
				}
			} else {
				if ((-ofs_y * 2) <= -ofs_x) {
					(*arrow) = QRL::ChipArrow_LEFT;
				} else if ((-ofs_x * 2) <= -ofs_y) {
					(*arrow) = QRL::ChipArrow_UP;
				} else {
					(*arrow) = QRL::ChipArrow_UPLEFT;
				}
			}
		}
	}

	return ret;
}
// [ End of File ]
